/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.dongliu.commons.Predications;

public class ByteBufferOutputStream
extends OutputStream {
    private final boolean direct;
    private boolean closed;
    private ByteBuffer buffer;

    public ByteBufferOutputStream(boolean direct) {
        this.direct = direct;
        this.closed = false;
        this.buffer = this.allocate(256);
    }

    public synchronized ByteBuffer getBuffer() {
        if (!this.closed) {
            throw new IllegalStateException("stream not closed yet");
        }
        return this.buffer;
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.checkClosed();
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        Predications.checkArrayRange(b, off, len);
        this.checkClosed();
        if (this.buffer.remaining() < len) {
            this.expand(Math.addExact(this.buffer.position(), len));
        }
        this.buffer.put(b, off, len);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.checkClosed();
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.buffer.flip();
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.checkClosed();
        if (this.buffer.remaining() < 1) {
            this.expand(Math.addExact(this.buffer.position(), 1));
        }
        this.buffer.put((byte)b);
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed.");
        }
    }

    private void expand(int size) {
        int newSize;
        for (newSize = this.buffer.capacity(); newSize < size; newSize <<= 1) {
        }
        ByteBuffer newBuffer = this.allocate(newSize);
        this.buffer.flip();
        newBuffer.put(this.buffer);
        this.buffer = newBuffer;
    }

    private ByteBuffer allocate(int size) {
        return this.direct ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
    }
}

