/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.io;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Buffers {
    public static void advance(Buffer buffer, int step) {
        if (step < -buffer.position() || step > buffer.remaining()) {
            throw new BufferOverflowException();
        }
        buffer.position(buffer.position() + step);
    }

    public static ByteBuffer slice(ByteBuffer buffer) {
        ByteOrder order = buffer.order();
        return buffer.slice().order(order);
    }

    public static short getUByte(ByteBuffer buffer) {
        return (short)(buffer.get() & 0xFF);
    }

    public static int getUShort(ByteBuffer buffer) {
        return buffer.getShort() & 0xFFFF;
    }

    public static long getUInt(ByteBuffer buffer) {
        return (long)buffer.getInt() & 0xFFFFFFFFL;
    }

    public static int ensureGetUInt(ByteBuffer buffer) {
        int v = buffer.getInt();
        if (v < 0) {
            throw new ArithmeticException("overflow unsigned long");
        }
        return v;
    }

    public static long ensureGetULong(ByteBuffer buffer) {
        long v = buffer.getLong();
        if (v < 0L) {
            throw new ArithmeticException("overflow unsigned long");
        }
        return v;
    }
}

