/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.concurrent;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class Threads {
    public static Thread start(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.start();
        return thread;
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Thread thread = new Thread(() -> {
            try {
                runnable.run();
                future.complete(null);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        thread.start();
        return future;
    }

    public static <T> CompletableFuture<T> callAsync(Callable<T> callable) {
        CompletableFuture future = new CompletableFuture();
        Thread thread = new Thread(() -> {
            try {
                Object result = callable.call();
                future.complete(result);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        thread.start();
        return future;
    }

    public static void sleep(Duration duration) {
        if (duration.compareTo(Duration.ZERO) < 0) {
            throw new IllegalArgumentException("timeout value is negative: " + duration);
        }
        Threads.sleepNanos(duration.toNanos());
    }

    public static void sleepSeconds(double seconds) {
        if (seconds < 0.0) {
            throw new IllegalArgumentException("timeout value is negative: " + seconds);
        }
        Threads.sleepNanos((long)(seconds * 1.0E9));
    }

    public static void sleepMills(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("timeout value is negative: " + millis);
        }
        Threads.sleepNanos(TimeUnit.MILLISECONDS.toNanos(millis));
    }

    public static void sleepNanos(long nanos) {
        if (nanos < 0L) {
            throw new IllegalArgumentException("timeout value is negative: " + nanos);
        }
        if (nanos == 0L) {
            return;
        }
        long untilNanos = System.nanoTime() + nanos;
        long toSleepNanos = nanos;
        boolean interrupted = false;
        do {
            try {
                TimeUnit.NANOSECONDS.sleep(toSleepNanos);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while ((toSleepNanos = untilNanos - System.nanoTime()) > 0L);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

