/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.concurrent;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import net.dongliu.commons.concurrent.ThreadFactories;

public class ThreadPoolBuilder {
    private int corePoolSize = 0;
    private int maxPoolSize = Integer.MAX_VALUE;
    private Duration keepAliveTime = Duration.ofSeconds(30L);
    private boolean allowCoreThreadTimeOut = false;
    private Supplier<BlockingQueue<Runnable>> workingQueue = LinkedBlockingQueue::new;
    private Supplier<ThreadFactory> threadFactory = () -> ThreadFactories.newDaemonThreadFactory("thread-pool-" + poolSeq.incrementAndGet());
    private Supplier<RejectedExecutionHandler> rejectedHandler = ThreadPoolExecutor.AbortPolicy::new;
    private TaskExceptionListener taskExceptionListener = null;
    private static final AtomicLong poolSeq = new AtomicLong();

    ThreadPoolBuilder() {
    }

    public ThreadPoolExecutor build() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAliveTime.toMillis(), TimeUnit.MILLISECONDS, this.workingQueue.get(), this.threadFactory.get(), this.rejectedHandler.get()){
            private final TaskExceptionListener listener;
            {
                this.listener = ThreadPoolBuilder.this.taskExceptionListener;
            }

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                if (this.listener == null) {
                    return;
                }
                if (t == null && r instanceof Future && ((Future)((Object)r)).isDone()) {
                    try {
                        ((Future)((Object)r)).get();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (CancellationException e) {
                        t = e;
                    }
                    catch (ExecutionException e) {
                        t = e.getCause();
                    }
                }
                if (t != null) {
                    this.listener.onException(r, t);
                }
            }
        };
        executor.allowCoreThreadTimeOut(this.allowCoreThreadTimeOut);
        return executor;
    }

    public ThreadPoolBuilder poolSize(int corePoolSize, int maxPoolSize) {
        if (corePoolSize < 0 || maxPoolSize < corePoolSize || maxPoolSize < 1) {
            throw new IllegalArgumentException("core pool size: " + corePoolSize + ", max pool size: " + maxPoolSize);
        }
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public ThreadPoolBuilder keepAliveTime(Duration keepAliveTime) {
        this.keepAliveTime = Objects.requireNonNull(keepAliveTime);
        return this;
    }

    public ThreadPoolBuilder workingQueue(BlockingQueue<Runnable> workingQueue) {
        Objects.requireNonNull(workingQueue);
        this.workingQueue = () -> workingQueue;
        return this;
    }

    public ThreadPoolBuilder threadFactory(ThreadFactory threadFactory) {
        Objects.requireNonNull(threadFactory);
        this.threadFactory = () -> threadFactory;
        return this;
    }

    public ThreadPoolBuilder rejectedHandler(RejectedExecutionHandler rejectedHandler) {
        Objects.requireNonNull(rejectedHandler);
        this.rejectedHandler = () -> rejectedHandler;
        return this;
    }

    public ThreadPoolBuilder allowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
        return this;
    }

    public ThreadPoolBuilder taskExceptionListener(TaskExceptionListener listener) {
        this.taskExceptionListener = Objects.requireNonNull(listener);
        return this;
    }

    public static interface TaskExceptionListener {
        public void onException(Runnable var1, Throwable var2);
    }
}

