/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.io.Serializable;

public class Triple<A, B, C>
implements Serializable {
    private static final long serialVersionUID = -6791546755492843197L;
    private final A first;
    private final B second;
    private final C third;

    private Triple(A first, B second, C third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public static <A, B, C> Triple<A, B, C> of(A first, B second, C third) {
        return new Triple<A, B, C>(first, second, third);
    }

    public Triple<A, B, C> withFirst(A first) {
        return new Triple<A, B, C>(first, this.second, this.third);
    }

    public Triple<A, B, C> withSecond(B second) {
        return new Triple<A, B, C>(this.first, second, this.third);
    }

    public Triple<A, B, C> withThrid(C third) {
        return new Triple<A, B, C>(this.first, this.second, third);
    }

    public A first() {
        return this.first;
    }

    public B second() {
        return this.second;
    }

    public C third() {
        return this.third;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Triple triple = (Triple)o;
        if (this.first != null ? !this.first.equals(triple.first) : triple.first != null) {
            return false;
        }
        if (this.second != null ? !this.second.equals(triple.second) : triple.second != null) {
            return false;
        }
        return this.third != null ? this.third.equals(triple.third) : triple.third == null;
    }

    public int hashCode() {
        int result = this.first != null ? this.first.hashCode() : 0;
        result = 31 * result + (this.second != null ? this.second.hashCode() : 0);
        result = 31 * result + (this.third != null ? this.third.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ", " + this.third + ')';
    }
}

