/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.io.Serializable;
import java.util.Map;
import net.dongliu.commons.collection.Triple;

public class Pair<K, V>
implements Map.Entry<K, V>,
Serializable {
    private static final long serialVersionUID = -6468644647295390377L;
    private final K key;
    private final V value;

    private Pair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public static <K, V> Pair<K, V> of(K key, V value) {
        return new Pair<K, V>(key, value);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    public Pair<K, V> withKey(K newKey) {
        return new Pair<K, V>(newKey, this.value);
    }

    public Pair<K, V> withValue(V newValue) {
        return new Pair<K, V>(this.key, newValue);
    }

    public K first() {
        return this.key;
    }

    public V second() {
        return this.value;
    }

    public Pair<K, V> withFirst(K first) {
        return new Pair<K, V>(first, this.second());
    }

    public Pair<K, V> withSecond(V second) {
        return new Pair<K, V>(this.first(), second);
    }

    public <C> Triple<K, V, C> append(C third) {
        return Triple.of(this.first(), this.second(), third);
    }

    public <A> Triple<A, K, V> prepend(A value) {
        return Triple.of(value, this.first(), this.second());
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        if (this.key != null ? !this.key.equals(pair.key) : pair.key != null) {
            return false;
        }
        return this.value != null ? this.value.equals(pair.value) : pair.value == null;
    }

    @Override
    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "(" + this.key + ", " + this.value + ")";
    }
}

