/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Maps {
    private static final int DEFAULT_INIT_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static <K, V> Map<K, V> nullToEmpty(@Nullable Map<K, V> map) {
        if (map == null) {
            return Collections.emptyMap();
        }
        return map;
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    @SafeVarargs
    public static <K, V> HashMap<K, V> newHashMap(Map.Entry<? extends K, ? extends V> ... entries) {
        return Maps.newMap(HashMap::new, entries);
    }

    public static <V> Map<String, V> newCaseInsensitiveMap() {
        return new TreeMap(String.CASE_INSENSITIVE_ORDER);
    }

    @SafeVarargs
    public static <V> Map<String, V> newCaseInsensitiveMap(Map.Entry<String, ? extends V> ... entries) {
        return Maps.newMap(Maps::newCaseInsensitiveMap, entries);
    }

    @SafeVarargs
    public static <K, V, R extends Map<K, V>> R newMap(Supplier<R> supplier, Map.Entry<? extends K, ? extends V> ... entries) {
        Map map = (Map)supplier.get();
        for (Map.Entry<K, V> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return (R)map;
    }

    public static <K, V> Map<K, V> of() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> of(Map.Entry<? extends K, ? extends V> entry) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(entry.getKey(), entry.getValue());
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(Map.Entry<? extends K, ? extends V> entry1, Map.Entry<? extends K, ? extends V> entry2) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(entry1.getKey(), entry1.getValue());
        map.put(entry2.getKey(), entry2.getValue());
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(Map.Entry<? extends K, ? extends V> entry1, Map.Entry<? extends K, ? extends V> entry2, Map.Entry<? extends K, ? extends V> entry3) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(entry1.getKey(), entry1.getValue());
        map.put(entry2.getKey(), entry2.getValue());
        map.put(entry3.getKey(), entry3.getValue());
        return Collections.unmodifiableMap(map);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> of(Map.Entry<? extends K, ? extends V> ... entries) {
        return Collections.unmodifiableMap(Maps.newHashMap(entries));
    }

    public static <K, R, V, U> Map<R, U> convert(Map<? extends K, ? extends V> map, Function<? super K, ? extends R> keyMapper, Function<? super V, ? extends U> valueMapper) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(valueMapper);
        if (map.isEmpty()) {
            return Maps.of();
        }
        HashMap result = new HashMap();
        map.forEach((k, v) -> result.put(keyMapper.apply((Object)k), valueMapper.apply((Object)v)));
        return Collections.unmodifiableMap(result);
    }

    public static <K, V, U> Map<K, U> convert(Map<? extends K, ? extends V> map, Function<? super V, ? extends U> valueMapper) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(valueMapper);
        return Maps.convert(map, k -> k, valueMapper);
    }

    public static <K, V> Map<K, V> filter(Map<? extends K, ? extends V> map, BiPredicate<? super K, ? super V> predicate) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(predicate);
        if (map.isEmpty()) {
            return Maps.of();
        }
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!predicate.test(entry.getKey(), entry.getValue())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> Map<K, V> merge(Map<? extends K, ? extends V> map1, Map<? extends K, ? extends V> map2) {
        Objects.requireNonNull(map1);
        Objects.requireNonNull(map2);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.putAll(map1);
        map.putAll(map2);
        return Collections.unmodifiableMap(map);
    }

    public static <T, K, V> Map<K, V> from(Collection<? extends T> elements, Function<? super T, ? extends K> keyRetriever, Function<? super T, ? extends V> valueMaker) {
        Objects.requireNonNull(elements);
        Objects.requireNonNull(valueMaker);
        if (elements.isEmpty()) {
            return Maps.of();
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (T e : elements) {
            map.put(keyRetriever.apply(e), valueMaker.apply(e));
        }
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> fromKeys(Collection<? extends K> keys, Function<? super K, ? extends V> valueMaker) {
        return Maps.from(keys, Function.identity(), valueMaker);
    }

    public static <K, V> Map<K, V> fromValues(Collection<? extends V> values, Function<? super V, ? extends K> keyRetriever) {
        return Maps.from(values, keyRetriever, Function.identity());
    }
}

