/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Optional;

public class Throwables {
    public static RuntimeException sneakyThrow(Throwable t) {
        Objects.requireNonNull(t);
        return Throwables.throwInternal(t);
    }

    private static <T extends Throwable> RuntimeException throwInternal(Throwable t) throws T {
        throw t;
    }

    public static void throwIfUnchecked(Throwable throwable) {
        Objects.requireNonNull(throwable);
        Throwables.throwIf(throwable, RuntimeException.class);
        Throwables.throwIf(throwable, Error.class);
    }

    public static <T extends Throwable> void throwIf(Throwable throwable, Class<T> cls) throws T {
        Objects.requireNonNull(throwable);
        if (cls.isAssignableFrom(throwable.getClass())) {
            throw throwable;
        }
    }

    public static Throwable getRootCause(Throwable throwable) {
        Objects.requireNonNull(throwable);
        Throwable cause;
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
        }
        return throwable;
    }

    public static <T extends Throwable> Optional<T> getCauseOf(Throwable throwable, Class<T> cls) {
        Objects.requireNonNull(throwable);
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            if (!cls.isAssignableFrom(cause.getClass())) continue;
            return Optional.of(cause);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getStackTrace(Throwable t) {
        Objects.requireNonNull(t);
        try (StringWriter writer = new StringWriter();){
            PrintWriter pw = new PrintWriter(writer);
            try {
                t.printStackTrace(pw);
                pw.flush();
                String string = writer.toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

