/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Objects;
import net.dongliu.commons.exception.UnknownSpecificationVersionException;

public class Sys {
    public static String javaSpecVersionName() {
        return System.getProperty("java.specification.version");
    }

    public static SpecificationVersion javaSpecVersion() {
        return SpecVersionHolder.specVersion;
    }

    public static String javaVersionName() {
        return System.getProperty("java.version");
    }

    public static String osName() {
        return System.getProperty("os.name");
    }

    public static OSType osType() {
        return OSTypeHolder.osType;
    }

    public static String userName() {
        return System.getProperty("user.name");
    }

    public static String userHome() {
        return System.getProperty("user.home");
    }

    public static Path userHomePath() {
        return Paths.get(System.getProperty("user.home"), new String[0]);
    }

    public static String workDir() {
        return System.getProperty("user.dir");
    }

    public static Path workDirPath() {
        return Paths.get(System.getProperty("user.dir"), new String[0]);
    }

    public static String lineSeparator() {
        return System.lineSeparator();
    }

    public static String tmpDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static Path tmpDirPath() {
        return Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    }

    public static enum OSType {
        windows,
        macOS,
        unix,
        other;

    }

    private static class OSTypeHolder {
        private static final OSType osType;

        private OSTypeHolder() {
        }

        static {
            String OS = Sys.osName().toLowerCase(Locale.ENGLISH);
            OSType type = OS.contains("mac") || OS.contains("darwin") ? OSType.macOS : (OS.contains("win") ? OSType.windows : (OS.contains("nux") ? OSType.unix : OSType.other));
            osType = type;
        }
    }

    public static enum SpecificationVersion {
        v2("1.2"),
        v3("1.3"),
        v4("1.4"),
        v5("1.5"),
        v6("1.6"),
        v7("1.7"),
        v8("1.8"),
        v9("9"),
        v10("10"),
        v11("11"),
        v12("12"),
        v13("13"),
        v14("14"),
        v15("14"),
        v16("14"),
        v17("14");

        private final String versionName;

        private SpecificationVersion(String versionName) {
            this.versionName = versionName;
        }

        public String versionName() {
            return this.versionName;
        }

        public boolean before(SpecificationVersion version) {
            return this.ordinal() < version.ordinal();
        }

        public boolean after(SpecificationVersion version) {
            return this.ordinal() > version.ordinal();
        }

        static SpecificationVersion parse(String versionName) {
            Objects.requireNonNull(versionName);
            for (SpecificationVersion value : SpecificationVersion.values()) {
                if (!value.versionName.equals(versionName)) continue;
                return value;
            }
            throw new UnknownSpecificationVersionException(versionName);
        }
    }

    private static class SpecVersionHolder {
        private static final SpecificationVersion specVersion = SpecificationVersion.parse(Sys.javaSpecVersionName());

        private SpecVersionHolder() {
        }
    }
}

