/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dongliu.commons.collection.Lists;
import net.dongliu.commons.sequence.Sequence;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Splitter {
    private final @Nullable String delimiter;
    private final @Nullable Pattern delimiterPattern;
    private final boolean trimResults;
    private final boolean skipEmpty;
    private final String prefix;
    private final String suffix;

    private Splitter(@Nullable String delimiter, @Nullable Pattern delimiterPattern, boolean trimResults, boolean skipEmpty, String prefix, String suffix) {
        this.delimiter = delimiter;
        this.delimiterPattern = delimiterPattern;
        this.trimResults = trimResults;
        this.skipEmpty = skipEmpty;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public static Splitter of(String delimiter) {
        Objects.requireNonNull(delimiter);
        return new Splitter(delimiter, null, false, false, "", "");
    }

    public static Splitter ofRegex(Pattern pattern) {
        Objects.requireNonNull(pattern);
        return new Splitter(null, pattern, false, false, "", "");
    }

    public static Splitter ofRegex(String pattern) {
        Objects.requireNonNull(pattern);
        return Splitter.ofRegex(Pattern.compile(pattern));
    }

    public Sequence<String> split(String str) {
        Objects.requireNonNull(str);
        if (str.isEmpty()) {
            return this.skipEmpty ? Sequence.of() : Sequence.of(str);
        }
        return this.createSplitSequence(str);
    }

    public List<String> splitToList(String str) {
        Objects.requireNonNull(str);
        if (str.isEmpty()) {
            return this.skipEmpty ? Lists.of() : Lists.of(str);
        }
        SplitSequence iterator = this.createSplitSequence(str);
        if (!iterator.hasNext()) {
            return Lists.of();
        }
        ArrayList<String> list = new ArrayList<String>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private SplitSequence createSplitSequence(String str) {
        int to;
        int from = !this.prefix.isEmpty() && str.startsWith(this.prefix) ? this.prefix.length() : 0;
        if (from >= (to = !this.suffix.isEmpty() && str.endsWith(this.suffix) ? str.length() - this.suffix.length() : str.length())) {
            str = "";
            to = 0;
            from = 0;
        }
        if (this.delimiterPattern != null) {
            return new RegexSplitSequence(str, from, to, this.delimiterPattern, this.trimResults, this.skipEmpty);
        }
        if (this.delimiter != null) {
            return new PlainSplitSequence(str, from, to, this.delimiter, this.trimResults, this.skipEmpty);
        }
        throw new IllegalStateException();
    }

    public Splitter trimResults() {
        return new Splitter(this.delimiter, this.delimiterPattern, true, this.skipEmpty, this.prefix, this.suffix);
    }

    public Splitter skipEmpty() {
        return new Splitter(this.delimiter, this.delimiterPattern, this.trimResults, true, this.prefix, this.suffix);
    }

    public Splitter skipPrefix(String prefix) {
        Objects.requireNonNull(prefix);
        return new Splitter(this.delimiter, this.delimiterPattern, this.trimResults, this.skipEmpty, prefix, this.suffix);
    }

    public Splitter skipSuffix(String suffix) {
        Objects.requireNonNull(suffix);
        return new Splitter(this.delimiter, this.delimiterPattern, this.trimResults, this.skipEmpty, this.prefix, suffix);
    }

    private static class RegexSplitSequence
    extends SplitSequence {
        private final Matcher matcher;

        private RegexSplitSequence(String str, int from, int to, Pattern pattern, boolean trimResults, boolean skipEmpty) {
            super(str, from, to, trimResults, skipEmpty);
            this.matcher = pattern.matcher(str.substring(from, to));
        }

        @Override
        protected long findNext(String str, int from) {
            if (this.matcher.find()) {
                return (long)this.matcher.start() << 32 | (long)(this.matcher.end() - this.matcher.start());
            }
            return -4294967295L;
        }
    }

    private static class PlainSplitSequence
    extends SplitSequence {
        private final String delimiter;

        private PlainSplitSequence(String str, int from, int to, String delimiter, boolean trimResults, boolean skipEmpty) {
            super(str, from, to, trimResults, skipEmpty);
            this.delimiter = delimiter;
        }

        @Override
        protected long findNext(String str, int from) {
            int index = str.indexOf(this.delimiter, from);
            return (long)index << 32 | (long)this.delimiter.length();
        }
    }

    private static abstract class SplitSequence
    implements Sequence<String> {
        private final String str;
        private final int from;
        private final int to;
        private final boolean trimResults;
        private final boolean skipEmpty;
        private int pos;
        private String next;

        private SplitSequence(String str, int from, int to, boolean trimResults, boolean skipEmpty) {
            this.str = str;
            this.from = from;
            this.to = to;
            this.trimResults = trimResults;
            this.skipEmpty = skipEmpty;
            this.pos = from;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            do {
                this.next = null;
                this.calculateNext();
                if (this.next == null) {
                    return false;
                }
                if (!this.trimResults) continue;
                this.next = this.next.trim();
            } while (this.skipEmpty && this.next.isEmpty());
            return true;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String s = this.next;
            this.next = null;
            return s;
        }

        private void calculateNext() {
            if (this.pos > this.to) {
                return;
            }
            long l = this.findNext(this.str, this.pos);
            int index = (int)(l >>> 32);
            int delimiterLen = (int)l;
            if (index == -1) {
                index = this.to;
            }
            if (delimiterLen > 0) {
                this.next = this.str.substring(this.pos, index);
                this.pos = index + delimiterLen;
            } else if (this.pos < this.to) {
                this.next = this.str.substring(this.pos, this.pos + 1);
                this.pos = index + 1;
            } else {
                this.pos = index + 1;
            }
        }

        protected abstract long findNext(String var1, int var2);
    }
}

