/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;

public class RichRandom {
    private final Random random;
    private static final ThreadLocal<RichRandom> richRandom = ThreadLocal.withInitial(() -> new RichRandom(ThreadLocalRandom.current()));
    private static byte[] alphanumeric = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".getBytes(StandardCharsets.US_ASCII);

    public RichRandom() {
        this(new Random());
    }

    public RichRandom(Random random) {
        this.random = Objects.requireNonNull(random);
    }

    public static RichRandom newSecureRandom() {
        return new RichRandom(new SecureRandom());
    }

    public static RichRandom currentThreadLocalRandom() {
        return richRandom.get();
    }

    public int nextInt(int begin, int end) {
        if (begin >= end) {
            throw new IllegalArgumentException("invalid range bounds, begin: " + begin + ", end: " + end);
        }
        if (Integer.MAX_VALUE + begin < end) {
            throw new IllegalArgumentException("range overflows int, begin: " + begin + ", end: " + end);
        }
        return begin + this.random.nextInt(end - begin);
    }

    public long nextLong(long bound) {
        if (bound <= 0L) {
            throw new IllegalArgumentException("invalid bound: " + bound);
        }
        if (bound < Integer.MAX_VALUE) {
            return this.nextInt((int)bound);
        }
        long r = this.nextLong() >>> 1;
        long m = bound - 1L;
        if ((bound & m) == 0L) {
            return r & m;
        }
        long u = r;
        while (u - (r = u % bound) + m < 0L) {
            u = this.nextLong() >>> 1;
        }
        return r;
    }

    public long nextLong(long begin, long end) {
        if (begin >= end) {
            throw new IllegalArgumentException("invalid range bounds, begin: " + begin + ", end: " + end);
        }
        if (Long.MAX_VALUE + begin < end) {
            throw new IllegalArgumentException("range overflows int, begin: " + begin + ", end: " + end);
        }
        return begin + this.nextLong(end - begin);
    }

    public byte[] bytes(int len) {
        if (len < 0) {
            throw new IllegalArgumentException("invalid byte array len: " + len);
        }
        if (len == 0) {
            return new byte[0];
        }
        byte[] bytes = new byte[len];
        this.random.nextBytes(bytes);
        return bytes;
    }

    public String asciiString(int len) {
        this.checkStringLen(len);
        if (len == 0) {
            return "";
        }
        byte[] chars = new byte[len];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (byte)(this.random.nextInt(107) + 20);
        }
        return new String(chars, StandardCharsets.US_ASCII);
    }

    public String alphanumericString(int len) {
        this.checkStringLen(len);
        if (len == 0) {
            return "";
        }
        byte[] chars = new byte[len];
        for (int i = 0; i < chars.length; ++i) {
            int index = this.random.nextInt(alphanumeric.length);
            chars[i] = alphanumeric[index];
        }
        return new String(chars, StandardCharsets.US_ASCII);
    }

    private void checkStringLen(int len) {
        if (len < 0) {
            throw new IllegalArgumentException("len less than zero: " + len);
        }
    }

    public void nextBytes(byte[] bytes) {
        this.random.nextBytes(bytes);
    }

    public int nextInt() {
        return this.random.nextInt();
    }

    public int nextInt(int bound) {
        return this.random.nextInt(bound);
    }

    public long nextLong() {
        return this.random.nextLong();
    }

    public boolean nextBoolean() {
        return this.random.nextBoolean();
    }

    public float nextFloat() {
        return this.random.nextFloat();
    }

    public double nextDouble() {
        return this.random.nextDouble();
    }

    public void setSeed(long seed) {
        this.random.setSeed(seed);
    }

    public double nextGaussian() {
        return this.random.nextGaussian();
    }

    public IntStream ints(long streamSize) {
        return this.random.ints(streamSize);
    }

    public IntStream ints() {
        return this.random.ints();
    }

    public IntStream ints(long streamSize, int randomNumberOrigin, int randomNumberBound) {
        return this.random.ints(streamSize, randomNumberOrigin, randomNumberBound);
    }

    public IntStream ints(int randomNumberOrigin, int randomNumberBound) {
        return this.random.ints(randomNumberOrigin, randomNumberBound);
    }

    public LongStream longs(long streamSize) {
        return this.random.longs(streamSize);
    }

    public LongStream longs() {
        return this.random.longs();
    }

    public LongStream longs(long streamSize, long randomNumberOrigin, long randomNumberBound) {
        return this.random.longs(streamSize, randomNumberOrigin, randomNumberBound);
    }

    public LongStream longs(long randomNumberOrigin, long randomNumberBound) {
        return this.random.longs(randomNumberOrigin, randomNumberBound);
    }

    public DoubleStream doubles(long streamSize) {
        return this.random.doubles(streamSize);
    }

    public DoubleStream doubles() {
        return this.random.doubles();
    }

    public DoubleStream doubles(long streamSize, double randomNumberOrigin, double randomNumberBound) {
        return this.random.doubles(streamSize, randomNumberOrigin, randomNumberBound);
    }

    public DoubleStream doubles(double randomNumberOrigin, double randomNumberBound) {
        return this.random.doubles(randomNumberOrigin, randomNumberBound);
    }

    public Random getRandom() {
        return this.random;
    }
}

