/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dongliu.commons.Strings;
import net.dongliu.commons.collection.Lists;
import net.dongliu.commons.reflect.Classes;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Objects2 {
    public static <T> T cast(Object value) {
        return (T)value;
    }

    public static <T> T elvis(@Nullable T value1, T value2) {
        if (value1 != null) {
            return value1;
        }
        return Objects.requireNonNull(value2);
    }

    public static <T> T runWith(T value, Consumer<T> consumer) {
        consumer.accept(value);
        return value;
    }

    public static <T> T elvis(@Nullable T value1, Supplier<T> supplier) {
        if (value1 != null) {
            return value1;
        }
        return Objects.requireNonNull(supplier.get());
    }

    @Deprecated
    public static ToStringHelper toStringHelper(Class<?> cls) {
        return new ToStringHelper(Objects.requireNonNull(cls));
    }

    @Deprecated
    public static String toString(@Nullable Object value) {
        if (value == null) {
            return "null";
        }
        ToStringHelper toStringHelper = (ToStringHelper)ToStringCacheHolder.cache.get(value.getClass());
        return toStringHelper.toString(value);
    }

    @Deprecated
    public static class ToStringHelper {
        private final Class<?> cls;
        private final List<Field> memberFields;
        private final String className;

        protected ToStringHelper(Class<?> cls) {
            this.cls = cls;
            List<Field> memberFields = Classes.getAllMemberFields(cls);
            for (Field field : memberFields) {
                field.setAccessible(true);
            }
            this.memberFields = memberFields;
            String className = cls.isAnonymousClass() ? Strings.subStringAfterLast(cls.getName(), ".") : cls.getSimpleName();
            this.className = className;
        }

        public String toString(@Nullable Object obj) {
            if (obj == null) {
                return "null";
            }
            if (!this.cls.equals(obj.getClass())) {
                throw new IllegalArgumentException("value type " + obj.getClass().getName() + " not match with ToStringHelper");
            }
            if (this.cls.isArray()) {
                return this.arrayToString(obj);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.className).append('{');
            Lists.forEachLastAware(this.memberFields, (field, last) -> {
                this.appendFiledKeyAndValue(sb, obj, (Field)field);
                if (!last) {
                    sb.append(", ");
                }
            });
            sb.append('}');
            return sb.toString();
        }

        private void appendFiledKeyAndValue(StringBuilder sb, Object obj, Field field) {
            Object fieldValue;
            sb.append(field.getName()).append('=');
            Class<?> type = field.getType();
            if (type.isPrimitive()) {
                try {
                    this.appendPrimitiveField(sb, field, obj);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                fieldValue = field.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (fieldValue == null) {
                sb.append("null");
            } else if (fieldValue.getClass().isArray()) {
                sb.append(this.arrayToString(fieldValue));
            } else {
                sb.append(fieldValue.toString());
            }
        }

        private void appendPrimitiveField(StringBuilder sb, Field field, Object value) throws IllegalAccessException {
            Class<?> type = field.getType();
            if (type == Integer.TYPE) {
                sb.append(field.getInt(value));
            } else if (type == Long.TYPE) {
                sb.append(field.getLong(value));
            } else if (type == Short.TYPE) {
                sb.append(field.getShort(value));
            } else if (type == Boolean.TYPE) {
                sb.append(field.getBoolean(value));
            } else if (type == Float.TYPE) {
                sb.append(field.getFloat(value));
            } else if (type == Double.TYPE) {
                sb.append(field.getDouble(value));
            } else if (type == Byte.TYPE) {
                sb.append(field.getByte(value));
            } else if (type == Character.TYPE) {
                sb.append(field.getChar(value));
            } else {
                throw new RuntimeException("not primitive type: " + type.getName());
            }
        }

        private String arrayToString(Object value) {
            if (value instanceof boolean[]) {
                return Arrays.toString((boolean[])value);
            }
            if (value instanceof char[]) {
                return Arrays.toString((char[])value);
            }
            if (value instanceof byte[]) {
                return Arrays.toString((byte[])value);
            }
            if (value instanceof short[]) {
                return Arrays.toString((short[])value);
            }
            if (value instanceof int[]) {
                return Arrays.toString((int[])value);
            }
            if (value instanceof long[]) {
                return Arrays.toString((long[])value);
            }
            if (value instanceof float[]) {
                return Arrays.toString((float[])value);
            }
            if (value instanceof double[]) {
                return Arrays.toString((double[])value);
            }
            return Arrays.toString((Object[])value);
        }
    }

    @Deprecated
    private static class ToStringCacheHolder {
        private static final ClassValue<ToStringHelper> cache = new ClassValue<ToStringHelper>(){

            @Override
            protected ToStringHelper computeValue(Class<?> type) {
                return new ToStringHelper(Objects.requireNonNull(type));
            }
        };

        private ToStringCacheHolder() {
        }
    }
}

