/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import java.util.Objects;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Joiner {
    private final CharSequence prefix;
    private final CharSequence suffix;
    private final CharSequence delimiter;
    private final boolean skipNulls;
    private final boolean nullToEmpty;
    private final boolean skipEmpty;

    private Joiner(CharSequence prefix, CharSequence suffix, CharSequence delimiter, boolean skipNulls, boolean nullToEmpty, boolean skipEmpty) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.delimiter = delimiter;
        this.skipNulls = skipNulls;
        this.nullToEmpty = nullToEmpty;
        this.skipEmpty = skipEmpty;
    }

    public static Joiner of(CharSequence prefix, CharSequence suffix, CharSequence delimiter) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(suffix);
        Objects.requireNonNull(delimiter);
        return new Joiner(prefix, suffix, delimiter, false, false, false);
    }

    public static Joiner of(CharSequence delimiter) {
        return Joiner.of("", "", delimiter);
    }

    public String join(@NonNull Iterable<@Nullable ?> values) {
        Objects.requireNonNull(values);
        StringJoiner joiner = new StringJoiner(this.delimiter, this.prefix, this.suffix);
        for (Object o : values) {
            if (o == null) {
                if (this.skipNulls) continue;
                if (this.nullToEmpty) {
                    o = "";
                }
            }
            String str = String.valueOf(o);
            if (this.skipEmpty && str.isEmpty()) continue;
            joiner.add(str);
        }
        return joiner.toString();
    }

    public String join(Object ... values) {
        Objects.requireNonNull(values);
        StringJoiner joiner = new StringJoiner(this.delimiter, this.prefix, this.suffix);
        for (Object o : values) {
            if (o == null) {
                if (this.skipNulls) continue;
                if (this.nullToEmpty) {
                    o = "";
                }
            }
            String str = String.valueOf(o);
            if (this.skipEmpty && str.isEmpty()) continue;
            joiner.add(str);
        }
        return joiner.toString();
    }

    public Joiner withPrefix(CharSequence prefix) {
        Objects.requireNonNull(prefix);
        return new Joiner(prefix, this.suffix, this.delimiter, this.skipNulls, this.nullToEmpty, this.skipEmpty);
    }

    public Joiner withSuffix(CharSequence suffix) {
        Objects.requireNonNull(suffix);
        return new Joiner(this.prefix, suffix, this.delimiter, this.skipNulls, this.nullToEmpty, this.skipEmpty);
    }

    public Joiner skipNulls() {
        return new Joiner(this.prefix, this.suffix, this.delimiter, true, this.nullToEmpty, this.skipEmpty);
    }

    public Joiner nullToEmpty() {
        return new Joiner(this.prefix, this.suffix, this.delimiter, this.skipNulls, true, this.skipEmpty);
    }

    public Joiner skipEmpty() {
        return new Joiner(this.prefix, this.suffix, this.delimiter, this.skipNulls, this.nullToEmpty, true);
    }
}

