/*
 * Decompiled with CFR 0.152.
 */
package me.gv7.woodpecker.requests.utils;

import java.util.Date;
import me.gv7.woodpecker.requests.Cookie;
import me.gv7.woodpecker.requests.Parameter;
import me.gv7.woodpecker.requests.utils.CookieDateUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Cookies {
    public static String calculatePath(String uri) {
        if (!uri.startsWith("/")) {
            return "/";
        }
        int idx = uri.lastIndexOf(47);
        return uri.substring(0, idx + 1);
    }

    public static boolean isIP(String host) {
        return Cookies.isIPV4(host) || Cookies.isIPV6(host);
    }

    private static boolean isIPV4(String host) {
        int dotCount = 0;
        for (int i = 0; i < host.length(); ++i) {
            char c = host.charAt(i);
            if (c >= '0' && c <= '9') continue;
            if (c == '.') {
                if (++dotCount <= 3) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean isIPV6(String host) {
        int colonCount = 0;
        int dotCount = 0;
        for (int i = 0; i < host.length(); ++i) {
            char c = host.charAt(i);
            if (c >= '0' && c <= '9') continue;
            if (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
                if (dotCount <= 0) continue;
                return false;
            }
            if (c == ':') {
                if (++colonCount + dotCount <= 7) continue;
                return false;
            }
            if (c == '.') {
                if (colonCount >= 2 && ++dotCount <= 3) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean isDomainSuffix(String domain, String domainSuffix) {
        if (domain.length() < domainSuffix.length()) {
            return false;
        }
        if (domain.length() == domainSuffix.length()) {
            return domain.equals(domainSuffix);
        }
        return domain.endsWith(domainSuffix) && domain.charAt(domain.length() - domainSuffix.length() - 1) == '.';
    }

    public static boolean match(Cookie cookie, String protocol, String host, String path) {
        if (cookie.secure() && !protocol.equalsIgnoreCase("https")) {
            return false;
        }
        if (Cookies.isIP(host) || cookie.hostOnly() ? !host.equals(cookie.domain()) : !Cookies.isDomainSuffix(host, cookie.domain())) {
            return false;
        }
        String cookiePath = cookie.path();
        if (cookiePath.length() > path.length()) {
            return false;
        }
        if (cookiePath.length() == path.length()) {
            return cookiePath.equals(path);
        }
        if (!path.startsWith(cookiePath)) {
            return false;
        }
        return cookiePath.charAt(cookiePath.length() - 1) == '/' || path.charAt(cookiePath.length()) == '/';
    }

    public static @Nullable Cookie parseCookie(String cookieStr, String host, String defaultPath) {
        boolean hostOnly;
        String[] items = cookieStr.split(";");
        Parameter<String> param = Cookies.parseCookieNameValue(items[0]);
        if (param == null) {
            return null;
        }
        String domain = "";
        String path = "";
        long expiry = 0L;
        boolean secure = false;
        block18: for (String item : items) {
            if ((item = item.trim()).isEmpty()) continue;
            Parameter<String> attribute = Cookies.parseCookieAttribute(item);
            switch (attribute.name().toLowerCase()) {
                case "domain": {
                    domain = Cookies.normalizeDomain(attribute.value());
                    continue block18;
                }
                case "path": {
                    path = Cookies.normalizePath(attribute.value());
                    continue block18;
                }
                case "expires": {
                    Date date;
                    if (expiry != 0L || (date = CookieDateUtil.parseDate(attribute.value())) == null || (expiry = date.getTime()) != 0L) continue block18;
                    expiry = 1L;
                    continue block18;
                }
                case "max-age": {
                    try {
                        int seconds = Integer.parseInt(attribute.value());
                        expiry = System.currentTimeMillis() + (long)(seconds * 1000);
                        if (expiry != 0L) continue block18;
                        expiry = 1L;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue block18;
                }
                case "secure": {
                    secure = true;
                    continue block18;
                }
                case "httponly": {
                    continue block18;
                }
            }
        }
        if (path.isEmpty()) {
            path = defaultPath;
        }
        if (domain.isEmpty()) {
            domain = host;
            hostOnly = true;
        } else {
            if (Cookies.isIP(host)) {
                return null;
            }
            if (!Cookies.isDomainSuffix(host, domain)) {
                return null;
            }
            hostOnly = false;
        }
        return new Cookie(domain, path, param.name(), param.value(), expiry, secure, hostOnly);
    }

    private static @Nullable Parameter<String> parseCookieNameValue(String str) {
        int idx = str.indexOf("=");
        if (idx <= 0) {
            return null;
        }
        return Parameter.of(str.substring(0, idx).trim(), str.substring(idx + 1).trim());
    }

    private static Parameter<String> parseCookieAttribute(String str) {
        int idx = str.indexOf("=");
        if (idx < 0) {
            return Parameter.of(str, "");
        }
        return Parameter.of(str.substring(0, idx), str.substring(idx + 1));
    }

    private static String normalizePath(String str) {
        if (!str.startsWith("/")) {
            return "";
        }
        return str;
    }

    private static String normalizeDomain(String value) {
        if (value.startsWith(".")) {
            return value.substring(1);
        }
        return value.toLowerCase();
    }
}

