/*
 * Decompiled with CFR 0.152.
 */
package me.gv7.woodpecker.requests.executor;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.gv7.woodpecker.requests.Cookie;
import me.gv7.woodpecker.requests.executor.CookieJar;
import me.gv7.woodpecker.requests.utils.Cookies;

class DefaultCookieJar
implements CookieJar,
Serializable {
    private static final long serialVersionUID = 8372575235144209124L;
    private Map<CookieKey, Cookie> cookieMap = new HashMap<CookieKey, Cookie>();

    DefaultCookieJar() {
    }

    @Override
    public synchronized void storeCookies(Collection<Cookie> cookies) {
        for (Cookie cookie : cookies) {
            CookieKey key = new CookieKey(cookie.domain(), cookie.path(), cookie.name());
            this.cookieMap.put(key, cookie);
        }
        this.removeExpiredCookies();
    }

    private void removeExpiredCookies() {
        long now = System.currentTimeMillis();
        this.cookieMap.entrySet().removeIf(entry -> ((Cookie)entry.getValue()).expired(now));
    }

    @Override
    public synchronized List<Cookie> getCookies(URL url) {
        long now = System.currentTimeMillis();
        ArrayList<Cookie> matched = new ArrayList<Cookie>();
        for (Cookie cookie : this.cookieMap.values()) {
            if (!Cookies.match(cookie, url.getProtocol(), url.getHost().toLowerCase(), url.getPath()) || cookie.expired(now)) continue;
            matched.add(cookie);
        }
        matched.sort((cookie1, cookie2) -> cookie2.path().length() - cookie1.path().length());
        return matched;
    }

    @Override
    public synchronized List<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.cookieMap.values());
    }

    private static class CookieKey {
        private final String domain;
        private final String path;
        private final String name;

        public CookieKey(String domain, String path, String name) {
            this.domain = domain;
            this.path = path;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CookieKey cookieKey = (CookieKey)o;
            if (!this.domain.equals(cookieKey.domain)) {
                return false;
            }
            if (!this.path.equals(cookieKey.path)) {
                return false;
            }
            return this.name.equals(cookieKey.name);
        }

        public int hashCode() {
            int result = this.domain.hashCode();
            result = 31 * result + this.path.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }
}

