/*
 * Decompiled with CFR 0.152.
 */
package me.gv7.woodpecker.requests.body;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import me.gv7.woodpecker.requests.body.BytesRequestBody;
import me.gv7.woodpecker.requests.body.FileRequestBody;
import me.gv7.woodpecker.requests.body.FormRequestBody;
import me.gv7.woodpecker.requests.body.InputStreamRequestBody;
import me.gv7.woodpecker.requests.body.InputStreamSupplier;
import me.gv7.woodpecker.requests.body.InputStreamSupplierRequestBody;
import me.gv7.woodpecker.requests.body.JsonRequestBody;
import me.gv7.woodpecker.requests.body.MultiPartRequestBody;
import me.gv7.woodpecker.requests.body.Part;
import me.gv7.woodpecker.requests.body.StringRequestBody;
import net.dongliu.commons.collection.Lists;

public abstract class RequestBody<T>
implements Serializable {
    private static final long serialVersionUID = 1332594280620699388L;
    private final T body;
    private String contentType;
    private final boolean includeCharset;

    protected RequestBody(T body, String contentType, boolean includeCharset) {
        this.body = body;
        this.contentType = contentType;
        this.includeCharset = includeCharset;
    }

    @Deprecated
    public T getBody() {
        return this.body;
    }

    public T body() {
        return this.body;
    }

    @Deprecated
    public RequestBody<T> setContentType(String contentType) {
        this.contentType = Objects.requireNonNull(contentType);
        return this;
    }

    public RequestBody<T> contentType(String contentType) {
        this.contentType = Objects.requireNonNull(contentType);
        return this;
    }

    @Deprecated
    public String getContentType() {
        return this.contentType;
    }

    public String contentType() {
        return this.contentType;
    }

    @Deprecated
    public boolean isIncludeCharset() {
        return this.includeCharset;
    }

    public boolean includeCharset() {
        return this.includeCharset;
    }

    public void writeTo(OutputStream out, Charset charset) throws IOException {
        this.writeBody(out, charset);
    }

    public abstract void writeBody(OutputStream var1, Charset var2) throws IOException;

    public static <T> RequestBody<T> json(T value) {
        return new JsonRequestBody<T>(value);
    }

    public static RequestBody<String> text(String value) {
        return new StringRequestBody(Objects.requireNonNull(value));
    }

    public static RequestBody<Collection<? extends Map.Entry<String, ?>>> form(Collection<? extends Map.Entry<String, ?>> params) {
        return new FormRequestBody(Objects.requireNonNull(params));
    }

    public static RequestBody<Collection<? extends Map.Entry<String, ?>>> form(Map.Entry<String, ?> ... params) {
        return RequestBody.form(Lists.of(params));
    }

    public static RequestBody<byte[]> bytes(byte[] value) {
        return new BytesRequestBody(Objects.requireNonNull(value));
    }

    @Deprecated
    public static RequestBody<InputStream> inputStream(InputStream in) {
        return new InputStreamRequestBody(Objects.requireNonNull(in));
    }

    public static RequestBody<InputStreamSupplier> inputStream(InputStreamSupplier supplier) {
        return new InputStreamSupplierRequestBody(Objects.requireNonNull(supplier));
    }

    public static RequestBody<File> file(File file) {
        return new FileRequestBody(Objects.requireNonNull(file));
    }

    public static RequestBody<Collection<? extends Part<?>>> multiPart(Collection<? extends Part<?>> parts) {
        return new MultiPartRequestBody(Objects.requireNonNull(parts));
    }
}

