/*
 * Decompiled with CFR 0.152.
 */
package me.gv7.woodpecker.requests;

import java.net.URL;
import java.util.List;
import me.gv7.woodpecker.requests.Cookie;
import me.gv7.woodpecker.requests.RequestBuilder;
import me.gv7.woodpecker.requests.executor.SessionContext;

public class Session {
    private final SessionContext context;

    Session(SessionContext context) {
        this.context = context;
    }

    public RequestBuilder get(String url) {
        return this.newRequest("GET", url);
    }

    public RequestBuilder post(String url) {
        return this.newRequest("POST", url);
    }

    public RequestBuilder put(String url) {
        return this.newRequest("PUT", url);
    }

    public RequestBuilder head(String url) {
        return this.newRequest("HEAD", url);
    }

    public RequestBuilder delete(String url) {
        return this.newRequest("DELETE", url);
    }

    public RequestBuilder patch(String url) {
        return this.newRequest("PATCH", url);
    }

    public RequestBuilder newRequest(String method, String url) {
        return new RequestBuilder().sessionContext(this.context).url(url).method(method);
    }

    public RequestBuilder get(URL url) {
        return this.newRequest("GET", url);
    }

    public RequestBuilder post(URL url) {
        return this.newRequest("POST", url);
    }

    public RequestBuilder put(URL url) {
        return this.newRequest("PUT", url);
    }

    public RequestBuilder head(URL url) {
        return this.newRequest("HEAD", url);
    }

    public RequestBuilder delete(URL url) {
        return this.newRequest("DELETE", url);
    }

    public RequestBuilder patch(URL url) {
        return this.newRequest("PATCH", url);
    }

    public List<Cookie> currentCookies() {
        return this.context.cookieJar().getCookies();
    }

    public RequestBuilder newRequest(String method, URL url) {
        return new RequestBuilder().sessionContext(this.context).url(url).method(method);
    }
}

