/*
 * Decompiled with CFR 0.152.
 */
package com.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class logUtils {
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static void setOutText(JTextPane out, String text) {
        SwingUtilities.invokeLater(() -> {
            try {
                StyledDocument doc = out.getStyledDocument();
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setFontSize(attr, 13);
                String logText = logUtils.buildLogText(text);
                doc.insertString(doc.getLength(), logText, attr);
                doc.insertString(doc.getLength(), "\n", attr);
                out.setCaretPosition(doc.getLength());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        });
    }

    public static void setOutText(JTextArea out, String text) {
        SwingUtilities.invokeLater(() -> {
            String logText = logUtils.buildLogText(text) + "\n";
            out.append(logText);
            out.setCaretPosition(out.getText().length());
        });
    }

    private static String buildLogText(String text) {
        String cleanText = text == null ? "" : text.trim();
        return String.format("[%s] %s", logUtils.getCurrentTime(), cleanText);
    }

    private static String getCurrentTime() {
        return TIME_FORMAT.format(new Date());
    }
}

