/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.text.Document;
import javax.swing.text.LabelView;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class FlatHTML {
    private FlatHTML() {
    }

    public static void updateRendererCSSFontBaseSize(JComponent c) {
        View view = (View)c.getClientProperty("html");
        if (view == null) {
            return;
        }
        Document doc = view.getDocument();
        if (!(doc instanceof HTMLDocument)) {
            return;
        }
        StyleSheet styleSheet = ((HTMLDocument)doc).getStyleSheet();
        int fontBaseSize = c.getFont().getSize();
        if (styleSheet.getPointSize(7) != 36.0f || styleSheet.getPointSize(4) == (float)fontBaseSize) {
            return;
        }
        styleSheet.addRule("BASE_SIZE " + fontBaseSize);
        FlatHTML.clearViewCaches(view);
    }

    public static void updateRendererCSSForeground(View view, Color foreground) {
        Document doc = view.getDocument();
        if (!(doc instanceof HTMLDocument) || foreground == null) {
            return;
        }
        Style bodyStyle = ((HTMLDocument)doc).getStyle("body");
        if (bodyStyle == null) {
            StyleSheet styleSheet = ((HTMLDocument)doc).getStyleSheet();
            styleSheet.addRule(String.format("body { color: #%06x; }", foreground.getRGB() & 0xFFFFFF));
            FlatHTML.clearViewCaches(view);
        } else if (!foreground.equals(bodyStyle.getAttribute(StyleConstants.Foreground))) {
            bodyStyle.addAttribute(StyleConstants.Foreground, foreground);
            FlatHTML.clearViewCaches(view);
        }
    }

    private static void clearViewCaches(View view) {
        if (view instanceof LabelView) {
            ((LabelView)view).changedUpdate(null, null, null);
        }
        int viewCount = view.getViewCount();
        for (int i = 0; i < viewCount; ++i) {
            FlatHTML.clearViewCaches(view.getView(i));
        }
    }

    public static PropertyChangeListener createPropertyChangeListener(PropertyChangeListener superListener) {
        return e -> {
            if (superListener != null) {
                superListener.propertyChange(e);
            }
            FlatHTML.propertyChange(e);
        };
    }

    public static void propertyChange(PropertyChangeEvent e) {
        if ("html".equals(e.getPropertyName())) {
            FlatHTML.updateRendererCSSFontBaseSize((JComponent)e.getSource());
        }
    }
}

