/*
 * Decompiled with CFR 0.152.
 */
package com.controller;

import com.dto.config.proxyConfigDTO;
import com.dto.result.proxyResult;
import com.service.proxy.proxyConfigService;
import com.service.proxy.proxyService;
import com.ui.Frame;
import com.utils.logUtils;
import java.util.concurrent.ExecutionException;
import javax.swing.JToggleButton;
import javax.swing.SwingWorker;

public class ProxyController {
    private final Frame frame;
    private final proxyService proxyService = new proxyService();
    private final proxyConfigService proxyConfigService = new proxyConfigService();

    public ProxyController(Frame frame) {
        this.frame = frame;
        this.initProxySetting();
    }

    private void initProxySetting() {
        final JToggleButton proxyButton = this.frame.getProxyButton();
        proxyButton.addActionListener(e -> {
            final proxyConfigDTO config = this.proxyConfigService.doProxySet(this.frame);
            proxyResult result = this.proxyService.doProxySet(config);
            if (result.getSuccess().booleanValue()) {
                SwingWorker<proxyResult, Void> swingWorker = new SwingWorker<proxyResult, Void>(){

                    @Override
                    protected proxyResult doInBackground() throws Exception {
                        proxyButton.setText("\u4ee3\u7406\u5f00\u542f\u4e2d...");
                        return ProxyController.this.proxyService.doProxy();
                    }

                    @Override
                    protected void done() {
                        proxyButton.setText(config.isFlag() ? "\u4ee3\u7406\u5df2\u5f00\u542f" : "\u4ee3\u7406\u672a\u5f00\u542f");
                        try {
                            logUtils.setOutText(ProxyController.this.frame.getTextArea3(), "\u5f53\u524dIP\u5730\u5740\uff1a" + ((proxyResult)this.get()).getMessage());
                        }
                        catch (InterruptedException | ExecutionException ex) {
                            proxyButton.setText("\u4ee3\u7406\u672a\u5f00\u542f");
                            logUtils.setOutText(ProxyController.this.frame.getTextArea3(), "Error:" + ex.getCause().getMessage());
                        }
                    }
                };
                swingWorker.execute();
            } else {
                proxyButton.setText("\u4ee3\u7406\u672a\u5f00\u542f");
                logUtils.setOutText(this.frame.getTextArea3(), "Error\uff1a" + result.getMessage());
            }
        });
    }
}

