/*
 * Decompiled with CFR 0.152.
 */
package com.controller;

import com.core.ThreadContext;
import com.service.attack.findService;
import com.ui.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.TableModel;

public class FindController {
    private final Frame frame;
    private boolean isFinding = false;
    ArrayList<String> classList = new ArrayList();
    private findService service;

    public FindController(Frame frame) {
        this.frame = frame;
        this.InitComponents();
        this.initTablePopupMenu();
    }

    private void InitComponents() {
        JToggleButton findButton = this.frame.getFindButton();
        TableModel model = this.frame.getClassTable().getModel();
        findButton.addActionListener(e -> {
            this.classList.clear();
            String mode = Objects.requireNonNull(this.frame.getClassComboBox().getSelectedItem()).toString();
            if (mode.isEmpty()) {
                return;
            }
            String way = Objects.requireNonNull(this.frame.getFindComboBox().getSelectedItem()).toString();
            if (findButton.isSelected()) {
                int i;
                this.isFinding = true;
                findButton.setText("\u505c\u6b62\u63a2\u6d4b");
                for (i = 0; i < model.getRowCount(); ++i) {
                    model.setValueAt("", i, 2);
                }
                if (mode.equals("ALL")) {
                    for (i = 0; i < model.getRowCount(); ++i) {
                        String className;
                        Object value = model.getValueAt(i, 1);
                        if (value == null || (className = value.toString().trim()).isEmpty()) continue;
                        this.classList.add(className);
                    }
                } else {
                    this.classList.add(mode);
                }
                if (way.contains("dnslog")) {
                    this.service = new findService(this.frame, this.classList);
                    this.service.execute();
                } else {
                    this.isFinding = false;
                    findButton.setText("\u5f00\u59cb\u63a2\u6d4b");
                }
            } else if (this.isFinding && this.service != null) {
                this.service.cancel(true);
                this.service.doThreadEnd(ThreadContext.thread);
                this.isFinding = false;
                findButton.setText("\u5f00\u59cb\u63a2\u6d4b");
            }
        });
    }

    private void setClipboardString(String text) {
        StringSelection selection = new StringSelection(text);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, null);
    }

    private void initTablePopupMenu() {
        final JTable table = this.frame.getClassTable();
        final JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem copyClassItem = new JMenuItem("\u590d\u5236\u7c7b\u540d");
        copyClassItem.addActionListener(e -> {
            Object value;
            int row = table.getSelectedRow();
            if (row != -1 && (value = table.getValueAt(row, 1)) != null) {
                this.setClipboardString(value.toString());
            }
        });
        JMenuItem copyCellItem = new JMenuItem("\u590d\u5236\u5f53\u524d\u5355\u5143\u683c");
        copyCellItem.addActionListener(e -> {
            Object value;
            int row = table.getSelectedRow();
            int col = table.getSelectedColumn();
            if (row != -1 && col != -1 && (value = table.getValueAt(row, col)) != null) {
                this.setClipboardString(value.toString());
            }
        });
        popupMenu.add(copyClassItem);
        popupMenu.add(copyCellItem);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            private void showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int row = table.rowAtPoint(e.getPoint());
                    int col = table.columnAtPoint(e.getPoint());
                    if (row != -1) {
                        table.setRowSelectionInterval(row, row);
                        if (col != -1) {
                            table.setColumnSelectionInterval(col, col);
                        }
                    }
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }
}

