/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.util;

import com.ar3h.chains.common.annotations.GadgetTags;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class AnnotationProcessor {
    public static boolean evaluateExpression(Class<?> classWithExpression, Class<?> classWithTags) {
        GadgetTags expressionTags = classWithExpression.getAnnotation(GadgetTags.class);
        if (expressionTags == null || expressionTags.expression().isEmpty()) {
            throw new IllegalArgumentException("Class " + classWithExpression.getName() + " does not have a valid express in GadgetTags annotation");
        }
        GadgetTags tags = classWithTags.getAnnotation(GadgetTags.class);
        if (tags == null) {
            throw new IllegalArgumentException("Class " + classWithTags.getName() + " does not have GadgetTags annotation");
        }
        HashSet currentTagSet = new HashSet();
        Collections.addAll(currentTagSet, tags.tags());
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setVariable("tags", currentTagSet);
        String expression = expressionTags.expression();
        Boolean result = parser.parseExpression(expression).getValue((EvaluationContext)context, Boolean.class);
        return result != null && result != false;
    }

    private static String convertToSpEL(String expression) {
        Pattern pattern = Pattern.compile("\\b[A-Z0-9_]+\\b");
        Matcher matcher = pattern.matcher(expression);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "#tags.contains('" + matcher.group() + "')");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

