/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.mysql.proto;

import com.ar3h.chains.gadget.impl.mysql.proto.ColumnPacket;
import com.ar3h.chains.gadget.impl.mysql.proto.utils.ByteUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketHelper {
    private static final Logger log = LoggerFactory.getLogger(PacketHelper.class);

    public static byte[] readData(InputStream inputStream) {
        try {
            byte[] buffer = new byte[10240];
            int bytesRead = inputStream.read(buffer);
            if (bytesRead != -1) {
                return Arrays.copyOf(buffer, bytesRead);
            }
        }
        catch (Exception ex) {
            log.error("socket error");
        }
        return new byte[0];
    }

    public static byte[] buildPacket(int num, byte[] d) {
        try {
            if (d.length > 0x1000000) {
                log.error("packet is too long");
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] lenHex = ByteUtil.ReverseBytes(ByteUtil.int3ToBytes(d.length));
            byte[] numHex = ColumnPacket.hexToBytes(String.format("%02d", num));
            out.write(lenHex);
            out.write(numHex);
            out.write(d);
            return out.toByteArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new byte[0];
        }
    }
}

