/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.javanative.commons.collections;

import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.exception.ThrowsUtil;
import com.ar3h.chains.common.util.Reflections;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;

public abstract class AbstractTransformer
implements Gadget {
    public Class transformerClazz;
    public Class constantTransformerClazz;
    public Class invokerTransformerClazz;
    public Class instantiateTransformer;

    public void initClazz(String version) throws ClassNotFoundException {
        try {
            if (version.equals("3")) {
                this.transformerClazz = Class.forName("org.apache.commons.collections.Transformer");
                this.constantTransformerClazz = Class.forName("org.apache.commons.collections.functors.ConstantTransformer");
                this.invokerTransformerClazz = Class.forName("org.apache.commons.collections.functors.InvokerTransformer");
                this.instantiateTransformer = Class.forName("org.apache.commons.collections.functors.InstantiateTransformer");
            } else if (version.equals("4")) {
                this.transformerClazz = Class.forName("org.apache.commons.collections4.Transformer");
                this.constantTransformerClazz = Class.forName("org.apache.commons.collections4.functors.ConstantTransformer");
                this.invokerTransformerClazz = Class.forName("org.apache.commons.collections4.functors.InvokerTransformer");
                this.instantiateTransformer = Class.forName("org.apache.commons.collections4.functors.InstantiateTransformer");
            } else {
                ThrowsUtil.throwGadgetException("CC " + version + " not found");
            }
        }
        catch (ClassNotFoundException e) {
            ThrowsUtil.throwGadgetException(e);
        }
    }

    public Object createTransformerArray(LinkedList<Object> transformers) throws ClassNotFoundException {
        Object transformerArray = Array.newInstance(this.transformerClazz, transformers.size());
        for (int i = 0; i < transformers.size(); ++i) {
            Array.set(transformerArray, i, transformers.get(i));
        }
        return transformerArray;
    }

    public Object createConstantTransformer(Object args) throws Exception {
        return Reflections.newInstance(this.constantTransformerClazz.getName(), new Class[]{Object.class}, args);
    }

    public Object createInvokerTransformer(Object ... args) throws Exception {
        return Reflections.newInstance(this.invokerTransformerClazz.getName(), new Class[]{String.class, Class[].class, Object[].class}, args);
    }

    public Object createInstantiateTransformer(Object ... args) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return Reflections.newInstance(this.instantiateTransformer.getName(), new Class[]{Class[].class, Object[].class}, args);
    }
}

