/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.common.other;

import com.ar3h.chains.common.ContextTag;
import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.GadgetChain;
import com.ar3h.chains.common.GadgetContext;
import com.ar3h.chains.common.annotations.GadgetAnnotation;
import com.ar3h.chains.common.annotations.GadgetTags;
import com.ar3h.chains.common.param.Param;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GadgetTags(tags={"Other"}, nextTags={"BytecodeConvertTag"})
@GadgetAnnotation(name="\u5c06\u5b57\u8282\u7801\u8f6c\u4e3aJar\u5305", description="\u8f93\u51fa\u666e\u901aJar\u5305\u5b57\u8282\u6d41")
public class Jar
implements Gadget {
    private static final Logger log = LoggerFactory.getLogger(Jar.class);
    @Param(name="MANIFEST.MF\u6587\u4ef6\u5185\u5bb9", description="\u82e5\u4e3a\u7a7a\u5219\u4e0d\u521b\u5efa\u8be5\u6587\u4ef6", requires=false)
    public String manifest;
    @Param(name="\u521b\u5efa\u53ef\u6267\u884cjar\u5305", description="\u81ea\u52a8\u8bbe\u7f6e MANIFEST.MF \u6587\u4ef6\u4e2d Main-Class \u5b57\u6bb5\u4e3a\u5b57\u8282\u7801\u7c7b\u540d, \u53ef\u4ee5\u5b9e\u73b0\u521b\u5efa\u53ef\u6267\u884cjar\u5305\u3002\u6ce8\u610f\u8be5\u9009\u9879\u4f1a\u8986\u76d6 manifest \u4e2d\u7684\u9009\u9879\u5185\u5bb9", requires=false)
    public boolean mainClass;

    public byte[] getObject(byte[] bytes, String className) throws Exception {
        if (this.mainClass) {
            this.manifest = "Main-Class: " + className + "\n";
            log.info(this.manifest);
        }
        return this.create(className, bytes, this.manifest);
    }

    @Override
    public Object invoke(GadgetContext context, GadgetChain chain) throws Exception {
        byte[] bytecode = (byte[])chain.doCreate(context);
        String className = context.getString(ContextTag.CLASS_NAME_KEY);
        return this.getObject(bytecode, className);
    }

    public byte[] create(String className, byte[] byteCode, String manifest) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (JarOutputStream jos = new JarOutputStream(baos);){
            JarEntry entry = new JarEntry(className.replace(".", "/") + ".class");
            jos.putNextEntry(entry);
            jos.write(byteCode);
            jos.closeEntry();
            if (manifest != null) {
                entry = new JarEntry("META-INF/MANIFEST.MF");
                jos.putNextEntry(entry);
                jos.write(manifest.getBytes(StandardCharsets.UTF_8));
                jos.closeEntry();
            }
        }
        return baos.toByteArray();
    }
}

