/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.bytecode.convert;

import com.ar3h.chains.common.ContextTag;
import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.GadgetChain;
import com.ar3h.chains.common.GadgetContext;
import com.ar3h.chains.common.param.Param;
import com.ar3h.chains.common.param.ParamType;
import com.ar3h.chains.common.util.FileHelper;
import com.ar3h.chains.common.util.JavassistHelper;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellConvert
implements Gadget {
    private static final Logger log = LoggerFactory.getLogger(ShellConvert.class);
    @Param(name="\u7c7b\u540d", description="\u53ef\u624b\u52a8\u6307\u5b9a\u7c7b\u540d\uff0crandom \u4e3a\u968f\u673a\u7c7b\u540d")
    public String className = "random";
    public String realClassName;
    @Param(name="\u53bb\u9664\u5b57\u8282\u7801\u7b26\u53f7\u4fe1\u606f", description="\u53bb\u9664\u6e90\u7801\u6587\u4ef6\u540d\u3001\u6e90\u7801\u884c\u53f7\u3001\u5c40\u90e8\u53d8\u91cf\u540d\u7b49\u4fe1\u606f,\u5efa\u8bae\u5f00\u542f", type=ParamType.Boolean)
    public boolean shrink = true;
    @Param(name="\u5b57\u8282\u7801\u7248\u672c", description="JDK 8 = 52\nJDK 7 = 51\nJDK 6 = 50\nJDK 5 = 49\n46 \u53ef\u4ee5\u6b63\u5e38\u6267\u884c\u7b80\u5355\u6267\u884c\u547d\u4ee4\u5b57\u8282\u7801\uff0c\u4f46\u662f\u67d0\u4e9b\u6ce8\u5165\u5185\u5b58\u9a6c\u60c5\u51b5\u4e0b\u62a5java.class.Verify\u9519\u8bef\n\u63a8\u8350 JDK 6 \u7248\u672c(50)", type=ParamType.Integer)
    @Min(value=45L)
    @Max(value=60L)
    public @Min(value=45L) @Max(value=60L) int version = 50;
    public JavassistHelper javassistHelper;
    public GadgetContext gadgetContext;

    public void commonJavassist() throws Exception {
        this.javassistHelper.setClassName(this.realClassName);
        this.javassistHelper.setVersion(this.version);
        log.debug("set bytecode class name: {}", (Object)this.realClassName);
        log.debug("set bytecode version: {}", (Object)this.version);
        if (this.shrink) {
            this.javassistHelper.setCompress(true);
            this.javassistHelper.shrinkBytes();
        }
    }

    public void handleBytecode(GadgetContext context) {
        this.gadgetContext = context;
        this.realClassName = this.className == null || "".equals(this.className) || "random".equals(this.className) ? FileHelper.getRandomClassName() : this.className;
        context.put(this.getClass().getSimpleName() + ".className", this.realClassName);
        context.put(ContextTag.CLASS_NAME_KEY, this.realClassName);
        this.javassistHelper.setClassName(this.realClassName);
        this.javassistHelper.setVersion(this.version);
        log.debug("set bytecode class name: {}", (Object)this.realClassName);
        log.debug("set bytecode version: {}", (Object)this.version);
        if (this.shrink) {
            this.javassistHelper.setCompress(true);
            this.javassistHelper.shrinkBytes();
        }
    }

    @Override
    public Object invoke(GadgetContext context, GadgetChain chain) throws Exception {
        this.gadgetContext = context;
        this.realClassName = this.className == null || "".equals(this.className) || "random".equals(this.className) ? FileHelper.getRandomClassName() : this.className;
        context.put(this.getClass().getSimpleName() + ".className", this.realClassName);
        context.put(ContextTag.CLASS_NAME_KEY, this.realClassName);
        byte[] bytecode = (byte[])chain.doCreate(context);
        this.javassistHelper = new JavassistHelper(bytecode);
        this.commonJavassist();
        return this.javassistHelper.getBytecode();
    }
}

