/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.core.payload.enhance;

import com.caucho.hessian.io.Hessian2Output;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Random;

public class Hessian2OutputEnhance {
    public OutputStream os;
    public int overlongMode;

    public Hessian2OutputEnhance(OutputStream os, int overlongMode) {
        this.os = os;
        this.overlongMode = overlongMode;
    }

    public static Hessian2Output getHessian2Output(OutputStream os, int overlongMode) throws IOException {
        return new Hessian2OutputEnhance(os, overlongMode).build();
    }

    public Hessian2Output build() throws IOException {
        return new InnerHessian2Output(this.os);
    }

    public class InnerHessian2Output
    extends Hessian2Output {
        public InnerHessian2Output(OutputStream os) {
            super(os);
        }

        public void printString(String v, int strOffset, int length) throws IOException {
            int offset = (Integer)this.getSuperFieldValue("_offset");
            byte[] buffer = (byte[])this.getSuperFieldValue("_buffer");
            int threeByteCount = length / 2 + 1;
            for (int i = 0; i < length; ++i) {
                if (8192 <= offset + 16) {
                    this.setSuperFieldValue("_offset", offset);
                    this.flushBuffer();
                    offset = (Integer)this.getSuperFieldValue("_offset");
                }
                char ch = v.charAt(i + strOffset);
                if (Hessian2OutputEnhance.this.overlongMode == 1) {
                    if (this.randomCall(length - i, threeByteCount)) {
                        buffer[offset++] = (byte)(224 + (this.convert3(ch)[0] & 0xF));
                        buffer[offset++] = (byte)(128 + (this.convert3(ch)[1] & 0x3F));
                        buffer[offset++] = (byte)(128 + (this.convert3(ch)[2] & 0x3F));
                        continue;
                    }
                    buffer[offset++] = (byte)(192 + (this.convert2(ch)[0] & 0x1F));
                    buffer[offset++] = (byte)(128 + (this.convert2(ch)[1] & 0x3F));
                    continue;
                }
                if (Hessian2OutputEnhance.this.overlongMode == 2) {
                    buffer[offset++] = (byte)(192 + (this.convert2(ch)[0] & 0x1F));
                    buffer[offset++] = (byte)(128 + (this.convert2(ch)[1] & 0x3F));
                    continue;
                }
                if (Hessian2OutputEnhance.this.overlongMode == 3) {
                    buffer[offset++] = (byte)(224 + (this.convert3(ch)[0] & 0xF));
                    buffer[offset++] = (byte)(128 + (this.convert3(ch)[1] & 0x3F));
                    buffer[offset++] = (byte)(128 + (this.convert3(ch)[2] & 0x3F));
                    continue;
                }
                buffer[offset++] = (byte)(224 + (this.convert3(ch)[0] & 0xF));
                buffer[offset++] = (byte)(128 + (this.convert3(ch)[1] & 0x3F));
                buffer[offset++] = (byte)(128 + (this.convert3(ch)[2] & 0x3F));
            }
            this.setSuperFieldValue("_offset", offset);
        }

        public boolean randomCall(int remainingPositions, int remainingCalls) {
            long seed = System.currentTimeMillis();
            Random rand = new Random(seed);
            double probability = (double)remainingCalls / (double)remainingPositions;
            double randomProbability = rand.nextDouble();
            return randomProbability < probability;
        }

        public void printString(char[] v, int strOffset, int length) throws IOException {
            int offset = (Integer)this.getSuperFieldValue("_offset");
            byte[] buffer = (byte[])this.getSuperFieldValue("_buffer");
            int threeByteCount = length / 2 + 1;
            for (int i = 0; i < length; ++i) {
                if (8192 <= offset + 16) {
                    this.setSuperFieldValue("_offset", offset);
                    this.flushBuffer();
                    offset = (Integer)this.getSuperFieldValue("_offset");
                }
                char ch = v[i + strOffset];
                if (Hessian2OutputEnhance.this.overlongMode == 1) {
                    if (this.randomCall(length - i, threeByteCount)) {
                        buffer[offset++] = (byte)(224 + (this.convert3(ch)[0] & 0xF));
                        buffer[offset++] = (byte)(128 + (this.convert3(ch)[1] & 0x3F));
                        buffer[offset++] = (byte)(128 + (this.convert3(ch)[2] & 0x3F));
                        continue;
                    }
                    buffer[offset++] = (byte)(192 + (this.convert2(ch)[0] & 0x1F));
                    buffer[offset++] = (byte)(128 + (this.convert2(ch)[1] & 0x3F));
                    continue;
                }
                if (Hessian2OutputEnhance.this.overlongMode == 2) {
                    buffer[offset++] = (byte)(192 + (this.convert2(ch)[0] & 0x1F));
                    buffer[offset++] = (byte)(128 + (this.convert2(ch)[1] & 0x3F));
                    continue;
                }
                if (Hessian2OutputEnhance.this.overlongMode == 3) {
                    buffer[offset++] = (byte)(224 + (this.convert3(ch)[0] & 0xF));
                    buffer[offset++] = (byte)(128 + (this.convert3(ch)[1] & 0x3F));
                    buffer[offset++] = (byte)(128 + (this.convert3(ch)[2] & 0x3F));
                    continue;
                }
                buffer[offset++] = (byte)(224 + (this.convert3(ch)[0] & 0xF));
                buffer[offset++] = (byte)(128 + (this.convert3(ch)[1] & 0x3F));
                buffer[offset++] = (byte)(128 + (this.convert3(ch)[2] & 0x3F));
            }
            this.setSuperFieldValue("_offset", offset);
        }

        public int[] convert2(int i) {
            int b1 = i >> 6 & 0x1F | 0xC0;
            int b2 = i & 0x3F | 0x80;
            return new int[]{b1, b2};
        }

        public int[] convert3(int i) {
            int b1 = i >> 12 & 0xF | 0xE0;
            int b2 = i >> 6 & 0x3F | 0x80;
            int b3 = i & 0x3F | 0x80;
            return new int[]{b1, b2, b3};
        }

        public Object getSuperFieldValue(String name) {
            try {
                Field f = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField(name);
                f.setAccessible(true);
                return f.get((Object)this);
            }
            catch (Exception e) {
                return null;
            }
        }

        public void setSuperFieldValue(String name, Object val) {
            try {
                Field f = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField(name);
                f.setAccessible(true);
                f.set((Object)this, val);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

