/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.core.exploit;

import com.ar3h.chains.common.exception.ThrowsUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExploitFactory {
    private static final Logger log = LoggerFactory.getLogger(ExploitFactory.class);
    private static final Map<String, Class> exploitMap = new HashMap<String, Class>();

    public static Object create(String className) {
        Class exploitClass = ExploitFactory.getExploitClass(className);
        Object object = null;
        try {
            object = exploitClass.newInstance();
        }
        catch (Exception e) {
            ThrowsUtil.throwGadgetException(e);
        }
        return object;
    }

    public static Class getExploitClass(String className) {
        Class clazz = exploitMap.get(className.toLowerCase());
        if (clazz == null) {
            ThrowsUtil.throwGadgetException(" exploit class not found: " + className);
        }
        return clazz;
    }

    public static Map<String, Class> getExploitMap() {
        return exploitMap;
    }

    static {
        String packageName = "com.ar3h.chains.core.exploit";
        FilterBuilder filterBuilder = new FilterBuilder().includePackage(packageName).excludePackage("com.ar3h.chains.core.exploit.component");
        Reflections reflections = new Reflections(new ConfigurationBuilder().forPackages(packageName).setScanners(new SubTypesScanner(false)).filterInputsBy(filterBuilder));
        Set<Class<Object>> allClasses = reflections.getSubTypesOf(Object.class);
        exploitMap.putAll(allClasses.stream().filter(clazz -> clazz.getAnnotation(Deprecated.class) == null).filter(clazz -> !clazz.getSimpleName().contains("ExploitFactory")).filter(clazz -> !clazz.getSimpleName().contains("$")).collect(Collectors.toMap(clazz -> clazz.getSimpleName().toLowerCase(), clazz -> clazz)));
        log.info("loaded a total of {} exploits", (Object)exploitMap.size());
    }
}

