/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.core;

import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.Payload;
import com.ar3h.chains.common.exception.ThrowsUtil;
import com.ar3h.chains.core.ExecutionEngine;
import com.ar3h.chains.core.GadgetFactory;
import com.ar3h.chains.core.PayloadFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterUtil {
    private static final Logger log = LoggerFactory.getLogger(RouterUtil.class);
    public static String gadgetSplitChar = "/";
    public static String paramsSplitChar = ",";

    public static ExecutionEngine parsePayload(String payload, String base) {
        return RouterUtil.parsePayload(PayloadFactory.create(payload), base, gadgetSplitChar, paramsSplitChar);
    }

    public static ExecutionEngine parsePayload(Payload payload, String base) {
        return RouterUtil.parsePayload(payload, base, gadgetSplitChar, paramsSplitChar);
    }

    public static ExecutionEngine parsePayload(String fullString) {
        String newBase = fullString;
        while (newBase.startsWith(gadgetSplitChar)) {
            newBase = newBase.substring(gadgetSplitChar.length());
        }
        String payloadName = newBase.split(gadgetSplitChar)[0];
        String base = newBase.substring(payloadName.length() + gadgetSplitChar.length());
        return RouterUtil.parsePayload(PayloadFactory.create(payloadName), base, gadgetSplitChar, paramsSplitChar);
    }

    public static ExecutionEngine parsePayload(String payload, String baseString, String gadgetSplitChar, String paramsSplitChar) {
        return RouterUtil.parsePayload(PayloadFactory.create(payload), baseString, gadgetSplitChar, paramsSplitChar);
    }

    public static Object parsePayloadAndBuild(String payload, String baseString) {
        return RouterUtil.parsePayload(PayloadFactory.create(payload), baseString, gadgetSplitChar, paramsSplitChar).build();
    }

    public static Object parsePayloadAndBuild(String payload, String baseString, String gadgetSplitChar, String paramsSplitChar) {
        return RouterUtil.parsePayload(PayloadFactory.create(payload), baseString, gadgetSplitChar, paramsSplitChar).build();
    }

    public static ExecutionEngine parsePayload(Payload payload, String baseString, String gadgetSplitChar, String paramsSplitChar) {
        List<String> router = RouterUtil.parseBaseUrl(baseString, gadgetSplitChar);
        ExecutionEngine engine = new ExecutionEngine(payload);
        List<Gadget> gadgets = RouterUtil.parseGadget(router);
        for (Gadget gadget : gadgets) {
            log.info("Add gadget: {}", (Object)gadget.getClass().getSimpleName());
            engine.add(gadget);
        }
        Map<String, String> param = RouterUtil.parseParam(router, paramsSplitChar);
        if (param != null) {
            for (Map.Entry<String, String> entry : param.entrySet()) {
                log.info("Add param: {}:{}", (Object)entry.getKey(), (Object)entry.getValue());
                engine.set(entry.getKey(), entry.getValue());
            }
        }
        return engine;
    }

    public static List<String> parseBaseUrl(String base, String splitChar) {
        ArrayList<String> router;
        String newBase = base;
        while (newBase.startsWith(splitChar)) {
            newBase = newBase.substring(splitChar.length());
        }
        if (newBase.endsWith(splitChar)) {
            newBase = newBase.substring(0, newBase.length() - splitChar.length());
        }
        if ((router = new ArrayList<String>(Arrays.asList(newBase.split(splitChar, 10)))).size() <= 1) {
            ThrowsUtil.throwGadgetException("route is incorrect: " + router);
        }
        return router;
    }

    public static String cleanRoute(String base, String splitChar) {
        while (base.startsWith(splitChar)) {
            base = base.substring(1);
        }
        while (base.endsWith(splitChar)) {
            base = base.substring(0, base.length() - 1);
        }
        ArrayList<String> router = new ArrayList<String>(Arrays.asList(base.split(splitChar, 10)));
        if (router.size() <= 1) {
            ThrowsUtil.throwGadgetException("route is incorrect: " + router);
        }
        router.remove(0);
        return String.join((CharSequence)splitChar, router);
    }

    @Deprecated
    public static Payload parsePayload(List<String> router) {
        String payloadName = router.get(0);
        Payload payload = PayloadFactory.create(payloadName);
        return payload;
    }

    public static List<Gadget> parseGadget(List<String> router) {
        List<String> list = router.subList(0, router.size() - 1);
        if (list.size() == 0) {
            ThrowsUtil.throwGadgetException("the number of gadget is zero");
        }
        ArrayList<Gadget> gadgets = new ArrayList<Gadget>();
        for (String gadget : list) {
            Gadget g = GadgetFactory.create(gadget);
            gadgets.add(g);
        }
        return gadgets;
    }

    public static Map<String, String> parseParam(List<String> router, String paramsSplitChar) {
        String str = router.get(router.size() - 1);
        if ("x".equalsIgnoreCase(str)) {
            log.debug("param is 'x', skip");
            return null;
        }
        String paramString = RouterUtil.decode(str);
        String[] split2 = paramString.split(paramsSplitChar);
        HashMap<String, String> map = new HashMap<String, String>();
        if (split2.length == 0) {
            log.info("the number of param is zero, skip");
            return map;
        }
        for (String s : split2) {
            if (s == null || "".equals(s)) {
                log.info("not found param, skip");
                continue;
            }
            String[] strings = s.split("=", 2);
            map.put(strings[0], RouterUtil.decode(strings[1]));
        }
        return map;
    }

    public static String decode(String str) {
        String prefix = "BBB";
        String paramString = "";
        try {
            paramString = str.startsWith(prefix) ? new String(Base64.getDecoder().decode(str.substring(prefix.length()))) : str;
        }
        catch (Exception e) {
            log.warn("it's not base64 param");
            paramString = str;
        }
        return paramString;
    }
}

