/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.core;

import com.ar3h.chains.common.Payload;
import com.ar3h.chains.common.annotations.PayloadAnnotation;
import com.ar3h.chains.common.exception.ThrowsUtil;
import com.ar3h.chains.core.ExecutionEngine;
import com.ar3h.chains.core.GadgetFactory;
import com.ar3h.chains.core.PluginLoader;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayloadFactory {
    private static final Logger log = LoggerFactory.getLogger(PayloadFactory.class);
    private static Map<String, Class> payloadMap = new TreeMap<String, Class>(String.CASE_INSENSITIVE_ORDER);
    private static Map<String, Class> payloadPluginMap = new TreeMap<String, Class>(String.CASE_INSENSITIVE_ORDER);
    private static boolean initialized = false;
    public static String packageName = "com.ar3h.chains.core.payload.impl";

    public static void initPayload() {
        if (initialized) {
            return;
        }
        FilterBuilder filterBuilder = new FilterBuilder().includePackage(packageName);
        Reflections reflections = new Reflections(new ConfigurationBuilder().forPackages(packageName).setScanners(new SubTypesScanner(false)).filterInputsBy(filterBuilder));
        Set<Class<Payload>> allClasses = reflections.getSubTypesOf(Payload.class);
        payloadMap.putAll(allClasses.stream().filter(clazz -> clazz.getAnnotation(Deprecated.class) == null).filter(clazz -> clazz.getAnnotation(PayloadAnnotation.class) != null).filter(clazz -> !Modifier.isAbstract(clazz.getModifiers())).collect(Collectors.toMap(clazz -> clazz.getSimpleName(), clazz -> clazz)));
        log.info("loaded a total of {} payloads", (Object)payloadMap.size());
        initialized = true;
        PluginLoader.initPlugin();
    }

    public static void reload() {
        payloadMap = new TreeMap<String, Class>(String.CASE_INSENSITIVE_ORDER);
        payloadPluginMap = new TreeMap<String, Class>(String.CASE_INSENSITIVE_ORDER);
        initialized = false;
        PayloadFactory.initPayload();
        PluginLoader.reload();
    }

    public static Payload create(String className) {
        Class payloadClass = PayloadFactory.getPayloadClass(className);
        Payload object = null;
        try {
            object = (Payload)payloadClass.newInstance();
        }
        catch (InstantiationException e) {
            ThrowsUtil.throwGadgetException(e);
        }
        catch (IllegalAccessException e) {
            ThrowsUtil.throwGadgetException(e);
        }
        return object;
    }

    public static Class getPayloadClass(String className) {
        Class clazz = payloadMap.get(className.toLowerCase());
        if (clazz == null) {
            ThrowsUtil.throwGadgetException(" payload class not found: " + className);
        }
        return clazz;
    }

    public static Set<String> getGadgetStart(String payload) {
        Set<Class<?>> classes = PayloadFactory.getGadgetStartClasses(payload);
        return classes.stream().map(clazz -> clazz.getSimpleName()).collect(Collectors.toSet());
    }

    public static Set<Class<?>> getGadgetStartClasses(String payload) {
        Class payloadClass = PayloadFactory.getPayloadClass(payload);
        HashSet result = new HashSet();
        PayloadAnnotation annotation = payloadClass.getAnnotation(PayloadAnnotation.class);
        if (annotation == null) {
            return result;
        }
        String[] payloadStartTag = annotation.gadgetTags();
        Map<String, Class> gadgetMap = GadgetFactory.getGadgetMap();
        List gadgetList = gadgetMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        for (Class g : gadgetList) {
            if (ExecutionEngine.validationNextTag(g, payloadStartTag).isSuccess()) {
                result.add(g);
                continue;
            }
            for (String s : payloadStartTag) {
                Class clazz = gadgetMap.get(s);
                if (clazz == null) continue;
                result.add(clazz);
            }
        }
        return result;
    }

    public static Map<String, Class> getPayloadMap() {
        return payloadMap;
    }

    public static Map<String, Class> getPayloadPluginMap() {
        return payloadPluginMap;
    }

    public static void registry(Class clazz) {
        String name = clazz.getSimpleName();
        payloadMap.put(name, clazz);
        payloadPluginMap.put(name, clazz);
        log.info("registry payload: " + name);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PayloadFactory)) {
            return false;
        }
        PayloadFactory other = (PayloadFactory)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof PayloadFactory;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "PayloadFactory()";
    }

    static {
        PayloadFactory.initPayload();
    }
}

