/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.core;

import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.annotations.GadgetAnnotation;
import com.ar3h.chains.common.annotations.GadgetTags;
import com.ar3h.chains.common.exception.ThrowsUtil;
import com.ar3h.chains.common.util.ColoredLog;
import com.ar3h.chains.common.util.JarUtil;
import com.ar3h.chains.common.util.ThirdLibsClassLoader;
import com.ar3h.chains.core.PluginLoader;
import java.lang.reflect.Modifier;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GadgetFactory {
    private static final Logger log = LoggerFactory.getLogger(GadgetFactory.class);
    private static Map<String, Class> gadgetMap = new TreeMap<String, Class>(String.CASE_INSENSITIVE_ORDER);
    private static boolean initialized = false;
    public static String packageName = "com.ar3h.chains.gadget.impl";

    public static void initGadget() {
        if (initialized) {
            return;
        }
        FilterBuilder filterBuilder = new FilterBuilder().includePackage(packageName).excludePackage("com.ar3h.chains.gadget.impl.bytecode.common.template").excludePackage("com.ar3h.chains.gadget.impl.bytecode.echo.template").excludePackage("com.ar3h.chains.gadget.impl.bytecode.inject.template").excludePackage("com.ar3h.chains.gadget.impl.bytecode.shell.template");
        Reflections reflections = new Reflections(new ConfigurationBuilder().forPackages(packageName).setScanners(new SubTypesScanner(false)).filterInputsBy(filterBuilder));
        Set<Class<Gadget>> allClasses = reflections.getSubTypesOf(Gadget.class);
        HashMap<String, Class> map = new HashMap<String, Class>(allClasses.stream().filter(clazz -> clazz.getAnnotation(Deprecated.class) == null).filter(clazz -> clazz.getAnnotation(GadgetAnnotation.class) != null).filter(clazz -> clazz.getAnnotation(GadgetTags.class) != null).filter(clazz -> !Modifier.isAbstract(clazz.getModifiers())).collect(Collectors.toMap(clazz -> clazz.getSimpleName().toLowerCase(), clazz -> clazz)));
        HashMap<String, Class> updatedMap = new HashMap<String, Class>(map);
        for (Class clazz2 : map.values()) {
            String thirdLib;
            GadgetAnnotation annotation = clazz2.getAnnotation(GadgetAnnotation.class);
            if (annotation == null || (thirdLib = annotation.thirdLib()) == null || thirdLib.isEmpty()) continue;
            try {
                URLClassLoader classLoader = ThirdLibsClassLoader.getClassLoaderForDirectory(thirdLib);
                if (classLoader == null) {
                    log.info(ColoredLog.colorize("ThirdLib '{}' is null, plz check it", "\u001b[33m"), (Object)thirdLib);
                    continue;
                }
                Class<?> rawClass = PluginLoader.defineClass(classLoader, JarUtil.loadClassBytesFromCurrentJar(clazz2.getName()));
                if (rawClass == null || !Gadget.class.isAssignableFrom(rawClass)) continue;
                Class<?> aClass = rawClass;
                updatedMap.put(aClass.getSimpleName().toLowerCase(), aClass);
                log.info("use '{}' classLoader to load '{}'", (Object)thirdLib, (Object)clazz2.getSimpleName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        gadgetMap.putAll(updatedMap);
        log.info("loaded a total of {} gadgets", (Object)gadgetMap.size());
        initialized = true;
    }

    public static void reload() {
        gadgetMap = new TreeMap<String, Class>(String.CASE_INSENSITIVE_ORDER);
        initialized = false;
        GadgetFactory.initGadget();
    }

    public static Gadget create(String className) {
        Class gadgetClass = GadgetFactory.getGadgetClass(className);
        Gadget object = null;
        try {
            object = (Gadget)gadgetClass.newInstance();
        }
        catch (InstantiationException e) {
            ThrowsUtil.throwGadgetException(e);
        }
        catch (IllegalAccessException e) {
            ThrowsUtil.throwGadgetException(e);
        }
        return object;
    }

    public static Class getGadgetClass(String className) {
        Class clazz = gadgetMap.get(className.toLowerCase());
        if (clazz == null) {
            ThrowsUtil.throwGadgetException(" gadget class not found: " + className);
        }
        return clazz;
    }

    public static Map<String, Class> getGadgetMap() {
        return gadgetMap;
    }

    public static void registry(Class clazz) {
        String name = clazz.getSimpleName();
        gadgetMap.put(clazz.getSimpleName(), clazz);
        log.info("registry gadget: " + name);
    }

    static {
        GadgetFactory.initGadget();
    }
}

