/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.common.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThirdLibsClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(ThirdLibsClassLoader.class);
    private static ThirdLibsClassLoader INSTANCE = null;
    private static boolean initialized = false;
    public static final String thirdLibDir = "chains-config/third-libs";
    private static final String commonDir = "common";
    private static Map<String, URLClassLoader> pluginClassLoaderMap = new HashMap<String, URLClassLoader>();

    public static ThirdLibsClassLoader getInstance() {
        return INSTANCE;
    }

    public static void initClassLoader() {
        if (initialized) {
            return;
        }
        try {
            INSTANCE = ThirdLibsClassLoader.init();
            ThirdLibsClassLoader.initDirectoryClassLoaders();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to initialize class loader", e);
        }
        finally {
            initialized = true;
        }
    }

    public static void reload() {
        INSTANCE = null;
        initialized = false;
        pluginClassLoaderMap = new HashMap<String, URLClassLoader>();
        ThirdLibsClassLoader.initClassLoader();
    }

    public ThirdLibsClassLoader(URL[] urls) {
        super(urls, Thread.currentThread().getContextClassLoader());
    }

    public ThirdLibsClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                c = super.loadClass(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private static ThirdLibsClassLoader init() throws MalformedURLException {
        ThirdLibsClassLoader loader = new ThirdLibsClassLoader(new URL[0]);
        File commonDirectory = new File(thirdLibDir, commonDir);
        ArrayList<URL> jarUrls = new ArrayList<URL>();
        ThirdLibsClassLoader.findJarFiles(commonDirectory, jarUrls);
        for (URL url : jarUrls) {
            log.debug("Add common lib: {}", (Object)url);
            loader.addURL(url);
        }
        log.info("Loaded {} libraries from common directory", (Object)jarUrls.size());
        return loader;
    }

    private static void initDirectoryClassLoaders() throws MalformedURLException {
        File baseDir = new File(thirdLibDir);
        List<File> subDirs = ThirdLibsClassLoader.getFirstLevelDirectories(baseDir);
        for (File dir : subDirs) {
            if (dir.getName().equals(commonDir)) continue;
            ArrayList<URL> jarUrls = new ArrayList<URL>();
            ThirdLibsClassLoader.findJarFiles(dir, jarUrls);
            if (jarUrls.isEmpty()) continue;
            ThirdLibsClassLoader dirClassLoader = new ThirdLibsClassLoader(jarUrls.toArray(new URL[0]), (ClassLoader)INSTANCE);
            pluginClassLoaderMap.put(dir.getName(), dirClassLoader);
            log.info("Loaded {} libraries from directory: {}", (Object)jarUrls.size(), (Object)dir.getName());
        }
    }

    private static void findJarFiles(File dir, List<URL> jarUrls) throws MalformedURLException {
        File[] files;
        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    ThirdLibsClassLoader.findJarFiles(file, jarUrls);
                    continue;
                }
                if (!file.getName().endsWith(".jar")) continue;
                if (file.getName().startsWith("_")) {
                    log.info("Skip third lib {}", (Object)file.getName());
                    continue;
                }
                jarUrls.add(file.toURI().toURL());
            }
        }
    }

    private static List<File> getFirstLevelDirectories(File baseDir) {
        File[] files;
        ArrayList<File> directories = new ArrayList<File>();
        if (baseDir.exists() && baseDir.isDirectory() && (files = baseDir.listFiles()) != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                directories.add(file);
            }
        }
        return directories;
    }

    public static Class<?> loadClass_(String className) throws ClassNotFoundException {
        return INSTANCE.loadClass(className);
    }

    public static URLClassLoader getClassLoader() {
        return INSTANCE;
    }

    public static URLClassLoader getClassLoaderForDirectory(String directoryName) {
        return pluginClassLoaderMap.get(directoryName);
    }

    public static Map<String, URLClassLoader> getPluginClassLoaderMap() {
        return pluginClassLoaderMap;
    }

    static {
        ThirdLibsClassLoader.initClassLoader();
    }
}

