/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.common.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class StringUtil {
    public static String join(Iterable<String> strings, String sep, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : strings) {
            if (!first) {
                sb.append(sep);
            }
            if (prefix != null) {
                sb.append(prefix);
            }
            sb.append(s);
            if (suffix != null) {
                sb.append(suffix);
            }
            first = false;
        }
        return sb.toString();
    }

    public static String repeat(String str, int num) {
        Object[] strs = new String[num];
        Arrays.fill(strs, str);
        return StringUtil.join(Arrays.asList(strs), "", "", "");
    }

    public static List<String> formatTable(List<String[]> rows) {
        Integer[] maxLengths = new Integer[rows.get(0).length];
        for (String[] row : rows) {
            if (maxLengths.length != row.length) {
                throw new IllegalStateException("mismatched columns");
            }
            for (int i = 0; i < maxLengths.length; ++i) {
                if (maxLengths[i] != null && maxLengths[i] >= row[i].length()) continue;
                maxLengths[i] = row[i].length();
            }
        }
        LinkedList<String> lines = new LinkedList<String>();
        for (String[] row : rows) {
            for (int i = 0; i < maxLengths.length; ++i) {
                String pad = StringUtil.repeat(" ", maxLengths[i] - row[i].length());
                row[i] = row[i] + pad;
            }
            lines.add(StringUtil.join(Arrays.asList(row), " ", "", ""));
        }
        return lines;
    }

    public static boolean isFromExploit() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElements.length; ++i) {
            if (!stackTraceElements[i].getClassName().startsWith("com.qi4l.jndi.exploit")) continue;
            return true;
        }
        return false;
    }

    public static class ToStringComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

