/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.common.util;

import com.ar3h.chains.common.exception.ThrowsUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CommonUtil {
    public static <T> T[] concatenateArrays(T[] array1, T[] array2) {
        int length1 = array1.length;
        int length2 = array2.length;
        T[] result = Arrays.copyOf(array1, length1 + length2);
        System.arraycopy(array2, 0, result, length1, length2);
        return result;
    }

    public static void setFV(Object var0, String var1, Object val) throws Exception {
        CommonUtil.getF(var0, var1).set(var0, val);
    }

    public static Object getFV(Object obj, String fieldName) throws Exception {
        Field field = CommonUtil.getF(obj, fieldName);
        field.setAccessible(true);
        return field.get(obj);
    }

    public static Field getF(Object obj, String fieldName) throws NoSuchFieldException {
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException(fieldName);
    }

    public static synchronized Object invokeMethod(Object targetObject, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return CommonUtil.invokeMethod(targetObject, methodName, new Class[0], new Object[0]);
    }

    public static Object invokeMethod(Object obj, String methodName, Class[] paramClazz, Object[] param) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        Method method = null;
        Class<?> tempClass = clazz;
        block6: while (method == null && tempClass != null) {
            try {
                if (paramClazz == null) {
                    Method[] methods = tempClass.getDeclaredMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        if (!methods[i].getName().equals(methodName) || methods[i].getParameterTypes().length != 0) continue;
                        method = methods[i];
                        continue block6;
                    }
                    continue;
                }
                method = tempClass.getDeclaredMethod(methodName, paramClazz);
            }
            catch (NoSuchMethodException e) {
                tempClass = tempClass.getSuperclass();
            }
        }
        if (method == null) {
            throw new NoSuchMethodException(methodName);
        }
        method.setAccessible(true);
        if (obj instanceof Class) {
            try {
                return method.invoke(null, param);
            }
            catch (IllegalAccessException e) {
                ThrowsUtil.throwGadgetException(e.getMessage());
            }
        } else {
            try {
                return method.invoke(obj, param);
            }
            catch (IllegalAccessException e) {
                ThrowsUtil.throwGadgetException(e.getMessage());
            }
        }
        return null;
    }

    public static String generateRandomString() {
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        int length = random.nextInt(5) + 2;
        for (int i = 0; i < length; ++i) {
            char c = (char)(random.nextInt(26) + 97);
            if (i == 0) {
                c = Character.toUpperCase(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static byte[] base64Decode(String var0) throws Exception {
        byte[] var2 = null;
        try {
            Class<?> var1 = Class.forName("java.util.Base64");
            Object var3 = var1.getMethod("getDecoder", new Class[0]).invoke(null, (Object[])null);
            var2 = (byte[])var3.getClass().getMethod("decode", String.class).invoke(var3, var0);
        }
        catch (Exception var6) {
            try {
                Class<?> var1 = Class.forName("sun.misc.BASE64Decoder");
                Object var4 = var1.newInstance();
                var2 = (byte[])var4.getClass().getMethod("decodeBuffer", String.class).invoke(var4, var0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return var2;
    }

    public static String encodeBase64(byte[] bs) throws Exception {
        String value = null;
        try {
            Class<?> base64 = Class.forName("java.util.Base64");
            Object Encoder2 = base64.getMethod("getEncoder", null).invoke(base64, (Object[])null);
            value = (String)Encoder2.getClass().getMethod("encodeToString", byte[].class).invoke(Encoder2, new Object[]{bs});
        }
        catch (Exception var6) {
            try {
                Class<?> base64 = Class.forName("sun.misc.BASE64Encoder");
                Object Encoder3 = base64.newInstance();
                value = (String)Encoder3.getClass().getMethod("encode", byte[].class).invoke(Encoder3, new Object[]{bs});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public static String genRandomLengthString(int minLength) {
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        int length = random.nextInt(6) + minLength;
        for (int i = 0; i < length; ++i) {
            char c = (char)(random.nextInt(26) + 97);
            if (i == 0) {
                c = Character.toUpperCase(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getRandomString(int length) {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        SecureRandom random = new SecureRandom();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(52);
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }

    public static String getRandomString(int minLength, int maxLength) {
        int length = ThreadLocalRandom.current().nextInt(minLength, maxLength + 1);
        return CommonUtil.getRandomString(length);
    }

    public static String getMd5(String text) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] bytes = md5.digest(text.getBytes(StandardCharsets.UTF_8));
        StringBuilder builder = new StringBuilder();
        for (byte aByte : bytes) {
            builder.append(Integer.toHexString(0xFF & aByte | 0xFFFFFF00).substring(6));
        }
        return builder.toString();
    }

    public static byte[] gzipCompress(byte[] data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPOutputStream gzip = new GZIPOutputStream(out);){
            gzip.write(data);
        }
        return out.toByteArray();
    }

    public static byte[] gzipDecompress(byte[] compressedData) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(compressedData);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);){
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = gzipInputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
        }
        return outputStream.toByteArray();
    }

    public static byte[] getFileBytes(String file) throws Exception {
        File f = new File(file);
        int length = (int)f.length();
        byte[] data = new byte[length];
        new FileInputStream(f).read(data);
        return data;
    }

    public static String getSimpleName(String className) {
        int lastDotIndex = className.lastIndexOf(".");
        if (lastDotIndex != -1 && lastDotIndex < className.length() - 1) {
            return className.substring(lastDotIndex + 1);
        }
        return className;
    }

    public static String getThrowableStackTrace(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

