/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.utils.register;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.SimpleGeneratorMachine;
import com.gregtechceu.gtceu.api.machine.SimpleTieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.ICoilMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.FactoryBlockPattern;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.client.renderer.machine.OverlayTieredMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.SimpleGeneratorMachineRenderer;
import com.gregtechceu.gtceu.common.data.GCYMBlocks;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.machines.GTMachineUtils;
import com.gregtechceu.gtceu.common.machine.multiblock.part.LaserHatchPartMachine;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.api.lang.ComponentListSupplier;
import com.gtocore.api.pattern.GTOPredicates;
import com.gtocore.common.data.GTOBlocks;
import com.gtocore.common.data.GTOMachines;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.common.data.machines.MultiBlockA;
import com.gtocore.common.data.translation.GTOMachineTooltips;
import com.gtocore.common.machine.mana.SimpleWorkManaMachine;
import com.gtocore.common.machine.multiblock.generator.CombustionEngineMachine;
import com.gtocore.common.machine.multiblock.generator.TurbineMachine;
import com.gtolib.GTOCore;
import com.gtolib.api.GTOValues;
import com.gtolib.api.blockentity.ManaMachineBlockEntity;
import com.gtolib.api.machine.SimpleNoEnergyMachine;
import com.gtolib.api.machine.impl.part.WirelessEnergyHatchPartMachine;
import com.gtolib.api.recipe.modifier.RecipeModifierFunction;
import com.gtolib.api.registries.GTOMachineBuilder;
import com.gtolib.api.registries.GTORegistration;
import com.gtolib.api.registries.MultiblockBuilder;
import com.gtolib.utils.GTOUtils;
import com.gtolib.utils.register.BlockRegisterUtils;
import com.hepdd.gtmthings.GTMThings;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.function.TriFunction;

public final class MachineRegisterUtils {
    public static final int[] MANA_TIERS = GTValues.tiersBetween((int)1, (int)7);
    private static final MultiblockMachineDefinition DUMMY_MULTIBLOCK = MultiblockMachineDefinition.createDefinition((ResourceLocation)GTOCore.id((String)"dummy"));
    public static final BiConsumer<IMultiController, List<Component>> CHEMICAL_PLANT_DISPLAY = (controller, components) -> {
        double value = 1.0 - (double)((ICoilMachine)controller).getCoilTier() * 0.05;
        components.add(Component.m_237110_((String)"gtocore.machine.eut_multiplier.tooltip", (Object[])new Object[]{FormattingUtil.formatNumbers((double)(value * 0.8))}));
        components.add(Component.m_237110_((String)"gtocore.machine.duration_multiplier.tooltip", (Object[])new Object[]{FormattingUtil.formatNumbers((double)(value * 0.6))}));
    };

    private MachineRegisterUtils() {
    }

    public static GTOMachineBuilder machine(String name, String cn, Function<MetaMachineBlockEntity, MetaMachine> metaMachine) {
        BlockRegisterUtils.addLang((String)name, (String)cn);
        return GTORegistration.GTO.machine(name, metaMachine);
    }

    public static MultiblockBuilder multiblock(String name, String cn, Function<MetaMachineBlockEntity, ? extends MultiblockControllerMachine> metaMachine) {
        BlockRegisterUtils.addLang((String)name, (String)cn);
        return GTORegistration.GTO.multiblock(name, metaMachine);
    }

    public static MachineDefinition[] registerWirelessEnergyHatch(IO io, int amperage, PartAbility ability) {
        String id = io == IO.IN ? "input" : "output";
        String iao = io == IO.IN ? "in" : "out";
        Object render = "wireless_energy_hatch";
        Object finalRender = render = (switch (amperage) {
            case 2 -> render;
            case 4 -> (String)render + "_4a";
            case 16 -> (String)render + "_16a";
            case 64 -> (String)render + "_64a";
            default -> "wireless_laser_hatch.target";
        });
        int t = 1;
        if (amperage == 64) {
            t = 4;
        } else if (amperage > 64) {
            t = 5;
        }
        return MachineRegisterUtils.registerTieredMachines("wireless_" + id + "_hatch" + (String)(amperage > 2 ? "_" + amperage + "a" : ""), tier -> (String)(amperage > 2 ? amperage + (amperage > 64 ? "\u00a7e\u5b89\u00a7r" : "\u5b89") : "") + GTOValues.VNFR[tier] + "\u65e0\u7ebf" + (io == IO.IN ? "\u80fd\u6e90" : "\u52a8\u529b") + "\u4ed3", (holder, tier) -> new WirelessEnergyHatchPartMachine(holder, tier.intValue(), io, amperage), (arg_0, arg_1) -> MachineRegisterUtils.lambda$registerWirelessEnergyHatch$4(amperage, io, ability, iao, id, (String)finalRender, arg_0, arg_1), GTValues.tiersBetween((int)t, (int)14));
    }

    public static MachineDefinition[] registerLaserHatch(IO io, int amperage, PartAbility ability) {
        String name = io == IO.IN ? "target" : "source";
        return MachineRegisterUtils.registerTieredMachines(amperage + "a_laser_" + name + "_hatch", tier -> amperage + "\u00a7e\u5b89\u00a7r" + GTOValues.VNFR[tier] + "\u6fc0\u5149" + (io == IO.IN ? "\u9776" : "\u6e90") + "\u4ed3", (holder, tier) -> new LaserHatchPartMachine(holder, io, tier.intValue(), amperage), (tier, builder) -> builder.langValue(GTOValues.VNFR[tier] + " " + FormattingUtil.formatNumbers((int)amperage) + "\u00a7eA\u00a7r Laser " + FormattingUtil.toEnglishName((Object)name) + " Hatch").allRotation().tooltips(new Component[]{Component.m_237115_((String)("gtceu.machine.laser_hatch." + name + ".tooltip")), Component.m_237115_((String)"gtceu.machine.laser_hatch.both.tooltip")}).notAllowSharedTooltips().abilities(new PartAbility[]{ability}).renderer(() -> new OverlayTieredMachineRenderer(tier.intValue(), GTCEu.id((String)("block/machine/part/laser_hatch." + name)))).register(), GTValues.tiersBetween((int)5, (int)14));
    }

    public static MachineDefinition[] registerSimpleGenerator(String name, String cn, GTRecipeType recipeType, Int2IntFunction tankScalingFunction, int ... tiers) {
        return MachineRegisterUtils.registerTieredMachines(name, tier -> "%s%s %s".formatted(GTOValues.VLVHCN[tier], cn, GTValues.VLVT[tier]), (holder, tier) -> new SimpleGeneratorMachine(holder, tier.intValue(), 0.1f * (float)tier.intValue(), tankScalingFunction, new Object[0]), (tier, builder) -> builder.langValue("%s %s %s".formatted(GTValues.VLVH[tier], FormattingUtil.toEnglishName((Object)name), GTValues.VLVT[tier])).editableUI((EditableMachineUI)SimpleGeneratorMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id((String)name), recipeType)).allRotation().recipeType(recipeType).recipeModifier(RecipeModifierFunction.SIMPLE_GENERATOR_MACHINEMODIFIER).addOutputLimit((RecipeCapability)ItemRecipeCapability.CAP, 0).addOutputLimit((RecipeCapability)FluidRecipeCapability.CAP, 0).renderer(() -> new SimpleGeneratorMachineRenderer(tier.intValue(), GTOCore.id((String)("block/generators/" + name)))).tooltips(new Component[]{Component.m_237110_((String)"gtocore.machine.efficiency.tooltip", (Object[])new Object[]{GTOUtils.getGeneratorEfficiency((GTRecipeType)recipeType, (int)tier)}).m_130946_("%")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.amperage_out", (Object[])new Object[]{GTOUtils.getGeneratorAmperage((int)tier)})}).tooltips(GTMachineUtils.workableTiered((int)tier, (long)GTValues.V[tier], (long)(GTValues.V[tier] << 6), (GTRecipeType)recipeType, (long)((Integer)tankScalingFunction.apply(tier)).intValue(), (boolean)false)).register(), tiers);
    }

    public static MachineDefinition[] registerRocketSimpleGenerator(String name, String cn, GTRecipeType recipeType, Int2IntFunction tankScalingFunction, int ... tiers) {
        return MachineRegisterUtils.registerTieredMachines(name, tier -> "%s%s %s".formatted(GTOValues.VLVHCN[tier], cn, GTValues.VLVT[tier]), (holder, tier) -> new SimpleGeneratorMachine(holder, tier.intValue(), 0.1f * (float)tier.intValue(), tankScalingFunction, new Object[0]), (tier, builder) -> builder.langValue("%s %s %s".formatted(GTValues.VLVH[tier], FormattingUtil.toEnglishName((Object)name), GTValues.VLVT[tier])).editableUI((EditableMachineUI)SimpleGeneratorMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id((String)name), recipeType)).allRotation().workableInSpace().recipeType(recipeType).recipeModifier(RecipeModifierFunction.SIMPLE_GENERATOR_MACHINEMODIFIER).addOutputLimit((RecipeCapability)ItemRecipeCapability.CAP, 0).addOutputLimit((RecipeCapability)FluidRecipeCapability.CAP, 0).renderer(() -> new SimpleGeneratorMachineRenderer(tier.intValue(), GTOCore.id((String)("block/generators/" + name)))).tooltips(new Component[]{Component.m_237110_((String)"gtocore.machine.efficiency.tooltip", (Object[])new Object[]{GTOUtils.getGeneratorEfficiency((GTRecipeType)recipeType, (int)tier)}).m_130946_("%")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.amperage_out", (Object[])new Object[]{GTOUtils.getGeneratorAmperage((int)tier)})}).tooltips(GTMachineUtils.workableTiered((int)tier, (long)GTValues.V[tier], (long)(GTValues.V[tier] << 6), (GTRecipeType)recipeType, (long)((Integer)tankScalingFunction.apply(tier)).intValue(), (boolean)false)).register(), tiers);
    }

    public static MachineDefinition[] registerSimpleMachines(String name, String cn, GTRecipeType recipeType, Int2IntFunction tankScalingFunction) {
        return MachineRegisterUtils.registerSimpleMachines(name, cn, recipeType, tankScalingFunction, GTMachineUtils.ELECTRIC_TIERS);
    }

    public static MachineDefinition[] registerSimpleMachines(String name, String cn, GTRecipeType recipeType, Int2IntFunction tankScalingFunction, int ... tiers) {
        return MachineRegisterUtils.registerSimpleMachines(name, cn, recipeType, tankScalingFunction, GTOCore.id((String)("block/machines/" + name)), tiers);
    }

    public static MachineDefinition[] registerSimpleMachines(String name, String cn, GTRecipeType recipeType, Int2IntFunction tankScalingFunction, ResourceLocation workableModel, int ... tiers) {
        return MachineRegisterUtils.registerTieredMachines(name, tier -> "%s%s %s".formatted(GTOValues.VLVHCN[tier], cn, GTValues.VLVT[tier]), (holder, tier) -> new SimpleTieredMachine(holder, tier.intValue(), tankScalingFunction, new Object[0]), (tier, builder) -> {
            builder.recipeModifier(RecipeModifierFunction.OVERCLOCKING);
            return builder.langValue("%s %s %s".formatted(GTValues.VLVH[tier], FormattingUtil.toEnglishName((Object)name), GTValues.VLVT[tier])).editableUI((EditableMachineUI)SimpleTieredMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id((String)name), recipeType)).nonYAxisRotation().recipeType(recipeType).workableTieredHullRenderer(workableModel).tooltips(GTMachineUtils.workableTiered((int)tier, (long)GTValues.V[tier], (long)(GTValues.V[tier] << 6), (GTRecipeType)recipeType, (long)((Integer)tankScalingFunction.apply(tier)).intValue(), (boolean)true)).register();
        }, tiers);
    }

    public static MachineDefinition[] registerSimpleNoEnergyMachines(String name, String cn, GTRecipeType recipeType, Int2IntFunction tankScalingFunction, int ... tiers) {
        return MachineRegisterUtils.registerSimpleNoEnergyMachines(name, cn, recipeType, tankScalingFunction, GTOCore.id((String)("block/machines/" + name)), tiers);
    }

    private static MachineDefinition[] registerSimpleNoEnergyMachines(String name, String cn, GTRecipeType recipeType, Int2IntFunction tankScalingFunction, ResourceLocation workableModel, int ... tiers) {
        return MachineRegisterUtils.registerTieredMachines(name, tier -> "%s%s %s".formatted(GTOValues.VLVHCN[tier], cn, GTValues.VLVT[tier]), (holder, tier) -> new SimpleNoEnergyMachine(holder, tier.intValue(), tankScalingFunction, new Object[0]), (tier, builder) -> builder.langValue("%s %s %s".formatted(GTValues.VLVH[tier], FormattingUtil.toEnglishName((Object)name), GTValues.VLVT[tier])).editableUI((EditableMachineUI)SimpleNoEnergyMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id((String)name), recipeType)).nonYAxisRotation().recipeType(recipeType).noRecipeModifier().workableTieredHullRenderer(workableModel).tooltips(MachineRegisterUtils.workableNoEnergy(recipeType, ((Integer)tankScalingFunction.apply(tier)).intValue())).register(), tiers);
    }

    public static Component[] workableNoEnergy(GTRecipeType recipeType, long tankCapacity) {
        ArrayList<MutableComponent> tooltipComponents = new ArrayList<MutableComponent>();
        if (recipeType.getMaxInputs((RecipeCapability)FluidRecipeCapability.CAP) > 0 || recipeType.getMaxOutputs((RecipeCapability)FluidRecipeCapability.CAP) > 0) {
            tooltipComponents.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers((long)tankCapacity)}));
        }
        return (Component[])tooltipComponents.toArray(Component[]::new);
    }

    public static MachineDefinition[] registerTieredMachines(String name, Function<Integer, String> cn, BiFunction<MetaMachineBlockEntity, Integer, MetaMachine> factory, BiFunction<Integer, GTOMachineBuilder, MachineDefinition> builder, int ... tiers) {
        MachineDefinition[] definitions = new MachineDefinition[GTValues.TIER_COUNT];
        for (int tier : tiers) {
            String n = GTValues.VN[tier].toLowerCase(Locale.ROOT) + "_" + name;
            if (cn != null) {
                BlockRegisterUtils.addLang((String)n, (String)cn.apply(tier));
            }
            GTOMachineBuilder register = GTORegistration.GTO.machine(n, holder -> (MetaMachine)factory.apply((MetaMachineBlockEntity)holder, tier)).tier(tier);
            definitions[tier] = builder.apply(tier, register);
        }
        return definitions;
    }

    public static Pair<MachineDefinition, MachineDefinition> registerSteamMachines(String name, String cn, BiFunction<MetaMachineBlockEntity, Boolean, MetaMachine> factory, BiFunction<Boolean, GTOMachineBuilder, MachineDefinition> builder) {
        MachineDefinition lowTier = builder.apply(false, MachineRegisterUtils.machine("lp_%s".formatted(name), "\u4f4e\u538b\u84b8\u6c7d%s".formatted(cn), holder -> (MetaMachine)factory.apply((MetaMachineBlockEntity)holder, false)).langValue("Low Pressure " + FormattingUtil.toEnglishName((Object)name)).tier(0));
        MachineDefinition highTier = builder.apply(true, MachineRegisterUtils.machine("hp_%s".formatted(name), "\u9ad8\u538b\u84b8\u6c7d%s".formatted(cn), holder -> (MetaMachine)factory.apply((MetaMachineBlockEntity)holder, true)).langValue("High Pressure " + FormattingUtil.toEnglishName((Object)name)).tier(1));
        return Pair.of((Object)lowTier, (Object)highTier);
    }

    public static MultiblockMachineDefinition[] registerTieredMultis(String name, Function<Integer, String> cn, BiFunction<MetaMachineBlockEntity, Integer, MultiblockControllerMachine> factory, BiFunction<Integer, MultiblockBuilder, MultiblockMachineDefinition> builder, int ... tiers) {
        MultiblockMachineDefinition[] definitions = new MultiblockMachineDefinition[GTValues.TIER_COUNT];
        for (int tier : tiers) {
            MultiblockBuilder register = MachineRegisterUtils.multiblock(GTValues.VN[tier].toLowerCase(Locale.ROOT) + "_" + name, cn.apply(tier), holder -> (MultiblockControllerMachine)factory.apply((MetaMachineBlockEntity)holder, tier)).tier(tier);
            definitions[tier] = builder.apply(tier, register);
        }
        return definitions;
    }

    public static MultiblockMachineDefinition registerLargeCombustionEngine(GTORegistration registrate, String name, String cn, int tier, GTRecipeType recipeType, Supplier<? extends Block> casing, Supplier<? extends Block> gear, Supplier<? extends Block> intake, ResourceLocation casingTexture, ResourceLocation overlayModel, boolean isGTM) {
        if (!isGTM) {
            BlockRegisterUtils.addLang((String)name, (String)cn);
        }
        MultiblockBuilder builder = registrate.multiblock(name, holder -> new CombustionEngineMachine((MetaMachineBlockEntity)holder, tier)).nonYAxisRotation().recipeTypes(new GTRecipeType[]{recipeType}).tooltips(((ComponentListSupplier)GTOMachineTooltips.INSTANCE.getLargeCombustionTooltips().invoke((Object)(GTValues.V[tier] << 1), (Object)(GTValues.V[tier] * 6L), (Object)(tier > 4 ? 1 : 0), (Object)(GTValues.V[tier] << 3))).getSupplier()).moduleTooltips(new PartAbility[0]).generator().block(casing).pattern(definition -> FactoryBlockPattern.start((MultiblockMachineDefinition)definition).aisle(new String[]{"XXX", "XDX", "XXX"}).aisle(new String[]{"XCX", "CGC", "XCX"}).aisle(new String[]{"XCX", "CGC", "XCX"}).aisle(new String[]{"AAA", "AYA", "AAA"}).where('X', Predicates.blocks((Block[])new Block[]{(Block)casing.get()})).where('G', Predicates.blocks((Block[])new Block[]{(Block)gear.get()})).where('C', Predicates.blocks((Block[])new Block[]{(Block)casing.get()}).setMinGlobalLimited(3).or(Predicates.autoAbilities((GTRecipeType[])definition.getRecipeTypes(), (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)true)).or(Predicates.autoAbilities((boolean)true, (boolean)true, (boolean)false))).where('D', Predicates.ability((PartAbility)PartAbility.OUTPUT_ENERGY, (int[])Stream.of(4, 5, 6, 7, 8, 9).filter(t -> t >= tier).mapToInt(Integer::intValue).toArray()).addTooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.large_combustion_engine.tooltip.boost_regular", (Object[])new Object[]{GTValues.V[tier] * 6L})})).where('A', Predicates.blocks((Block[])new Block[]{(Block)intake.get()}).addTooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.pattern.clear_amount_1")})).where('Y', Predicates.controller((MachineDefinition)definition)).build()).workableCasingRenderer(casingTexture, overlayModel);
        if (tier == 4) {
            if (recipeType == GTORecipeTypes.SEMI_FLUID_GENERATOR_FUELS) {
                builder.addSubPattern(definition -> FactoryBlockPattern.start((MultiblockMachineDefinition)definition).aisle(new String[]{"ADDDA", "BFBFB", "BFFFB", "BBBBB"}).aisle(new String[]{"ACCCA", "ACBCA", "ACCCA", " AAA "}).aisle(new String[]{"ACCCA", " EBE ", " CCC ", " GGG "}).aisle(new String[]{"A   A", "A   A", "A   A", " AAA "}).aisle(new String[]{"A   A", "     ", "     ", " GGG "}).aisle(new String[]{"A   A", "A   A", "A   A", " AAA "}).aisle(new String[]{"A   A", "  H  ", "     ", "     "}).where('A', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_TITANIUM_TURBINE.get()})).where('B', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.StainlessSteel)})).where('C', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_TITANIUM_STABLE.get()})).where('D', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.FIREBOX_TITANIUM.get()})).where('E', Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.MUFFLER})).where('F', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_TITANIUM_STABLE.get()}).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.OUTPUT_ENERGY}).setMaxGlobalLimited(3))).where('G', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_ENGINE_INTAKE.get()})).where('H', Predicates.controller((MachineDefinition)definition)).where(' ', Predicates.any()).build());
            } else {
                builder.addSubPattern(definition -> FactoryBlockPattern.start((MultiblockMachineDefinition)definition).aisle(new String[]{"ADDDA", "BFBFB", "BFFFB", "BBBBB"}).aisle(new String[]{"ACCCA", "ACBCA", "ACCCA", " AAA "}).aisle(new String[]{"ACCCA", " EBE ", " CCC ", " GGG "}).aisle(new String[]{"A   A", "A   A", "A   A", " AAA "}).aisle(new String[]{"A   A", "     ", "     ", " GGG "}).aisle(new String[]{"A   A", "A   A", "A   A", " AAA "}).aisle(new String[]{"A   A", "  H  ", "     ", "     "}).where('A', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_TITANIUM_TURBINE.get()})).where('B', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.BlueSteel)})).where('C', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_TITANIUM_STABLE.get()})).where('D', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.FIREBOX_TITANIUM.get()})).where('E', Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.MUFFLER})).where('F', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_TITANIUM_STABLE.get()}).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.OUTPUT_ENERGY}).setMaxGlobalLimited(3))).where('G', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_ENGINE_INTAKE.get()})).where('H', Predicates.controller((MachineDefinition)definition)).where(' ', Predicates.any()).build());
            }
        } else {
            builder.addSubPattern(definition -> FactoryBlockPattern.start((MultiblockMachineDefinition)definition).aisle(new String[]{"ADDDA", "BFBFB", "BFFFB", "BBBBB"}).aisle(new String[]{"ACCCA", "ACBCA", "ACCCA", " AAA "}).aisle(new String[]{"ACCCA", " EBE ", " CCC ", " GGG "}).aisle(new String[]{"A   A", "A   A", "A   A", " AAA "}).aisle(new String[]{"A   A", "     ", "     ", " GGG "}).aisle(new String[]{"A   A", "A   A", "A   A", " AAA "}).aisle(new String[]{"A   A", "  H  ", "     ", "     "}).where('A', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_TUNGSTENSTEEL_TURBINE.get()})).where('B', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.BlackSteel)})).where('C', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_TUNGSTENSTEEL_ROBUST.get()})).where('D', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.FIREBOX_TUNGSTENSTEEL.get()})).where('E', Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.MUFFLER})).where('F', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_TUNGSTENSTEEL_ROBUST.get()}).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.OUTPUT_ENERGY}).setMaxGlobalLimited(3))).where('G', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_EXTREME_ENGINE_INTAKE.get()})).where('H', Predicates.controller((MachineDefinition)definition)).where(' ', Predicates.any()).build());
        }
        return builder.register();
    }

    public static MultiblockMachineDefinition registerLargeTurbine(GTORegistration registrate, String name, String cn, int tier, boolean special, GTRecipeType recipeType, Supplier<? extends Block> casing, Supplier<? extends Block> gear, ResourceLocation casingTexture, ResourceLocation overlayModel, boolean isGTM) {
        if (Objects.equals(name, "plasma_large_turbine")) {
            DUMMY_MULTIBLOCK.setItemSupplier(() -> ((MultiblockMachineDefinition)MultiBlockA.VOID_MINER).asItem());
            return DUMMY_MULTIBLOCK;
        }
        if (!isGTM) {
            BlockRegisterUtils.addLang((String)name, (String)cn);
        }
        MultiblockBuilder builder = registrate.multiblock(name, holder -> new TurbineMachine((MetaMachineBlockEntity)holder, tier, special, false)).addTooltipsFromClass(TurbineMachine.class).tooltips(((ComponentListSupplier)GTOMachineTooltips.INSTANCE.getLargeTurbineTooltips().invoke((Object)((long)((double)GTValues.V[tier] * (special ? 2.5 : 2.0))), (Object)tier)).getSupplier()).tooltips(GTOMachineTooltips.INSTANCE.getTurbineHighSpeedTooltips().getSupplier()).moduleTooltips(new PartAbility[0]).nonYAxisRotation().recipeTypes(new GTRecipeType[]{recipeType}).generator().block(casing).pattern(definition -> FactoryBlockPattern.start((MultiblockMachineDefinition)definition).aisle(new String[]{"CCCC", "CHHC", "CCCC"}).aisle(new String[]{"CHHC", "RGGR", "CHHC"}).aisle(new String[]{"CCCC", "CSHC", "CCCC"}).where('S', Predicates.controller((MachineDefinition)definition)).where('G', Predicates.blocks((Block[])new Block[]{(Block)gear.get()})).where('C', Predicates.blocks((Block[])new Block[]{(Block)casing.get()})).where('R', GTOPredicates.RotorBlock(tier).setExactLimit(1).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.OUTPUT_ENERGY})).setExactLimit(1)).where('H', Predicates.blocks((Block[])new Block[]{(Block)casing.get()}).or(Predicates.autoAbilities((GTRecipeType[])definition.getRecipeTypes(), (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)true).or(Predicates.autoAbilities((boolean)true, (boolean)true, (boolean)false)))).build()).workableCasingRenderer(casingTexture, overlayModel);
        if (recipeType == GTORecipeTypes.STEAM_TURBINE_FUELS) {
            builder.addSubPattern(definition -> FactoryBlockPattern.start((MultiblockMachineDefinition)definition).aisle(new String[]{"AAAAAAA", "A   ABA", "A   ABA", "AAAAAAA"}).aisle(new String[]{"    CCD", "    CCD", "    CCD", "A   ABA"}).aisle(new String[]{"    CCD", "    FFF", "    CCD", "A   ABA"}).aisle(new String[]{"    CCD", " E  CCD", "    CCD", "A   ABA"}).aisle(new String[]{"AAAAAAA", "A   ABA", "A   ABA", "AAAAAAA"}).where('A', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_STEEL_SOLID.get()})).where('B', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_STEEL_PIPE.get()})).where('C', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_STEEL_TURBINE.get()})).where('D', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_STEEL_TURBINE.get()}).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.OUTPUT_ENERGY}).setMaxGlobalLimited(3))).where('E', Predicates.controller((MachineDefinition)definition)).where('F', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.StainlessSteel)})).where(' ', Predicates.any()).build());
        } else if (recipeType == GTORecipeTypes.GAS_TURBINE_FUELS) {
            builder.addSubPattern(definition -> FactoryBlockPattern.start((MultiblockMachineDefinition)definition).aisle(new String[]{"AAAAAAA", "A   ABA", "A   ABA", "AAAAAAA"}).aisle(new String[]{"    CCD", "    CCD", "    CCD", "A   ABA"}).aisle(new String[]{"    CCD", "    FFF", "    CCD", "A   ABA"}).aisle(new String[]{"    CCD", " E  CCD", "    CCD", "A   ABA"}).aisle(new String[]{"AAAAAAA", "A   ABA", "A   ABA", "AAAAAAA"}).where('A', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_STAINLESS_CLEAN.get()})).where('B', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_ENGINE_INTAKE.get()})).where('C', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_STAINLESS_TURBINE.get()})).where('D', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_STAINLESS_TURBINE.get()}).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.OUTPUT_ENERGY}).setMaxGlobalLimited(3))).where('E', Predicates.controller((MachineDefinition)definition)).where('F', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.BlackSteel)})).where(' ', Predicates.any()).build());
        } else if (recipeType == GTORecipeTypes.ROCKET_ENGINE_FUELS) {
            builder.addSubPattern(definition -> FactoryBlockPattern.start((MultiblockMachineDefinition)definition).aisle(new String[]{"AAAAAAA", "A   ABA", "A   ABA", "AAAAAAA"}).aisle(new String[]{"    CCD", "    CCD", "    CCD", "A   ABA"}).aisle(new String[]{"    CCD", "    FFF", "    CCD", "A   ABA"}).aisle(new String[]{"    CCD", " E  CCD", "    CCD", "A   ABA"}).aisle(new String[]{"AAAAAAA", "A   ABA", "A   ABA", "AAAAAAA"}).where('A', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_TITANIUM_STABLE.get()})).where('B', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_ENGINE_INTAKE.get()})).where('C', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_TITANIUM_TURBINE.get()})).where('D', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_TITANIUM_TURBINE.get()}).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.OUTPUT_ENERGY}).setMaxGlobalLimited(3))).where('E', Predicates.controller((MachineDefinition)definition)).where('F', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.BlueSteel)})).where(' ', Predicates.any()).build());
        } else if (recipeType == GTORecipeTypes.SUPERCRITICAL_STEAM_TURBINE_FUELS) {
            builder.addSubPattern(definition -> FactoryBlockPattern.start((MultiblockMachineDefinition)definition).aisle(new String[]{"AAAAAAA", "A   ABA", "A   ABA", "AAAAAAA"}).aisle(new String[]{"    CCD", "    CCD", "    CCD", "A   ABA"}).aisle(new String[]{"    CCD", "    FFF", "    CCD", "A   ABA"}).aisle(new String[]{"    CCD", " E  CCD", "    CCD", "A   ABA"}).aisle(new String[]{"AAAAAAA", "A   ABA", "A   ABA", "AAAAAAA"}).where('A', Predicates.blocks((Block[])new Block[]{(Block)GCYMBlocks.CASING_HIGH_TEMPERATURE_SMELTING.get()})).where('B', Predicates.blocks((Block[])new Block[]{(Block)GCYMBlocks.ELECTROLYTIC_CELL.get()})).where('C', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.SUPERCRITICAL_TURBINE_CASING.get()})).where('D', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.SUPERCRITICAL_TURBINE_CASING.get()}).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.OUTPUT_ENERGY}).setMaxGlobalLimited(3))).where('E', Predicates.controller((MachineDefinition)definition)).where('F', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.TungstenSteel)})).where(' ', Predicates.any()).build());
        }
        return builder.register();
    }

    public static MultiblockMachineDefinition registerMegaTurbine(String name, String cn, int tier, boolean special, GTRecipeType recipeType, Supplier<Block> casing, Supplier<Block> gear, ResourceLocation baseCasing, ResourceLocation overlayModel, Function<MultiblockMachineDefinition, BlockPattern> subPattern) {
        return MachineRegisterUtils.multiblock(name, cn, holder -> new TurbineMachine.MegaTurbine((MetaMachineBlockEntity)holder, tier, special)).nonYAxisRotation().recipeTypes(new GTRecipeType[]{recipeType}).generator().tooltips(((ComponentListSupplier)GTOMachineTooltips.INSTANCE.getMegaTurbineGenerateTooltips().invoke((Object)(GTValues.V[tier] * (long)(special ? 12 : 8)), (Object)tier)).getSupplier()).tooltips(GTOMachineTooltips.INSTANCE.getTurbineHighSpeedTooltips().getSupplier()).moduleTooltips(new PartAbility[0]).addTooltipsFromClass(TurbineMachine.class).block(casing).pattern(definition -> FactoryBlockPattern.start((MultiblockMachineDefinition)definition).aisle(new String[]{"   AAAAA   ", "  A  A  A  ", " AA  A  AA ", "A  A A A  A", "A   A A   A", "AAAA A AAAA", "A   A A   A", "A  A A A  A", " AA  A  AA ", "  A  A  A  ", "   AAAAA   "}).aisle(new String[]{"   ABABA   ", "  BBBBBBB  ", " BBBBBBBBB ", "ABBBBBBBBBA", "BBBBBBBBBBB", "ABBBBBBBBBA", "BBBBBBBBBBB", "ABBBBBBBBBA", " BBBBBBBBB ", "  BBBBBBB  ", "   ABABA   "}).aisle(new String[]{"   BBBBB   ", "  BBEEEBB  ", " B   E   B ", "BB   E   BB", "BE   E   EB", "BEEEEIEEEEB", "BE   E   EB", "BB   E   BB", " B   E   B ", "  BBEEEBB  ", "   BBBBB   "}).aisle(new String[]{"   BBBBB   ", "  BB   BB  ", " B       B ", "BB       BB", "B         B", "B         B", "B         B", "BB       BB", " B       B ", "  BB   BB  ", "   BBBBB   "}).aisle(new String[]{"   BBBBB   ", "  BBEEEBB  ", " B   E   B ", "BB   E   BB", "BE   E   EB", "BEEEEIEEEEB", "BE   E   EB", "BB   E   BB", " B   E   B ", "  BBEEEBB  ", "   BBBBB   "}).aisle(new String[]{"   BBBBB   ", "  BBEEEBB  ", " B   E   B ", "BB   E   BB", "BE   E   EB", "BEEEEIEEEEB", "BE   E   EB", "BB   E   BB", " B   E   B ", "  BBEEEBB  ", "   BBBBB   "}).aisle(new String[]{"   BBBBB   ", "  BB   BB  ", " B       B ", "BB       BB", "B         B", "B         B", "B         B", "BB       BB", " B       B ", "  BB   BB  ", "   BBBBB   "}).aisle(new String[]{"   BBBBB   ", "  BBEEEBB  ", " B   E   B ", "BB   E   BB", "BE   E   EB", "BEEEEIEEEEB", "BE   E   EB", "BB   E   BB", " B   E   B ", "  BBEEEBB  ", "   BBBBB   "}).aisle(new String[]{"   ABABA   ", "  BBBBBBB  ", " BBBBBBBBB ", "ABBBBBBBBBA", "BBBBBBBBBBB", "ABBBBEBBBBA", "BBBBBBBBBBB", "ABBBBBBBBBA", " BBBBBBBBB ", "  BBBBBBB  ", "   ABABA   "}).aisle(new String[]{"   AAAAA   ", "  A  A  A  ", " AA  A  AA ", "A  A A A  A", "A   AAA   A", "AAAAAEAAAAA", "A   AAA   A", "A  A A A  A", " AA  A  AA ", "  A  A  A  ", "   AAAAA   "}).aisle(new String[]{"           ", "           ", "           ", "           ", "    AAA    ", "    AEA    ", "    AAA    ", "           ", "           ", "           ", "           "}).aisle(new String[]{"           ", "           ", "           ", "           ", "    AAA    ", "    AEA    ", "    AAA    ", "           ", "           ", "           ", "           "}).aisle(new String[]{"   AAAAA   ", "  A  A  A  ", " AA  A  AA ", "A  A A A  A", "A   A A   A", "AAAA A AAAA", "A   A A   A", "A  A A A  A", " AA  A  AA ", "  A  A  A  ", "   AAAAA   "}).aisle(new String[]{"   ABABA   ", "  BBBBBBB  ", " BBBBBBBBB ", "ABBBBBBBBBA", "BBBBBBBBBBB", "ABBBBBBBBBA", "BBBBBBBBBBB", "ABBBBBBBBBA", " BBBBBBBBB ", "  BBBBBBB  ", "   ABABA   "}).aisle(new String[]{"   BBBBB   ", "  BBEEEBB  ", " B   E   B ", "BB   E   BB", "BE   E   EB", "BEEEEIEEEEB", "BE   E   EB", "BB   E   BB", " B   E   B ", "  BBEEEBB  ", "   BBBBB   "}).aisle(new String[]{"   BBBBB   ", "  BB   BB  ", " B       B ", "BB       BB", "B         B", "B         B", "B         B", "BB       BB", " B       B ", "  BB   BB  ", "   BBBBB   "}).aisle(new String[]{"   BBBBB   ", "  BBEEEBB  ", " B   E   B ", "BB   E   BB", "BE   E   EB", "BEEEEIEEEEB", "BE   E   EB", "BB   E   BB", " B   E   B ", "  BBEEEBB  ", "   BBBBB   "}).aisle(new String[]{"   BBBBB   ", "  BBEEEBB  ", " B   E   B ", "BB   E   BB", "BE   E   EB", "BEEEEIEEEEB", "BE   E   EB", "BB   E   BB", " B   E   B ", "  BBEEEBB  ", "   BBBBB   "}).aisle(new String[]{"   BBBBB   ", "  BB   BB  ", " B       B ", "BB       BB", "B         B", "B         B", "B         B", "BB       BB", " B       B ", "  BB   BB  ", "   BBBBB   "}).aisle(new String[]{"   BBBBB   ", "  BBEEEBB  ", " B   E   B ", "BB   E   BB", "BE   E   EB", "BEEEEIEEEEB", "BE   E   EB", "BB   E   BB", " B   E   B ", "  BBEEEBB  ", "   BBBBB   "}).aisle(new String[]{"   ABABA   ", "  BBBBBBB  ", " BBBBBBBBB ", "ABBBBBBBBBA", "BBBBBBBBBBB", "ABBBBEBBBBA", "BBBBBBBBBBB", "ABBBBBBBBBA", " BBBBBBBBB ", "  BBBBBBB  ", "   ABABA   "}).aisle(new String[]{"   AAAAA   ", "  A  A  A  ", " AA  A  AA ", "A  A A A  A", "A   AAA   A", "AAAAAEAAAAA", "A   AAA   A", "A  A A A  A", " AA  A  AA ", "  A  A  A  ", "   AAAAA   "}).aisle(new String[]{"           ", "           ", "           ", "           ", "    AAA    ", "    AEA    ", "    AAA    ", "           ", "           ", "           ", "           "}).aisle(new String[]{"           ", "           ", "           ", "           ", "    AAA    ", "    AEA    ", "    AAA    ", "           ", "           ", "           ", "           "}).aisle(new String[]{"           ", "           ", "    AAA    ", "   A A A   ", "  A AAA A  ", "  AAAEAAA  ", "  A AAA A  ", "   A A A   ", "    AAA    ", "           ", "           "}).aisle(new String[]{"           ", "           ", "    ABA    ", "   BBBBB   ", "  ABBBBBA  ", "  BBBEBBB  ", "  ABBBBBA  ", "   BBBBB   ", "    ABA    ", "           ", "           "}).aisle(new String[]{"           ", "           ", "    BBB    ", "   B   B   ", "  B     B  ", "  B  E  B  ", "  B     B  ", "   B   B   ", "    BBB    ", "           ", "           "}).aisle(new String[]{"           ", "           ", "    BBB    ", "   BGGGB   ", "  BGAEAGB  ", "  HGEIEGH  ", "  BGAEAGB  ", "   BGGGB   ", "    BHB    ", "           ", "           "}).aisle(new String[]{"           ", "           ", "    BBB    ", "   B   B   ", "  H     H  ", "  H     H  ", "  H     H  ", "   B   B   ", "    HHH    ", "           ", "           "}).aisle(new String[]{"           ", "           ", "    BBB    ", "   BGGGB   ", "  HGAEAGH  ", "  HGEIEGH  ", "  HGAEAGH  ", "   BGGGB   ", "    HHH    ", "           ", "           "}).aisle(new String[]{"           ", "           ", "    BBB    ", "   BGGGB   ", "  HGAEAGH  ", "  HGEIEGH  ", "  HGAEAGH  ", "   BGGGB   ", "    HHH    ", "           ", "           "}).aisle(new String[]{"           ", "           ", "    BBB    ", "   B   B   ", "  H     H  ", "  H     H  ", "  H     H  ", "   B   B   ", "    HHH    ", "           ", "           "}).aisle(new String[]{"           ", "           ", "    BBB    ", "   BGGGB   ", "  BGAEAGB  ", "  HGEIEGH  ", "  BGAEAGB  ", "   BGGGB   ", "    BHB    ", "           ", "           "}).aisle(new String[]{"           ", "           ", "    BBB    ", "   B   B   ", "  B     B  ", "  B  E  B  ", "  B     B  ", "   B   B   ", "    BBB    ", "           ", "           "}).aisle(new String[]{"           ", "           ", "    ABA    ", "   BBBBB   ", "  ABBBBBA  ", "  BBBEBBB  ", "  ABBBBBA  ", "   BBBBB   ", "    ABA    ", "           ", "           "}).aisle(new String[]{"           ", "           ", "    AAA    ", "   A A A   ", "  A AAA A  ", "  AAAEAAA  ", "  A AAA A  ", "   A A A   ", "    AAA    ", "           ", "           "}).aisle(new String[]{"           ", "           ", "           ", "           ", "     A     ", "    AEA    ", "     A     ", "           ", "           ", "           ", "           "}).aisle(new String[]{"           ", "           ", "           ", "           ", "     A     ", "    AEA    ", "     A     ", "           ", "           ", "           ", "           "}).aisle(new String[]{"           ", "           ", "   AAAAA   ", "   ABBBA   ", "   BBBBB   ", "   BBEBB   ", "   BBBBB   ", "   ABBBA   ", "   AAAAA   ", "           ", "           "}).aisle(new String[]{"           ", "           ", "   ABBBA   ", "   B   B   ", "   C   C   ", "   C E C   ", "   C   C   ", "   B   B   ", "   ABBBA   ", "           ", "           "}).aisle(new String[]{"           ", "           ", "   ABBBA   ", "   B   B   ", "   C   C   ", "   C E C   ", "   C   C   ", "   B   B   ", "   ABFBA   ", "           ", "           "}).aisle(new String[]{"           ", "           ", "   ABBBA   ", "   B   B   ", "   C   C   ", "   C E C   ", "   C   C   ", "   B   B   ", "   ABBBA   ", "           ", "           "}).aisle(new String[]{"           ", "           ", "   AAAAA   ", "   ABBBA   ", "   BCCCB   ", "   BCDCB   ", "   BCCCB   ", "   ABBBA   ", "   AAAAA   ", "           ", "           "}).where('A', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_STAINLESS_CLEAN.get()})).where('B', Predicates.blocks((Block[])new Block[]{(Block)casing.get()})).where('C', Predicates.blocks((Block[])new Block[]{(Block)casing.get()}).or(Predicates.blocks((MetaMachineBlock[])new MetaMachineBlock[]{GTMachines.CONTROL_HATCH.get()}).setMaxGlobalLimited(1).setPreviewCount(0)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.MAINTENANCE}).setExactLimit(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.IMPORT_FLUIDS}).setMaxGlobalLimited(8)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.EXPORT_FLUIDS}).setMaxGlobalLimited(2)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.OUTPUT_ENERGY}).setMaxGlobalLimited(4)).or(Predicates.blocks((MetaMachineBlock[])new MetaMachineBlock[]{GTOMachines.ROTOR_HATCH.get()}).setMaxGlobalLimited(1))).where('D', Predicates.controller((MachineDefinition)definition)).where('E', Predicates.blocks((Block[])new Block[]{(Block)gear.get()})).where('F', Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.MUFFLER})).where('G', Predicates.heatingCoils()).where('H', GTOPredicates.glass()).where('I', GTOPredicates.RotorBlock(tier)).where(' ', Predicates.any()).build()).addSubPattern(subPattern).workableCasingRenderer(baseCasing, overlayModel).register();
    }

    public static GTOMachineBuilder manaMachine(String name, String cn, Function<MetaMachineBlockEntity, MetaMachine> metaMachine) {
        BlockRegisterUtils.addLang((String)name, (String)cn);
        return GTORegistration.GTO.machine(name, metaMachine, ManaMachineBlockEntity::createBlockEntity);
    }

    public static MachineDefinition[] registerSimpleManaMachines(String name, String cn, GTRecipeType recipeType, Int2IntFunction tankScalingFunction, ResourceLocation workableModel, int ... tiers) {
        return MachineRegisterUtils.registerTieredManaMachines(name, tier -> "%s%s".formatted(GTOValues.MANACN[tier], cn), (holder, tier) -> new SimpleWorkManaMachine((MetaMachineBlockEntity)holder, (int)tier, tankScalingFunction, new Object[0]), (tier, builder) -> {
            builder.noRecipeModifier();
            return builder.langValue("%s %s".formatted(GTOValues.MANAN[tier], FormattingUtil.toEnglishName((Object)name))).editableUI((EditableMachineUI)SimpleNoEnergyMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id((String)name), recipeType)).nonYAxisRotation().recipeType(recipeType).tooltips(new Component[]{Component.m_237115_((String)"gtocore.machine.mana_eu").m_130940_(ChatFormatting.GREEN)}).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.perfect_oc").m_130940_(ChatFormatting.YELLOW)}).tooltips(new Component[]{Component.m_237110_((String)"gtocore.machine.mana_input", (Object[])new Object[]{Component.m_237113_((String)(FormattingUtil.formatNumbers((int)GTOValues.MANA[tier]) + " /t")).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.AQUA)}).workableManaTieredHullRenderer(tier.intValue(), workableModel).tooltips(MachineRegisterUtils.workableNoEnergy(recipeType, ((Integer)tankScalingFunction.apply(tier)).intValue())).register();
        }, tiers);
    }

    public static MachineDefinition[] registerTieredManaMachines(String name, Function<Integer, String> cn, BiFunction<MetaMachineBlockEntity, Integer, MetaMachine> factory, BiFunction<Integer, GTOMachineBuilder, MachineDefinition> builder, int ... tiers) {
        MachineDefinition[] definitions = new MachineDefinition[GTValues.TIER_COUNT];
        for (int tier : tiers) {
            GTOMachineBuilder register = MachineRegisterUtils.manaMachine(GTValues.VN[tier].toLowerCase(Locale.ROOT) + "_" + name, cn.apply(tier), holder -> (MetaMachine)factory.apply((MetaMachineBlockEntity)holder, tier)).tier(tier);
            definitions[tier] = builder.apply(tier, register);
        }
        return definitions;
    }

    public static MachineDefinition[] registerTieredGTMMachines(String name, BiFunction<MetaMachineBlockEntity, Integer, MetaMachine> factory, BiFunction<Integer, GTOMachineBuilder, MachineDefinition> builder, int ... tiers) {
        MachineDefinition[] definitions = new MachineDefinition[GTValues.TIER_COUNT];
        for (int tier : tiers) {
            GTOMachineBuilder register = GTORegistration.GTM.machine(GTValues.VN[tier].toLowerCase(Locale.ROOT) + "_" + name, holder -> (MetaMachine)factory.apply((MetaMachineBlockEntity)holder, tier)).tier(tier);
            definitions[tier] = builder.apply(tier, register);
        }
        return definitions;
    }

    public static GTOMachineBuilder blockEntityMachine(String name, String cn, Function<MetaMachineBlockEntity, MetaMachine> metaMachine, TriFunction<BlockEntityType<?>, BlockPos, BlockState, MetaMachineBlockEntity> blockEntityFactory) {
        BlockRegisterUtils.addLang((String)name, (String)cn);
        return GTORegistration.GTO.machine(name, metaMachine, blockEntityFactory);
    }

    private static /* synthetic */ MachineDefinition lambda$registerWirelessEnergyHatch$4(int amperage, IO io, PartAbility ability, String iao, String id, String finalRender, Integer tier, GTOMachineBuilder builder) {
        return builder.langValue(GTOValues.VNFR[tier] + " " + (String)(amperage > 2 ? FormattingUtil.formatNumbers((int)amperage) + (amperage > 64 ? "\u00a7eA\u00a7r " : "A ") : "") + "Wireless " + (io == IO.IN ? "Energy" : "Dynamo") + " Hatch").allRotation().abilities(new PartAbility[]{ability}).tooltips(new Component[]{Component.m_237110_((String)("gtceu.universal.tooltip.voltage_" + iao), (Object[])new Object[]{FormattingUtil.formatNumbers((long)GTValues.V[tier]), GTValues.VNF[tier]}), Component.m_237110_((String)("gtceu.universal.tooltip.amperage_" + iao), (Object[])new Object[]{amperage}), Component.m_237110_((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers((long)WirelessEnergyHatchPartMachine.getHatchEnergyCapacity((int)tier, (int)amperage))}), Component.m_237115_((String)("gtmthings.machine.wireless_energy_hatch." + id + ".tooltip"))}).renderer(() -> new OverlayTieredMachineRenderer(tier.intValue(), GTMThings.id((String)("block/machine/part/" + finalRender)))).register();
    }
}

