/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.gtm.registry;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.registry.MaterialRegistry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.registry.registrate.GTRegistrate;
import com.gregtechceu.gtceu.common.data.GTMaterialBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.api.data.tag.GTOTagPrefix;
import com.gtocore.common.data.GTOCreativeModeTabs;
import com.gtocore.common.data.GTOMaterials;
import com.gtolib.api.registries.GTORegistration;
import com.gtolib.utils.register.BlockRegisterUtils;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.Set;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GTMaterialBlocks.class})
public abstract class GTMaterialBlocksMixin {
    @Shadow(remap=false)
    static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<? extends Block>> MATERIAL_BLOCKS_BUILDER;
    @Unique
    private static ImmutableMap<Material, Set<TagPrefix>> ORE_MAP;
    @Unique
    private static final Set<TagPrefix> gtolib$DEEPSLATE;

    @Shadow(remap=false)
    private static void registerMaterialBlock(TagPrefix tagPrefix, Material material, GTRegistrate registrate) {
    }

    @Overwrite(remap=false)
    public static void generateMaterialBlocks() {
        GTORegistration.GTO.creativeModeTab(() -> GTOCreativeModeTabs.GTO_MATERIAL_BLOCK);
        for (TagPrefix tagPrefix : TagPrefix.values()) {
            if (!tagPrefix.doGenerateBlock() || TagPrefix.ORES.containsKey(tagPrefix)) continue;
            for (MaterialRegistry registry : GTCEuAPI.materialManager.getRegistries()) {
                Object registrate = tagPrefix instanceof GTOTagPrefix ? GTORegistration.GTO : registry.getRegistrate();
                for (Material material : registry.getAllMaterials()) {
                    if (!tagPrefix.doGenerateBlock(material)) continue;
                    GTMaterialBlocksMixin.registerMaterialBlock(tagPrefix, material, (GTRegistrate)registrate);
                }
            }
        }
    }

    @Overwrite(remap=false)
    private static void registerOreBlock(Material material, GTRegistrate registrate) {
        BlockRegisterUtils.registerOreBlock((Material)material, (GTRegistrate)registrate, ORE_MAP, gtolib$DEEPSLATE, MATERIAL_BLOCKS_BUILDER);
    }

    @Inject(method={"generateOreBlocks"}, at={@At(value="TAIL")}, remap=false)
    private static void generateOreBlocks(CallbackInfo ci) {
        ORE_MAP = null;
    }

    static {
        gtolib$DEEPSLATE = Set.of(TagPrefix.oreDeepslate, GTOTagPrefix.SCULK_STONE, GTOTagPrefix.GLOOMSLATE);
        ImmutableMap.Builder OREBuilder = ImmutableMap.builder();
        OREBuilder.put((Object)GTMaterials.Electrotine, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.MARS_STONE, GTOTagPrefix.MERCURY_STONE));
        OREBuilder.put((Object)GTMaterials.Garnierite, Set.of(GTOTagPrefix.MERCURY_STONE, GTOTagPrefix.GANYMEDE_STONE));
        OREBuilder.put((Object)GTMaterials.Oilsands, Set.of(GTOTagPrefix.GLACIO_STONE));
        OREBuilder.put((Object)GTMaterials.Opal, Set.of(GTOTagPrefix.MARS_STONE, GTOTagPrefix.PLUTO_STONE));
        OREBuilder.put((Object)GTMaterials.Borax, Set.of(GTOTagPrefix.CERES_STONE, GTOTagPrefix.VENUS_STONE, GTOTagPrefix.MARS_STONE));
        OREBuilder.put((Object)GTMaterials.Pyrite, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.IO_STONE, GTOTagPrefix.ENCELADUS_STONE, GTOTagPrefix.MARS_STONE, GTOTagPrefix.VENUS_STONE));
        OREBuilder.put((Object)GTOMaterials.Ostrum, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.CERES_STONE));
        OREBuilder.put((Object)GTMaterials.CertusQuartz, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.PLUTO_STONE));
        OREBuilder.put((Object)GTMaterials.GraniticMineralSand, Set.of(GTOTagPrefix.IO_STONE, GTOTagPrefix.MARS_STONE));
        OREBuilder.put((Object)GTMaterials.Amethyst, Set.of(GTOTagPrefix.MARS_STONE, GTOTagPrefix.PLUTO_STONE));
        OREBuilder.put((Object)GTMaterials.Alunite, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.MARS_STONE, GTOTagPrefix.MERCURY_STONE));
        OREBuilder.put((Object)GTOMaterials.Calorite, Set.of(GTOTagPrefix.MERCURY_STONE));
        OREBuilder.put((Object)GTMaterials.Sapphire, Set.of(GTOTagPrefix.TITAN_STONE));
        OREBuilder.put((Object)GTMaterials.VanadiumMagnetite, Set.of(GTOTagPrefix.MARS_STONE, GTOTagPrefix.TITAN_STONE, GTOTagPrefix.VENUS_STONE, GTOTagPrefix.MOON_STONE));
        OREBuilder.put((Object)GTMaterials.Bornite, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.ENCELADUS_STONE, GTOTagPrefix.MARS_STONE, GTOTagPrefix.MERCURY_STONE));
        OREBuilder.put((Object)GTMaterials.Cobaltite, Set.of(GTOTagPrefix.MERCURY_STONE, GTOTagPrefix.GANYMEDE_STONE));
        OREBuilder.put((Object)GTMaterials.Cooperite, Set.of(GTOTagPrefix.IO_STONE, GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.ENCELADUS_STONE, GTOTagPrefix.MARS_STONE, GTOTagPrefix.MERCURY_STONE));
        OREBuilder.put((Object)GTMaterials.Magnesite, Set.of(GTOTagPrefix.TITAN_STONE, GTOTagPrefix.VENUS_STONE));
        OREBuilder.put((Object)GTMaterials.Gold, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.MARS_STONE, GTOTagPrefix.CERES_STONE, GTOTagPrefix.VENUS_STONE, GTOTagPrefix.MOON_STONE));
        OREBuilder.put((Object)GTMaterials.Titanium, Set.of(GTOTagPrefix.ENCELADUS_STONE));
        OREBuilder.put((Object)GTMaterials.Malachite, Set.of(GTOTagPrefix.IO_STONE, GTOTagPrefix.MARS_STONE, GTOTagPrefix.CERES_STONE, GTOTagPrefix.TITAN_STONE));
        OREBuilder.put((Object)GTMaterials.Cobalt, Set.of(GTOTagPrefix.MERCURY_STONE));
        OREBuilder.put((Object)GTMaterials.Redstone, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.ENCELADUS_STONE));
        OREBuilder.put((Object)GTMaterials.BlueTopaz, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.ENCELADUS_STONE, GTOTagPrefix.MERCURY_STONE));
        OREBuilder.put((Object)GTMaterials.Spessartine, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.CERES_STONE, GTOTagPrefix.MERCURY_STONE));
        OREBuilder.put((Object)GTMaterials.Uraninite, Set.of(GTOTagPrefix.PLUTO_STONE, GTOTagPrefix.TITAN_STONE, GTOTagPrefix.MOON_STONE));
        OREBuilder.put((Object)GTMaterials.Pyrochlore, Set.of(GTOTagPrefix.MARS_STONE, GTOTagPrefix.MERCURY_STONE, GTOTagPrefix.PLUTO_STONE, GTOTagPrefix.TITAN_STONE));
        OREBuilder.put((Object)GTMaterials.Goethite, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.IO_STONE, GTOTagPrefix.MARS_STONE, GTOTagPrefix.CERES_STONE, GTOTagPrefix.TITAN_STONE, GTOTagPrefix.VENUS_STONE));
        OREBuilder.put((Object)GTMaterials.Trona, Set.of(GTOTagPrefix.IO_STONE, GTOTagPrefix.GLACIO_STONE));
        OREBuilder.put((Object)GTMaterials.Saltpeter, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.MARS_STONE, GTOTagPrefix.MERCURY_STONE));
        OREBuilder.put((Object)GTMaterials.Spodumene, Set.of(GTOTagPrefix.GLACIO_STONE));
        OREBuilder.put((Object)GTMaterials.Mica, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.MARS_STONE, GTOTagPrefix.PLUTO_STONE, GTOTagPrefix.GANYMEDE_STONE));
        OREBuilder.put((Object)GTMaterials.GarnetYellow, Set.of(GTOTagPrefix.MARS_STONE, GTOTagPrefix.PLUTO_STONE));
        OREBuilder.put((Object)GTMaterials.Beryllium, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.GANYMEDE_STONE));
        OREBuilder.put((Object)GTMaterials.Sulfur, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.IO_STONE, GTOTagPrefix.VENUS_STONE));
        OREBuilder.put((Object)GTMaterials.Tungsten, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.PLUTO_STONE));
        OREBuilder.put((Object)GTMaterials.Gypsum, Set.of(GTOTagPrefix.IO_STONE, GTOTagPrefix.MARS_STONE));
        OREBuilder.put((Object)GTMaterials.GarnetSand, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.TITAN_STONE, GTOTagPrefix.MOON_STONE));
        OREBuilder.put((Object)GTMaterials.NetherQuartz, Set.of(TagPrefix.oreNetherrack));
        OREBuilder.put((Object)GTMaterials.Cassiterite, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.CERES_STONE, GTOTagPrefix.MERCURY_STONE, GTOTagPrefix.GANYMEDE_STONE, GTOTagPrefix.MOON_STONE));
        OREBuilder.put((Object)GTMaterials.GlauconiteSand, Set.of(GTOTagPrefix.IO_STONE, GTOTagPrefix.CERES_STONE, GTOTagPrefix.VENUS_STONE, GTOTagPrefix.GANYMEDE_STONE, GTOTagPrefix.MOON_STONE));
        OREBuilder.put((Object)GTMaterials.Pyrolusite, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.CERES_STONE, GTOTagPrefix.MERCURY_STONE, GTOTagPrefix.PLUTO_STONE));
        OREBuilder.put((Object)GTMaterials.Nickel, Set.of(GTOTagPrefix.MERCURY_STONE, GTOTagPrefix.GANYMEDE_STONE));
        OREBuilder.put((Object)GTMaterials.Almandine, Set.of(GTOTagPrefix.TITAN_STONE));
        OREBuilder.put((Object)GTMaterials.Calcite, Set.of(GTOTagPrefix.GLACIO_STONE));
        OREBuilder.put((Object)GTMaterials.Soapstone, Set.of(GTOTagPrefix.CERES_STONE, GTOTagPrefix.GANYMEDE_STONE, GTOTagPrefix.MOON_STONE));
        OREBuilder.put((Object)GTMaterials.Sodalite, Set.of(GTOTagPrefix.GLACIO_STONE));
        OREBuilder.put((Object)GTMaterials.Zeolite, Set.of(GTOTagPrefix.CERES_STONE, GTOTagPrefix.MERCURY_STONE, GTOTagPrefix.GANYMEDE_STONE));
        OREBuilder.put((Object)GTMaterials.Lithium, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.MARS_STONE, GTOTagPrefix.CERES_STONE));
        OREBuilder.put((Object)GTMaterials.Silver, Set.of(GTOTagPrefix.ENCELADUS_STONE, GTOTagPrefix.PLUTO_STONE, GTOTagPrefix.VENUS_STONE));
        OREBuilder.put((Object)GTMaterials.Sphalerite, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.IO_STONE, GTOTagPrefix.VENUS_STONE));
        OREBuilder.put((Object)GTMaterials.Ruby, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.ENCELADUS_STONE));
        OREBuilder.put((Object)GTMaterials.Naquadah, Set.of(GTOTagPrefix.IO_STONE, GTOTagPrefix.PLUTO_STONE));
        OREBuilder.put((Object)GTMaterials.Bentonite, Set.of(GTOTagPrefix.IO_STONE, GTOTagPrefix.CERES_STONE, GTOTagPrefix.VENUS_STONE));
        OREBuilder.put((Object)GTMaterials.Palladium, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.ENCELADUS_STONE, GTOTagPrefix.MARS_STONE, GTOTagPrefix.MERCURY_STONE));
        OREBuilder.put((Object)GTMaterials.Apatite, Set.of(GTOTagPrefix.MARS_STONE, GTOTagPrefix.PLUTO_STONE, GTOTagPrefix.TITAN_STONE));
        OREBuilder.put((Object)GTMaterials.Neodymium, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.CERES_STONE, GTOTagPrefix.MOON_STONE));
        OREBuilder.put((Object)GTMaterials.Topaz, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.ENCELADUS_STONE, GTOTagPrefix.MERCURY_STONE));
        OREBuilder.put((Object)GTMaterials.Pollucite, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.MARS_STONE, GTOTagPrefix.PLUTO_STONE, GTOTagPrefix.GANYMEDE_STONE));
        OREBuilder.put((Object)GTMaterials.CassiteriteSand, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.TITAN_STONE, GTOTagPrefix.MOON_STONE));
        OREBuilder.put((Object)GTMaterials.Talc, Set.of(GTOTagPrefix.CERES_STONE, GTOTagPrefix.GANYMEDE_STONE, GTOTagPrefix.MOON_STONE));
        OREBuilder.put((Object)GTMaterials.Lepidolite, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.CERES_STONE, GTOTagPrefix.VENUS_STONE, GTOTagPrefix.MARS_STONE));
        OREBuilder.put((Object)GTMaterials.Coal, Set.of(GTOTagPrefix.IO_STONE, GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.VENUS_STONE));
        OREBuilder.put((Object)GTMaterials.Stibnite, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.MARS_STONE, GTOTagPrefix.TITAN_STONE));
        OREBuilder.put((Object)GTMaterials.BasalticMineralSand, Set.of(GTOTagPrefix.IO_STONE, GTOTagPrefix.MARS_STONE));
        OREBuilder.put((Object)GTMaterials.Barite, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.PLUTO_STONE));
        OREBuilder.put((Object)GTMaterials.Salt, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.CERES_STONE, GTOTagPrefix.VENUS_STONE, GTOTagPrefix.MARS_STONE));
        OREBuilder.put((Object)GTMaterials.Magnetite, Set.of(GTOTagPrefix.IO_STONE, GTOTagPrefix.MARS_STONE, GTOTagPrefix.CERES_STONE, GTOTagPrefix.TITAN_STONE, GTOTagPrefix.VENUS_STONE, GTOTagPrefix.MOON_STONE));
        OREBuilder.put((Object)GTMaterials.Copper, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.ENCELADUS_STONE, GTOTagPrefix.MARS_STONE, GTOTagPrefix.TITAN_STONE));
        OREBuilder.put((Object)GTMaterials.Asbestos, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.TITAN_STONE, GTOTagPrefix.MOON_STONE));
        OREBuilder.put((Object)GTMaterials.Scheelite, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.MARS_STONE, GTOTagPrefix.CERES_STONE));
        OREBuilder.put((Object)GTMaterials.Tin, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.GANYMEDE_STONE, GTOTagPrefix.MOON_STONE));
        OREBuilder.put((Object)GTMaterials.GarnetRed, Set.of(GTOTagPrefix.MARS_STONE, GTOTagPrefix.PLUTO_STONE));
        OREBuilder.put((Object)GTMaterials.Realgar, Set.of(GTOTagPrefix.CERES_STONE, GTOTagPrefix.MERCURY_STONE, GTOTagPrefix.GANYMEDE_STONE));
        OREBuilder.put((Object)GTMaterials.Iron, Set.of(GTOTagPrefix.ENCELADUS_STONE, GTOTagPrefix.MARS_STONE));
        OREBuilder.put((Object)GTOMaterials.Celestine, Set.of(GTOTagPrefix.IO_STONE, GTOTagPrefix.GLACIO_STONE));
        OREBuilder.put((Object)GTMaterials.Chalcocite, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.ENCELADUS_STONE, GTOTagPrefix.MERCURY_STONE));
        OREBuilder.put((Object)GTMaterials.Galena, Set.of(GTOTagPrefix.ENCELADUS_STONE, GTOTagPrefix.PLUTO_STONE, GTOTagPrefix.VENUS_STONE));
        OREBuilder.put((Object)GTMaterials.Chromite, Set.of(GTOTagPrefix.TITAN_STONE, GTOTagPrefix.VENUS_STONE));
        OREBuilder.put((Object)GTMaterials.Tetrahedrite, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.MARS_STONE, GTOTagPrefix.TITAN_STONE));
        OREBuilder.put((Object)GTMaterials.Molybdenite, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.IO_STONE, GTOTagPrefix.ENCELADUS_STONE, GTOTagPrefix.VENUS_STONE));
        OREBuilder.put((Object)GTMaterials.Kyanite, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.MARS_STONE, GTOTagPrefix.PLUTO_STONE, GTOTagPrefix.GANYMEDE_STONE));
        OREBuilder.put((Object)GTMaterials.Emerald, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.GANYMEDE_STONE));
        OREBuilder.put((Object)GTMaterials.Aluminium, Set.of(GTOTagPrefix.GANYMEDE_STONE, GTOTagPrefix.MOON_STONE));
        OREBuilder.put((Object)GTMaterials.Platinum, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.ENCELADUS_STONE, GTOTagPrefix.MARS_STONE, GTOTagPrefix.MERCURY_STONE));
        OREBuilder.put((Object)GTMaterials.Ilmenite, Set.of(GTOTagPrefix.ENCELADUS_STONE, GTOTagPrefix.GANYMEDE_STONE, GTOTagPrefix.MOON_STONE));
        OREBuilder.put((Object)GTOMaterials.Desh, Set.of(GTOTagPrefix.TITAN_STONE, GTOTagPrefix.VENUS_STONE));
        OREBuilder.put((Object)GTMaterials.Bauxite, Set.of(GTOTagPrefix.GANYMEDE_STONE, GTOTagPrefix.MOON_STONE));
        OREBuilder.put((Object)GTMaterials.TricalciumPhosphate, Set.of(GTOTagPrefix.MARS_STONE, GTOTagPrefix.PLUTO_STONE, GTOTagPrefix.TITAN_STONE));
        OREBuilder.put((Object)GTMaterials.Quartzite, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.PLUTO_STONE));
        OREBuilder.put((Object)GTMaterials.Lead, Set.of(GTOTagPrefix.ENCELADUS_STONE, GTOTagPrefix.PLUTO_STONE, GTOTagPrefix.VENUS_STONE));
        OREBuilder.put((Object)GTMaterials.Pyrope, Set.of(GTOTagPrefix.TITAN_STONE));
        OREBuilder.put((Object)GTMaterials.YellowLimonite, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.IO_STONE, GTOTagPrefix.MARS_STONE, GTOTagPrefix.CERES_STONE, GTOTagPrefix.TITAN_STONE, GTOTagPrefix.VENUS_STONE));
        OREBuilder.put((Object)GTMaterials.Tungstate, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.MARS_STONE, GTOTagPrefix.CERES_STONE));
        OREBuilder.put((Object)GTMaterials.Pentlandite, Set.of(GTOTagPrefix.CERES_STONE, GTOTagPrefix.MERCURY_STONE, GTOTagPrefix.GANYMEDE_STONE, GTOTagPrefix.MOON_STONE));
        OREBuilder.put((Object)GTMaterials.Graphite, Set.of(GTOTagPrefix.IO_STONE, GTOTagPrefix.VENUS_STONE));
        OREBuilder.put((Object)GTMaterials.Diatomite, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.MARS_STONE, GTOTagPrefix.MERCURY_STONE, GTOTagPrefix.TITAN_STONE, GTOTagPrefix.MOON_STONE));
        OREBuilder.put((Object)GTMaterials.Cinnabar, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.ENCELADUS_STONE));
        OREBuilder.put((Object)GTMaterials.Lazurite, Set.of(GTOTagPrefix.GLACIO_STONE));
        OREBuilder.put((Object)GTMaterials.Grossular, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.CERES_STONE, GTOTagPrefix.MERCURY_STONE));
        OREBuilder.put((Object)GTMaterials.RockSalt, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.CERES_STONE, GTOTagPrefix.VENUS_STONE, GTOTagPrefix.MARS_STONE));
        OREBuilder.put((Object)GTOMaterials.Zircon, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.PLUTO_STONE));
        OREBuilder.put((Object)GTMaterials.Monazite, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.CERES_STONE, GTOTagPrefix.MOON_STONE));
        OREBuilder.put((Object)GTMaterials.Molybdenum, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.IO_STONE, GTOTagPrefix.ENCELADUS_STONE, GTOTagPrefix.VENUS_STONE));
        OREBuilder.put((Object)GTMaterials.Powellite, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.IO_STONE, GTOTagPrefix.ENCELADUS_STONE, GTOTagPrefix.VENUS_STONE));
        OREBuilder.put((Object)GTMaterials.Plutonium239, Set.of(GTOTagPrefix.IO_STONE, GTOTagPrefix.PLUTO_STONE));
        OREBuilder.put((Object)GTMaterials.Olivine, Set.of(GTOTagPrefix.IO_STONE, GTOTagPrefix.CERES_STONE, GTOTagPrefix.VENUS_STONE));
        OREBuilder.put((Object)GTMaterials.Chalcopyrite, Set.of(GTOTagPrefix.ENCELADUS_STONE, GTOTagPrefix.MARS_STONE, GTOTagPrefix.CERES_STONE, GTOTagPrefix.MERCURY_STONE, GTOTagPrefix.GANYMEDE_STONE));
        OREBuilder.put((Object)GTMaterials.Bastnasite, Set.of(GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.CERES_STONE, GTOTagPrefix.MOON_STONE));
        OREBuilder.put((Object)GTMaterials.Wulfenite, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.IO_STONE, GTOTagPrefix.ENCELADUS_STONE, GTOTagPrefix.VENUS_STONE));
        OREBuilder.put((Object)GTMaterials.Pitchblende, Set.of(GTOTagPrefix.PLUTO_STONE, GTOTagPrefix.TITAN_STONE, GTOTagPrefix.MOON_STONE));
        OREBuilder.put((Object)GTMaterials.FullersEarth, Set.of(GTOTagPrefix.IO_STONE, GTOTagPrefix.MARS_STONE));
        OREBuilder.put((Object)GTMaterials.Diamond, Set.of(GTOTagPrefix.IO_STONE, GTOTagPrefix.VENUS_STONE));
        OREBuilder.put((Object)GTMaterials.GreenSapphire, Set.of(GTOTagPrefix.TITAN_STONE));
        OREBuilder.put((Object)GTMaterials.Hematite, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.IO_STONE, GTOTagPrefix.MARS_STONE, GTOTagPrefix.CERES_STONE, GTOTagPrefix.TITAN_STONE, GTOTagPrefix.VENUS_STONE));
        OREBuilder.put((Object)GTMaterials.Tantalite, Set.of(TagPrefix.oreNetherrack, GTOTagPrefix.GLACIO_STONE, GTOTagPrefix.CERES_STONE, GTOTagPrefix.MERCURY_STONE, GTOTagPrefix.PLUTO_STONE));
        OREBuilder.put((Object)GTMaterials.Lapis, Set.of(GTOTagPrefix.GLACIO_STONE));
        OREBuilder.put((Object)GTOMaterials.PerditioCrystal, Set.of(GTOTagPrefix.LIVING_STONE));
        OREBuilder.put((Object)GTOMaterials.GnomeCrystal, Set.of(GTOTagPrefix.LIVING_STONE));
        OREBuilder.put((Object)GTOMaterials.SalamanderCrystal, Set.of(GTOTagPrefix.LIVING_STONE));
        OREBuilder.put((Object)GTOMaterials.UndineCrystal, Set.of(GTOTagPrefix.LIVING_STONE));
        OREBuilder.put((Object)GTOMaterials.SylphCrystal, Set.of(GTOTagPrefix.LIVING_STONE));
        OREBuilder.put((Object)GTOMaterials.ManaDiamond, Set.of(GTOTagPrefix.LIVING_STONE));
        OREBuilder.put((Object)GTOMaterials.SourceGem, Set.of(GTOTagPrefix.LIVING_STONE));
        OREBuilder.put((Object)GTOMaterials.Manasteel, Set.of(GTOTagPrefix.LIVING_STONE));
        OREBuilder.put((Object)GTOMaterials.Dragonstone, Set.of(GTOTagPrefix.LIVING_STONE));
        OREBuilder.put((Object)GTOMaterials.Elementium, Set.of(GTOTagPrefix.LIVING_STONE));
        OREBuilder.put((Object)GTOMaterials.InfusedGold, Set.of(GTOTagPrefix.LIVING_STONE));
        OREBuilder.put((Object)GTOMaterials.GaiaCore, Set.of(GTOTagPrefix.LIVING_STONE));
        OREBuilder.put((Object)GTOMaterials.NetherEmber, Set.of(GTOTagPrefix.LIVING_STONE));
        OREBuilder.put((Object)GTOMaterials.Thaumium, Set.of(GTOTagPrefix.LIVING_STONE));
        OREBuilder.put((Object)GTOMaterials.OriginCoreCrystal, Set.of(GTOTagPrefix.LIVING_STONE));
        OREBuilder.put((Object)GTOMaterials.StarBloodCrystal, Set.of(GTOTagPrefix.LIVING_STONE));
        OREBuilder.put((Object)GTOMaterials.SoulJadeCrystal, Set.of(GTOTagPrefix.LIVING_STONE));
        OREBuilder.put((Object)GTOMaterials.RemnantSpiritStone, Set.of(GTOTagPrefix.LIVING_STONE));
        ORE_MAP = OREBuilder.build();
    }
}

